/* block.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _BLOCK_H
#define _BLOCK_H

#include <libxml/tree.h>

struct block {
  /* Name */
  char *name;
  /* Number of tracks */
  unsigned short tracks;
  /* Number of lines */
  unsigned short length;
  /* Notation data */
  unsigned char *notes;
  /* Number of effect pages */
  unsigned short effectpages;
  /* Effect block array */
  unsigned char *effects;
};

struct block *block_alloc(int, int, int);
void block_free(struct block *);
void block_set_note(struct block *, unsigned short, unsigned short,
		   unsigned char, unsigned char, unsigned char);
void block_set_instrument(struct block *, unsigned short, unsigned short,
			  unsigned char);
void block_set_effect(struct block *, unsigned short, unsigned short,
		      unsigned short, unsigned char, unsigned char);
void block_set_effect_full(struct block *, unsigned short,
			   unsigned short, unsigned short,
			   unsigned char, unsigned char);
void block_set_tracks(struct block *, unsigned short);
void block_set_length(struct block *, unsigned short);
void block_set_effectpages(struct block *, unsigned short);
struct block *block_parse(xmlDocPtr, xmlNsPtr, xmlNodePtr);
void block_save(struct block *, xmlNodePtr);

#endif
