/* gui.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GUI_H
#define _GUI_H

/* Main window functions */
void gui_create();
void gui_main_refresh();
void gui_main_show();
void gui_main_octave_activate(GtkMenuItem *, gpointer);
void gui_main_toggled(GtkToggleButton *, gpointer);
void gui_main_changed(GtkAdjustment *, gpointer);

/* Tracker functions */
static int tracker_keyevent (GtkWidget *, GdkEventKey *, gpointer);

/* Info functions */
void gui_info_refresh();
void gui_timer_refresh(unsigned int);

/* Tempo window functions */
void gui_tempo_show();
void gui_tempo_hide();
void gui_tempo_changed(GtkAdjustment *, gpointer);

/* Section list window functions */
void gui_section_show();
void gui_section_hide();
void gui_section_refresh();
void gui_section_select_row(GtkWidget *, gint, gint, GdkEventButton *, gpointer);
void gui_section_insnew();
void gui_section_appnew();
void gui_section_delete();
void gui_section_previous();
void gui_section_next();
void gui_section_activate_name(GtkWidget *, GtkWidget *);

/* Playing sequence window functions */
void gui_playseq_show();
void gui_playseq_hide();
void gui_playseq_refresh();
void gui_playseq_select_row(GtkWidget *, gint, gint, GdkEventButton *, gpointer);
void gui_playseq_insnew();
void gui_playseq_appnew();
void gui_playseq_delete();
void gui_playseq_previous();
void gui_playseq_next();

/* Block list window functions */
void gui_blocklist_show();
void gui_blocklist_hide();
void gui_blocklist_refresh();
void gui_blocklist_select_row(GtkWidget *, gint, gint, GdkEventButton *, gpointer);
void gui_blocklist_activate_name(GtkWidget *, GtkWidget *);
void gui_blocklist_insnew();
void gui_blocklist_appnew();
void gui_blocklist_delete();
void gui_blocklist_tracks_changed(GtkAdjustment *, gpointer);
void gui_blocklist_length_changed(GtkAdjustment *, gpointer);
void gui_blocklist_effectpages_changed(GtkAdjustment *, gpointer);

/* Instrument properties window functions */
void gui_instrument_show();
void gui_instrument_hide();
void gui_instrument_volume_changed(GtkAdjustment *, gpointer);
void gui_instrument_midichannel_changed(GtkAdjustment *, gpointer);
void gui_instrument_transpose_changed(GtkAdjustment *, gpointer);
void gui_instrument_hold_changed(GtkAdjustment *, gpointer);

#endif
