/* player.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PLAYER_H
#define _PLAYER_H

void play_song();
void continue_song();
void play_block();
void continue_block();
void stop();

/* SIGALRT signal handler for triggering the playroutine */
void play_handler(int);
/* Sets the timer structure according to a given BPM count */
void play_set_timer(unsigned short);
/* Plays a note using given instrument on a given channel */
void play_note(unsigned short, unsigned char, unsigned char, unsigned char);
/* Stops notes playing at the moment */
void stop_notes();
/* Stops all notes */
void stop_all_notes();
void refresh_playseq_and_block();

#endif
