/* keyboard.c
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "editor.h"
#include "trackerwidget.h"

extern struct editor editor;
extern GtkWidget *gui_main_tracker, *gui_main_edit, *gui_main_octave;

int keyboard_event(GtkWidget *widget, GdkEventKey *event, gpointer data) {
  Tracker *tracker=(Tracker *)gui_main_tracker;
  gboolean pressed=(gboolean)data;
  int shift=event->state & GDK_SHIFT_MASK;
  int ctrl=event->state & GDK_CONTROL_MASK;
  int alt=event->state & GDK_MOD1_MASK;
  int i;

  if(pressed)
    if(ctrl) {
      switch (event->keyval) {
      case 'c':
      case 'q':
	gtk_main_quit();
	break;
      }
    } else {
      char instrument=-1;
      char note=-1;
      if(editor.edit) {
	char data=-1;
	switch(tracker->cursor_item) {
	case 0:
	  switch(event->keyval) {
	  case 'z':
	    data=1;
	    break;
	  case 's':
	    data=2;
	    break;
	  case 'x':
	    data=3;
	    break;
	  case 'd':
	    data=4;
	    break;
	  case 'c':
	    data=5;
	    break;
	  case 'v':
	    data=6;
	    break;
	  case 'g':
	    data=7;
	    break;
	  case 'b':
	    data=8;
	    break;
	  case 'h':
	    data=9;
	    break;
	  case 'n':
	    data=10;
	    break;
	  case 'j':
	    data=11;
	    break;
	  case 'm':
	    data=12;
	    break;
	  case 'q':
	  case ',':
	    data=13;
	    break;
	  case '2':
	  case 'l':
	    data=14;
	    break;
	  case 'w':
	  case '.':
	    data=15;
	    break;
	  case '3':
	  case '':
	    data=16;
	    break;
	  case 'e':
	  case '-':
	    data=17;
	    break;
	  case 'r':
	    data=18;
	    break;
	  case '5':
	    data=19;
	    break;
	  case 't':
	    data=20;
	    break;
	  case '6':
	    data=21;
	    break;
	  case 'y':
	    data=22;
	    break;
	  case '7':
	    data=23;
	    break;
	  case 'u':
	    data=24;
	    break;
	  case 'i':
	    data=25;
	    break;
	  case '9':
	    data=26;
	    break;
	  case 'o':
	    data=27;
	    break;
	  case '0':
	    data=28;
	    break;
	  case 'p':
	    data=29;
	    break;
	  case GDK_Delete:
	    data=0;
	    break;
	  }
	  if(data!=-1) {
	    block_set_note(editor.song->blocks[editor.block], tracker->patpos,
			   tracker->cursor_ch, editor.octave, data,
			   editor.instrument+1);
	    tracker_redraw_row((Tracker *)gui_main_tracker, tracker->patpos);
	    tracker_step_cursor_row((Tracker *)gui_main_tracker, editor.space);
	  }
	  break;
	case 1:
	  if(event->keyval>='0' && event->keyval<='9')
	    data=event->keyval-'0';
	  else if(event->keyval>='a' && event->keyval<='z')
	    data=10+event->keyval-'a';
	  else if(event->keyval==GDK_Delete)
	    data=0;

	  if(data!=-1) {
	    block_set_instrument(editor.song->blocks[editor.block],
				 tracker->patpos, tracker->cursor_ch,
				 data);
	    tracker_redraw_row((Tracker *)gui_main_tracker, tracker->patpos);
	    tracker_step_cursor_row((Tracker *)gui_main_tracker, 1);
	  }
	  break;
	case 2:
	case 3:
	case 4:
	case 5:
	  if(event->keyval>='0' && event->keyval<='9')
	    data=event->keyval-'0';
	  else if(event->keyval>='a' && event->keyval<='f')
	    data=10+event->keyval-'a';
	  else if(event->keyval==GDK_Delete)
	    data=0;

	  if(data!=-1) {
	    block_set_effect(editor.song->blocks[editor.block],
			     tracker->patpos, tracker->cursor_ch, 0,
			     tracker->cursor_item-2, data);
	    tracker_redraw_row((Tracker *)gui_main_tracker, tracker->patpos);
	    tracker_step_cursor_row((Tracker *)gui_main_tracker, 1);
	  }
	  break;
	}
      }
      switch (event->keyval) {
      case GDK_space:
	/* If the song is playing, stop */
	if(editor.mode!=MODE_IDLE)
	  stop();
	else {
	  /* Otherwise toggle edit mode */
	  editor.edit^=1;
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gui_main_edit),
				       editor.edit);
	}
	break;
      case GDK_F1:
      case GDK_F2:
      case GDK_F3:
      case GDK_F4:
      case GDK_F5:
      case GDK_F6:
      case GDK_F7:
      case GDK_F8:
      case GDK_F9:
      case GDK_F10:
      case GDK_F11:
	gtk_option_menu_set_history(GTK_OPTION_MENU(gui_main_octave),
				    event->keyval-GDK_F1);
	editor.octave=event->keyval-GDK_F1;
	break;
      case GDK_Num_Lock:
	instrument=0;
	break;
      case GDK_KP_Divide:
	instrument=1;
	break;
      case GDK_KP_Multiply:
	instrument=2;
	break;
      case GDK_KP_Subtract:
	instrument=3;
	break;
      case GDK_KP_7:
      case GDK_KP_Home:
	instrument=4;
	break;
      case GDK_KP_8:
      case GDK_KP_Up:
	instrument=5;
	break;
      case GDK_KP_9:
      case GDK_KP_Page_Up:
	instrument=6;
	break;
      case GDK_KP_Add:
	instrument=7;
	break;
      case GDK_KP_4:
      case GDK_KP_Left:
	instrument=8;
	break;
      case GDK_KP_5:
      case GDK_KP_Begin:
	instrument=9;
	break;
      case GDK_KP_6:
      case GDK_KP_Right:
	instrument=10;
	break;
      case GDK_KP_1:
      case GDK_KP_End:
	instrument=11;
	break;
      case GDK_KP_2:
      case GDK_KP_Down:
	instrument=12;
	break;
      case GDK_KP_3:
      case GDK_KP_Page_Down:
	instrument=13;
	break;
      case GDK_KP_Enter:
	instrument=14;
	break;
      case GDK_KP_0:
      case GDK_KP_Insert:
	instrument=15;
	break;
      case GDK_KP_Decimal:
      case GDK_KP_Delete:
	instrument=16;
	break;
      case 'z':
	note=0;
	break;
      case 's':
	note=1;
	break;
      case 'x':
	note=2;
	break;
      case 'd':
	note=3;
	break;
      case 'c':
	note=4;
	break;
      case 'v':
	note=5;
	break;
      case 'g':
	note=6;
	break;
      case 'b':
	note=7;
	break;
      case 'h':
	note=8;
	break;
      case 'n':
	note=9;
	break;
      case 'j':
	note=10;
	break;
      case 'm':
	note=11;
	break;
      case 'q':
      case ',':
	note=12;
	break;
      case '2':
      case 'l':
	note=13;
	break;
      case 'w':
      case '.':
	note=14;
	break;
      case '3':
      case '':
	note=15;
	break;
      case 'e':
      case '-':
	note=16;
	break;
      case 'r':
	note=17;
	break;
      case '5':
	note=18;
	break;
      case 't':
	note=19;
	break;
      case '6':
	note=20;
	break;
      case 'y':
	note=21;
	break;
      case '7':
	note=22;
	break;
      case 'u':
	note=23;
	break;
      case 'i':
	note=24;
	break;
      case '9':
	note=25;
	break;
      case 'o':
	note=26;
	break;
      case '0':
	note=27;
	break;
      case 'p':
	note=28;
	break;
      case '':
	note=29;
	break;
      case GDK_Down:
	tracker_step_cursor_row((Tracker *)gui_main_tracker, 1);
	break;
      case GDK_Up:
	tracker_step_cursor_row((Tracker *)gui_main_tracker, -1);
	break;
      case GDK_Left:
	tracker_step_cursor_item((Tracker *)gui_main_tracker, -1);
	break;
      case GDK_Right:
	tracker_step_cursor_item((Tracker *)gui_main_tracker, 1);
	break;
      case GDK_Tab:
	tracker_step_cursor_channel((Tracker *)gui_main_tracker, 1);
	break;
      case GDK_ISO_Left_Tab:
	tracker_step_cursor_channel((Tracker *)gui_main_tracker, -1);
	break;
      }

      /* Select an instrument if an instrument selection key was pressed */
      if(instrument!=-1) {
	editor.instrument=instrument;
	
	/* Make sure the instrument exists */
	if(instrument>=editor.song->numinstruments ||
	   editor.song->instruments[instrument]==NULL) {
	  if(instrument>=editor.song->numinstruments) {
	    editor.song->instruments=realloc(editor.song->instruments,
					     (instrument+1)*sizeof(struct instrument *));
	    for(i=editor.song->numinstruments; i<(instrument+1); i++)
	      editor.song->instruments[i]=NULL;

	    editor.song->numinstruments=instrument+1;
	  }
	  editor.song->instruments[instrument]=instrument_alloc();
	}

	gui_instrument_refresh();
      }

      /* Play note if a key was pressed but not if cursor is in command pos */
      if(note!=-1 && tracker->cursor_item==0)
	play_note(editor.instrument, editor.octave*12+note, 127,
		  tracker->cursor_ch);
    }

  if(pressed) {
    gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
  } else {
    gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_release_event");
  }
  
  return TRUE;
}

