/* song.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _SONG_H
#define _SONG_H

#include "mmd.h"
#include "playseq.h"
#include "block.h"
#include "instrument.h"

struct song {
  /* Name of the song */
  char *name;
  /* Tempo, ticks per line */
  unsigned char tempo, ticksperline;
  /* Number of sections */
  unsigned short numsections;
  /* Section array */
  unsigned short *sections;
  /* Number of blocks */
  unsigned short numplayseqs;
  /* Playing sequence array */
  struct playseq **playseqs;
  /* Number of blocks */
  unsigned short numblocks;
  /* Block array */
  struct block **blocks;
  /* Number of instruments */
  unsigned short numinstruments;
  /* Instrument array */
  struct instrument **instruments;
  /* Maximum number of tracks */
  unsigned short maxtracks;
  /* Track volume array */
  unsigned char *trackvolumes;
  /* Master volume */
  unsigned char mastervolume;
};

struct song *song_alloc(void);
void song_free(struct song *);
void song_insert_block(struct song *, int);
void song_delete_block(struct song *, int);
void song_insert_playseq(struct song *, int);
void song_delete_playseq(struct song *, int);
void song_insert_section(struct song *, int);
void song_delete_section(struct song *, int);
void song_set_section(struct song *, int, int);
void song_set_tpl(struct song *, unsigned char);
void song_set_tempo(struct song *, unsigned char);
int song_check_maxtracks(struct song *);
struct song *song_convert_MMD2(struct MMD2 *);
struct song *song_load(char *);
struct song *song_parse(xmlDocPtr, xmlNsPtr, xmlNodePtr);
void song_save(struct song *, char *);

#endif
