/* callbacks.h
 *
 * Copyright 2002 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>

void gui_open();
void gui_instrument_refresh();
void gui_tempo_refresh();
void gui_info_refresh();
void gui_timer_refresh(unsigned int);
void gui_blocklist_refresh();
void gui_playseq_refresh();
void gui_sectionlist_refresh();
void gui_sysexlist_refresh();
void gui_trackvolumes_refresh();
void gui_song_refresh();

void
on_gui_menuitem_file_new_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_file_open_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_file_save_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_file_saveas_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_file_print_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_file_exit_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_edit_cut_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_edit_copy_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_edit_paste_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_edit_clear_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_song_tempo_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_song_trackvolumes_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_song_properties_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_block_cut_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_block_copy_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_block_paste_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_block_selectall_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_block_clear_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_block_list_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_track_cut_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_track_copy_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_track_paste_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_track_selectall_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_track_clear_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_song_sysexlist_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_midi_killallnotes_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_midi_resetpitch_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_settings_preferences_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_menuitem_about_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_gui_button_playsong_clicked         (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_playblock_clicked        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_contsong_clicked         (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_contblock_clicked        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_stop_clicked             (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_entry_instrument_changed        (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_button_properties_clicked       (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_checkbutton_edit_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_gui_checkbutton_chord_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_gui_spinbutton_space_changed        (GtkEditable     *editable,
                                        gpointer         user_data);

GtkWidget*
create_gui_tracker (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2);

void
on_gui_button_section_clicked          (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_position_clicked         (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_block_clicked            (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_timer_clicked            (GtkButton       *button,
                                        gpointer         user_data);

gboolean
keyboard_event                         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

gboolean
keyboard_event                         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

gboolean
keyboard_event                         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

gboolean
keyboard_event                         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

void
on_gui_button_section_clicked          (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_position_clicked         (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_block_clicked            (GtkButton       *button,
                                        gpointer         user_data);

gboolean
keyboard_event                         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data);

void
on_gui_button_properties_clicked       (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_tempo_close_clicked      (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_trackvolumes_close_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

gboolean
on_gui_label_timer_button_press_event  (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

void
on_gui_clist_sysex_select_row          (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_gui_button_sysex_appendnew_clicked  (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_sysex_delete_clicked     (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_sysex_insertnew_clicked  (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_sysex_send_clicked       (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_sysex_receive_clicked    (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_checkbutton_sysex_autostop_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_gui_clist_sectionlist_select_row    (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_gui_button_sectionlist_next_clicked (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_sectionlist_delete_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_sectionlist_append_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_sectionlist_prev_clicked (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_sectionlist_insert_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_clist_playseq_select_row        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_gui_button_playseq_next_clicked     (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_playseq_delete_clicked   (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_playseq_append_clicked   (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_playseq_prev_clicked     (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_playseq_insert_clicked   (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_entry_playseq_name_changed      (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_button_playseq_insertnew_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_playseq_appendnew_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_playseq_deletethis_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_clist_blocklist_select_row      (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_gui_entry_blocklist_changed         (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_spinbutton_blocklist_tracks_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_spinbutton_blocklist_length_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_spinbutton_blocklist_commandpages_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_button_blocklist_insertnew_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_blocklist_appendnew_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_blocklist_delete_clicked (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_entry_sysex_name_activate       (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_entry_playseq_name_activate     (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_entry_blocklist_activate        (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_gui_entry_instrumentproperties_name_activate
                                        (GtkEditable     *editable,
                                        gpointer         user_data);

gboolean
on_gui_entry_blocklist_focus_out_event (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data);

gboolean
on_gui_entry_instrument_focus_out_event
                                        (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data);

gboolean
on_gui_entry_sysex_name_focus_out_event
                                        (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data);

gboolean
on_gui_entry_playseq_name_focus_out_event
                                        (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data);

gboolean
on_gui_entry_instrumentproperties_name_focus_out_event
                                        (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data);

void
on_gui_button_sysex_close_clicked      (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_saveas_ok_clicked        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_open_ok_clicked          (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_open_cancel_clicked      (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_button_saveas_cancel_clicked    (GtkButton       *button,
                                        gpointer         user_data);

gboolean
on_gui_entry_instrumentproperties_name_focus_out_event
                                        (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data);

void
on_gui_spinbutton_sysex_length_changed (GtkEditable     *editable,
                                        gpointer         user_data);

gboolean
on_gui_entry_songname_focus_out_event  (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data);

void
on_gui_button_songproperties_close_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_gui_spinbutton_instrument_changed   (GtkEditable     *editable,
                                        gpointer         user_data);

void on_gui_adjustment_trackvolumes_changed(GtkAdjustment *adjustment,
					    gpointer user_data);

void on_gui_togglebutton_trackvolumes_toggled(GtkToggleButton *togglebutton,
					      gpointer user_data);
