/* tutoterm.c -- main graphic functions for TutoTerm
 *
 * Copyright © 2017 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <vte/vte.h>
#include <string.h>

#include <libintl.h>
#include "../config.h"
#define _(String) gettext (String)
#include "../include/index_win.h"
#include "../include/input_output.h"
#include "../include/liststore.h"
#include "../include/tutoterm.h"

/* TODO: write a description
 *
 */
void
activate (GtkApplication* app, gpointer user_data)
{
  // Declarations
  gchar **arg;
  GtkWidget
    *ttBar,
    *ttIndexButton,
    *ttLabel,
    *ttMainWindow,
    *ttPaned,
    *ttScrollWin,
    *ttTerm,
    *ttVTextBox;

  GtkListStore* ttListStore;
  ttListStore = get_liststore ();

  // Window
  ttMainWindow = gtk_application_window_new (app);
  gtk_window_set_default_size (GTK_WINDOW (ttMainWindow), 650, 450);

  // HeaderBar
  ttBar = gtk_header_bar_new ();
  gtk_header_bar_set_title ((GtkHeaderBar*) ttBar, "TutoTerm");
  gtk_header_bar_set_subtitle ((GtkHeaderBar*) ttBar,
			       _("The educational terminal!"));
  gtk_header_bar_set_show_close_button ((GtkHeaderBar*) ttBar, TRUE);
  ttIndexButton = gtk_button_new_from_icon_name ("help",
						 GTK_ICON_SIZE_LARGE_TOOLBAR);
  g_signal_connect (ttIndexButton,
		    "clicked", 
		    G_CALLBACK (index_window),
		    ttListStore);
  gtk_container_add (GTK_CONTAINER (ttBar), ttIndexButton);
  gtk_window_set_titlebar (GTK_WINDOW (ttMainWindow), ttBar);
  
  // Vertical paned widget
  ttPaned = gtk_paned_new (GTK_ORIENTATION_VERTICAL);
  gtk_container_add (GTK_CONTAINER (ttMainWindow), ttPaned);

  // Tutorial area
  ttScrollWin = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_min_content_height
    (GTK_SCROLLED_WINDOW (ttScrollWin), 150);
  ttVTextBox = gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);

  ttLabel = gtk_label_new (_("Welcome on TutoTerm!"));
  gtk_label_set_line_wrap (GTK_LABEL (ttLabel), TRUE);
  gtk_label_set_xalign (GTK_LABEL (ttLabel), 0);
  gtk_widget_set_margin_start (ttLabel, 10);
  gtk_box_pack_start (GTK_BOX (ttVTextBox), ttLabel, FALSE, FALSE, 10);

  ttExample = gtk_revealer_new ();
  gtk_revealer_set_transition_type (GTK_REVEALER (ttExample),
				    GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
  gtk_revealer_set_transition_duration (GTK_REVEALER (ttExample), 500);

  ttLabelExample = gtk_label_new ("");
  gtk_label_set_xalign (GTK_LABEL (ttLabelExample), 0);
  gtk_widget_set_margin_start (ttLabelExample, 20);

  gtk_container_add (GTK_CONTAINER (ttExample), ttLabelExample);
  gtk_box_pack_start (GTK_BOX (ttVTextBox), ttExample, TRUE, TRUE, 1);
  
  gtk_container_add (GTK_CONTAINER (ttScrollWin), ttVTextBox);
  gtk_paned_add1 (GTK_PANED (ttPaned), ttScrollWin);

  // Terminal
  ttTerm = vte_terminal_new ();
  arg = g_new (gchar *, 1);
  arg[0] = g_strdup ("/bin/sh");
  arg[1] = NULL;
  vte_terminal_spawn_async ((VteTerminal*) ttTerm, VTE_PTY_DEFAULT,
			    NULL, arg, NULL, G_SPAWN_SEARCH_PATH, NULL,
			    NULL, NULL, -1, NULL, NULL, user_data);
  gtk_paned_add2 (GTK_PANED (ttPaned), ttTerm);
  
  // Show widgets and wait for any key event
  gtk_widget_show_all (ttMainWindow);
  g_signal_connect (ttMainWindow,
		    "key-release-event",
		    G_CALLBACK(key_event),
		    ttListStore);
}

/* TODO: write a description
 *
 */
GtkWidget*
get_ttlabel (GtkWidget* widget) {
  GList *children;
  children = gtk_container_get_children (GTK_CONTAINER (widget));
  if (!GTK_IS_LABEL (children->data))
    return get_ttlabel (children->data);
  return children->data;
}

/* TODO: write a description
 *
 */
GtkWidget*
get_ttvtextbox (GtkWidget* widget) {
  GList *children;
  children = gtk_container_get_children (GTK_CONTAINER (widget));
  if (!GTK_IS_BOX (children->data))
    return get_ttvtextbox (children->data);
  return children->data;
}

/* TODO: write a description
 *
 */
gboolean
key_event (GtkWidget *ttMainWindow,
	   GdkEventKey *event, GtkListStore* ttListStore)
{
  GtkWidget *ttLabel;
  
  update_input (gdk_keyval_name (event->keyval));
  if (strlen (ttInput) != 0)
    fill_tttext_with_input_description (ttListStore);
  if (strlen (ttText) == 0)
      fill_tttext_with_context_comment (ttListStore);

  ttLabel = get_ttlabel (get_ttvtextbox (ttMainWindow));
  gtk_label_set_markup (GTK_LABEL (ttLabel), ttText);

  if (strlen (ttTextExample) >= 2) {
    gtk_label_set_text (GTK_LABEL (ttLabelExample), ttTextExample);
    gtk_revealer_set_reveal_child (GTK_REVEALER (ttExample), TRUE);
  } else {
    gtk_revealer_set_reveal_child (GTK_REVEALER (ttExample), FALSE);
  }
  return FALSE;
}
