/* liststore.c -- parse, store and prepare data for TutoTerm
 *
 * Copyright © 2017,2019 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#include <libintl.h>
#include "../config.h"
#define _(String) gettext (String)
#include "../include/liststore.h"

GtkListStore*
get_liststore ()
{
  GtkListStore *ttListStore;
  GtkTreeIter iter;
  GKeyFile* desc_File;
  GKeyFileFlags flags;
  GError *error = NULL;
  gsize i, length;
  gchar **commands, *command, *filename, *description, *example, *postText;
  
  ttListStore = gtk_list_store_new (4,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_STRING);
  // Load the GKeyFile
  asprintf (&filename,
	    "%s/share/tutoterm/command-descriptions.ini",
	    ROOT_DIR);
  flags = G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS;
  desc_File = g_key_file_new ();
  if (!g_key_file_load_from_file (desc_File, filename, flags, &error)) {
    g_error (error->message);
    exit (1);
  }
  commands = g_key_file_get_groups (desc_File, &length);

  // Parse each [command] key/values
  for (i = 0; i < length; i++) {
    command = commands[i];
    description = g_strcompress
      (g_key_file_get_locale_string (desc_File,
				     command, "Description",
				     NULL, NULL));
    example = g_strcompress
      (g_key_file_get_locale_string (desc_File,
				     command, "Example",
				     NULL, NULL));
    postText = g_strcompress
      (g_key_file_get_locale_string (desc_File,
				     command, "PostText",
				     NULL, NULL));
    // Store it in our GtkListStore
    gtk_list_store_append (ttListStore, &iter);
    gtk_list_store_set (ttListStore, &iter, 0, command, 1,
			description, 2, example, 3, postText, -1);
    g_free (description);
    g_free (example);
    g_free (postText);
  }
  return ttListStore;
}
