/* tutoterm.h -- header file for app functions
 *
 * Copyright © 2017,2019 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __TUTOTERM_H
#define __TUTOTERM_H

#include <gtk/gtk.h>

void	   activate               (GtkApplication*    app,
				   gpointer	      user_data);
GtkWidget* get_ttlabel            (GtkWidget*         widget);
GtkWidget* get_ttvtextbox         (GtkWidget*         widget);
gboolean   key_event              (GtkWidget*         ttMainWindow,
				   GdkEventKey*	      event,
				   GtkListStore*      ttListStore);
void       preferences_activated  (GSimpleAction     *action,
				   GVariant	     *parameter,
				   gpointer	      user_data);
void       quit_activated         (GSimpleAction     *action,
				   GVariant	     *parameter,
				   gpointer	      user_data);

GtkWidget *ttExample, *ttLabelExample;
//const char *accels[] = {"<Contol>Q", NULL};

#endif /* __TUTOTERM_H */
