/* tutoterm_window.h -- header file for window functions
 *
 * Copyright © 2017,2019-2020 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __TUTOTERM_WINDOW_H
#define __TUTOTERM_WINDOW_H

#include <gtk/gtk.h>

#define TUTOTERM_WINDOW_TYPE (tutoterm_window_get_type ())
G_DECLARE_FINAL_TYPE (TutotermWindow,
		      tutoterm_window,
		      TUTOTERM, APP_WINDOW,
		      GtkApplicationWindow)

struct _TutotermWindow
{
  GtkApplicationWindow parent;

  GtkWidget *ttExample;
  GtkWidget *ttLabelExample;
};

// Members

TutotermWindow* tutoterm_window_new             (Tutoterm      *app);
GtkWidget*	tutoterm_window_get_label       (GtkWidget     *widget);
GtkWidget*	tutoterm_window_get_vtextbox    (GtkWidget     *widget);
gboolean        tutoterm_window_key_event       (GtkWidget     *ttMainWindow,
						 GdkEventKey   *event,
						 GtkListStore  *ttListStore);
void            tutoterm_window_prefs_activated (GSimpleAction *action,
						 GVariant	 *parameter,
						 gpointer	  user_data);
void            tutoterm_window_quit_activated  (GSimpleAction *action,
						 GVariant	 *parameter,
						 gpointer	  user_data);

#endif /* __TUTOTERM_WINDOW_H */
