/* main.c -- main file of TutoTerm
 *
 * Copyright © 2017,2019-2020 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include "../config.h"
#include <glib/gi18n-lib.h>
#include <locale.h>
#include "../include/tutoterm.h"

int
main (int argc, char **argv)
{
  Tutoterm *app;
  int status;
  
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (PACKAGE);
  
  // Logging and debugging
  g_log_set_handler (G_LOG_DOMAIN,
		     G_LOG_LEVEL_MASK | G_LOG_FLAG_FATAL,
		     g_log_default_handler,
		     NULL);
  
  // Initialization and execution
  app = tutoterm_new ();
  status = g_application_run (G_APPLICATION (app), argc, argv);
  
  g_object_unref (app);
  return status;
}
