/* tutoterm.c -- main graphic functions for TutoTerm
 *
 * Copyright © 2017,2019 Félicien Pillot <felicien@gnu.org>
 * This file is part of TutoTerm.
 * 
 * TutoTerm is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * TutoTerm is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with TutoTerm.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <string.h>
#include "../config.h"
#include <glib/gi18n-lib.h>

#include "../include/tutoterm.h"
#include "../include/tutoterm_window.h"

G_DEFINE_TYPE (Tutoterm, tutoterm,
	       GTK_TYPE_APPLICATION);

void
tutoterm_init (Tutoterm *app)
{
  (void) app;
}

/**
 * preferences_activated:
 * @action: a @GSimpleAction
 * @parameter: a @GVariant
 * @user_data: a @gpointer
 */
void
preferences_activated (GSimpleAction *action,
		       GVariant      *parameter,
		       gpointer       user_data)
{
  (void) action;
  (void) parameter;
  (void) user_data;
  g_message (_("Opening Preferences window..."));
}

/**
 * quit_activated:
 * @action: a @GSimpleAction
 * @parameter: a @GVariant
 * @user_data: a @gpointer
 */
void
quit_activated (GSimpleAction *action,
		GVariant      *parameter,
		gpointer       app)
{
  (void) action;
  (void) parameter;
  g_message (_("Quitting..."));
  g_application_quit (G_APPLICATION (app));
}

static void
tutoterm_startup (GApplication *app)
{
  //  GSettings *ttSettings;
  //  ttSettings = g_settings_new ("org.TutoTerm");
  GtkBuilder *builder;
  GMenu *menu;
  const gchar *quit_accels[3] = {"<Ctrl>D", "<Ctrl>Q", NULL};
  const gchar *preferences_accels[2] = {"<Ctrl>P", NULL};
  
  G_APPLICATION_CLASS (tutoterm_parent_class)->startup (app);
  
  static GActionEntry ttEntries[] =
    { // FIXME: missing fields
     { "preferences", preferences_activated, NULL, NULL, NULL, {0,0,0} },
     { "quit", quit_activated, NULL, NULL, NULL, {0,0,0} }
    };
  
  // GActions & GMenu
  g_action_map_add_action_entries (G_ACTION_MAP (app),
                                   ttEntries, G_N_ELEMENTS (ttEntries),
                                   app);
  
  gtk_application_set_accels_for_action (GTK_APPLICATION (app),
					 "app.quit",
					 quit_accels);
  gtk_application_set_accels_for_action (GTK_APPLICATION (app),
					 "app.preferences",
					 preferences_accels);

  builder = gtk_builder_new_from_resource
    ("/org/nongnu/tutoterm/ui/appmenu.ui");
  
  menu = G_MENU (gtk_builder_get_object (builder, "appmenu"));
  gtk_application_set_menubar (GTK_APPLICATION (app),
			       G_MENU_MODEL (menu));
  g_object_unref (builder);
}

void
tutoterm_activate (GApplication* app)
{
  TutotermWindow *window;

  window = tutoterm_window_new (TUTOTERM_APP (app));
  gtk_window_present (GTK_WINDOW (window));
}

static void
tutoterm_class_init (TutotermClass *class)
{
  G_APPLICATION_CLASS (class)->startup = tutoterm_startup;
  G_APPLICATION_CLASS (class)->activate = tutoterm_activate;
}

Tutoterm*
tutoterm_new (void)
{
  return g_object_new (TUTOTERM_TYPE,
                       "application-id",
		       "org.nongnu.tutoterm",
                       "flags",
		       G_APPLICATION_FLAGS_NONE,
		       NULL);
}
