;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
; PHASE's are phases of string reading
(const REG_PHASE :regular_code)
(const STRING_PHASE :string_chars)
(const CLISP_PHASE :clisp_code)
; precompiled regular expressions
(const _NON_WHITE_RE (regexp:regexp-compile (_+_ (_+_ (_+_ (_+_ (_+_ (_+_ "^[^" #\Space) #\Tab) #\Newline) #\Page) #\Return) "]\\+")))
(const _WHITE_RE (regexp:regexp-compile (_+_ (_+_ (_+_ (_+_ (_+_ (_+_ "^[" #\Space) #\Tab) #\Newline) #\Page) #\Return) "]\\+")))
(const _ALPHA_NUM_RE (regexp:regexp-compile "^\\w\\+"))
(const _CLISP_START_RE (regexp:regexp-compile (_+_ "^" CLISP_START_STRING)))
(const _CLISP_END_RE (regexp:regexp-compile CLISP_END_STRING))
(const _ONE_DIGIT_RE (regexp:regexp-compile "^[0-9]"))
(const _DOT_FLOAT_RE (regexp:regexp-compile (_+_ (_+_ "^\\.[0-9]\\+[esfdlESFDL][+\\-]\\?[0-9]\\+" "\\|") "^\\.[0-9]\\+")))
(const _NUMBER_RE (regexp:regexp-compile (_+_ (_+_ (_+_ (_+_ "^[0-9]\\+\\.\\?[0-9]*[esfdlESFDL][+\\-]\\?[0-9]\\+" "\\|") "^[0-9]\\+\\.[0-9]\\+") "\\|") "^[0-9]\\+\\.\\?")))
(defun makeStrElem (elemType value strNum start end) (new StrElem :type elemType :value value :lineNum strNum :start start :end end))
(defun _startStringPhase (strNum startIndex marks) (tl-append marks (makeStrElem STR_START_ELEM (string #\") ;"
 strNum startIndex (_+_ startIndex 1))) (values (_+_ startIndex 1) STRING_PHASE))
(defun _findEndOfExprInStr (st startIndex termChars) "    Expressions are expected to end by any symbol in termChars. If the first
    return parameter is True, then expression was terminated correctly. If
    it is False, then the end of the line was reached.
    " (do* ((end startIndex)) ((_>=_ end (len st)) (values nil end)) (let (ch) (setf ch (_getitem_ st end)) (cond ((_!=_ (tl-count termChars ch) 0) (return-from nil (values t end))) ((_==_ ch #\\) (cond ((_<_ (_+_ end 1) (len st)) (setf end (_+_ end 2))) (t (setf end (_+_ end 1))))) (t (setf end (_+_ end 1)))))))
(defun _findEndOfExpr (st startIndex termChars) "    Symbol is terminated by one of termChars, or the end of line.
    " (nth-value 1 (_findEndOfExprInStr st startIndex termChars)))
(defun _procStringPhase (initStr strNum startIndex marks) (let (st) (setf st initStr) (let (endingInside end) (setf (values endingInside end) (_findEndOfExprInStr st startIndex (_make-vector_ :initContent (list #\")))) ;"
 (let (elemType phase) (setf (values elemType phase end) (cond (endingInside ; include also ending quote
 (values STR_END_ELEM REG_PHASE (_+_ end 1))) (t (setf st (_+_ st #\Newline)) (values STR_MID_ELEM STRING_PHASE (len st))))) (tl-append marks (makeStrElem elemType (_getitem_ st (_make-slice_ startIndex end nil)) strNum startIndex end)) (values st end phase)))))
(defun _procCLispPhase (st strNum startIndex marks) (let (match) (setf match (regexp:regexp-exec _CLISP_END_RE st :start startIndex)) (let (end codeEnd phase elemType) (setf (values end codeEnd phase elemType) (cond (match (values (_+_ (slot-value match 'regexp::start) (len CLISP_END_STRING)) (slot-value match 'regexp::start) REG_PHASE CLISP_END_ELEM)) (t (values (len st) (len st) CLISP_PHASE CLISP_MID_ELEM)))) (tl-append marks (makeStrElem elemType (_+_ (_getitem_ st (_make-slice_ startIndex codeEnd nil)) #\Newline) strNum startIndex end)) (values end phase))))
(defun _procAmpName (st strNum startIndex marks) ; how long is a symbol?
 (let (end) (setf end (_findEndOfExpr st (_+_ startIndex 1) (_make-vector_ :initContent (list #\Space #\Tab #\( #\) #\, #\:)))) (cond ((_==_ end (_+_ startIndex 1)) ; it is a lone operator &
 (tl-append marks (makeStrElem "&" "&" strNum startIndex (_+_ startIndex 1))) (setf end (_+_ startIndex 1))) (t (tl-append marks (makeStrElem SYMB_ELEM (_getitem_ st (_make-slice_ (_+_ startIndex 1) end nil)) strNum (_+_ startIndex 1) end)))) end))
(defun _OperLen (st startIndex) (let (spChar) (setf spChar (_getitem_ st startIndex)) (cond ((has_key MULTI_CHAR_OPERS spChar) (let (opLen) (setf opLen (tl-for (oper (_getitem_ MULTI_CHAR_OPERS spChar) (highestLenOper nil)) ((len highestLenOper)) (cond ((_==_ (_getitem_ st (_make-slice_ startIndex (_+_ startIndex (len oper)) nil)) oper) (cond ((_<_ (len highestLenOper) (len oper)) (setf highestLenOper oper))))))) (cond ((_==_ opLen 0) 1) (t opLen)))) (t 1))))
(defun _procSpecialChars (st strNum startIndex marks) (let (end) (setf end (_+_ startIndex (_OperLen st startIndex))) (tl-append marks (makeStrElem (_getitem_ st (_make-slice_ startIndex end nil)) (_getitem_ st (_make-slice_ startIndex end nil)) strNum startIndex end)) end))
(defun _procSpecSynt (st strNum startIndex marks) (let (operLen) (setf operLen (_OperLen st startIndex)) (let (end elemType) (setf (values end elemType) (cond ((_>_ operLen 1) (values (_+_ startIndex operLen) (_getitem_ st (_make-slice_ startIndex (_+_ startIndex operLen) nil)))) ((_<_ (_+_ startIndex 1) (len st)) (let (end) (setf end (_findEndOfExpr st (_+_ startIndex 1) (_make-vector_ :initContent (list #\Space #\Tab #\( #\) #\,)))) (cond ((_==_ end (_+_ startIndex 1)) (signalSyntaxError "Empty #-y structure"))) (values end SYNT_STRUCT_ELEM))) (t (signalSyntaxError "Empty #-y structure")))) (tl-append marks (makeStrElem elemType (_getitem_ st (_make-slice_ startIndex end nil)) strNum startIndex end)) end)))
(defun _procDotOrNum (st strNum startIndex marks) (let (match) (setf match (regexp:regexp-exec _DOT_FLOAT_RE st :start startIndex)) (let (end elemType) (setf (values end elemType) (cond (match ; this is a float number, like .34, or .34e-4
 (values (slot-value match 'regexp::end) NUM_ELEM)) (t ; this a dot operator
 (values (_+_ startIndex 1) ".")))) (tl-append marks (makeStrElem elemType (_getitem_ st (_make-slice_ startIndex end nil)) strNum startIndex end)) end)))
(defun _procNum (st strNum startIndex marks) (let (end) (setf end (slot-value (regexp:regexp-exec _NUMBER_RE st :start startIndex) 'regexp::end)) (tl-append marks (makeStrElem NUM_ELEM (_getitem_ st (_make-slice_ startIndex end nil)) strNum startIndex end)) end))
(defun markElemsInStr (st strNum &optional (initPhase REG_PHASE)) (let (marks) (setf marks (_make-vector_)) (let (phase) (setf phase initPhase) (let (startIndex) (setf startIndex 0) (do () ((_>=_ startIndex (len st))) (tl-case phase nil ((STRING_PHASE) (setf (values st startIndex phase) (_procStringPhase st strNum startIndex marks))) ((CLISP_PHASE) (setf (values startIndex phase) (_procCLispPhase st strNum startIndex marks))) ((REG_PHASE) (let (match) (setf match (regexp:regexp-exec _WHITE_RE st :start startIndex)) (cond (match (tl-append marks (makeStrElem WHITE_ELEM nil strNum startIndex (slot-value match 'regexp::end))) (setf startIndex (slot-value match 'regexp::end))) (t (setf match (regexp:regexp-exec _NON_WHITE_RE st :start startIndex)) (let (nonWhiteEnd) (setf nonWhiteEnd (slot-value match 'regexp::end)) (setf match (regexp:regexp-exec _ALPHA_NUM_RE st :start startIndex :end nonWhiteEnd)) (cond ((_not_ match) ; have some special charachter (non alpha-num) in the beginning
 (case (_getitem_ st startIndex) ((#\&) (setf startIndex (_procAmpName st strNum startIndex marks))) ((#\#) (setf startIndex (_procSpecSynt st strNum startIndex marks))) ((#\.) (setf startIndex (_procDotOrNum st strNum startIndex marks))) ((#\") ;"
 (setf (values startIndex phase) (_startStringPhase strNum startIndex marks))) ((#\;) ; semicolomn starts comment, which extends till the end
 (tl-append marks (makeStrElem COMM_ELEM (_getitem_ st (_make-slice_ startIndex (len st) nil)) strNum startIndex (len st))) (setf startIndex (len st))) (otherwise (setf startIndex (_procSpecialChars st strNum startIndex marks))))) (t ; have an alpha-num symbol or a number
 (let (alphaNumEnd) (setf alphaNumEnd (slot-value match 'regexp::end)) (setf match (regexp:regexp-exec _ONE_DIGIT_RE st :start startIndex)) (cond (match (setf startIndex (_procNum st strNum startIndex marks))) (t (setf match (regexp:regexp-exec _CLISP_START_RE st :start startIndex)) (cond (match (tl-append marks (makeStrElem CLISP_START_ELEM nil strNum startIndex nil)) (setf phase CLISP_PHASE) (setf startIndex (slot-value match 'regexp::end))) (t ; have alpha-numeric symbol
 (let (symb) (setf symb (_getitem_ st (_make-slice_ startIndex alphaNumEnd nil))) (let (elType) (setf elType (cond ((_==_ (tl-count SPEC_SYMB symb) 0) SYMB_ELEM) (t (cond ((_==_ (tl-count OPER_SYMB symb) 0) SPEC_SYMB_ELEM) (t symb))))) (tl-append marks (makeStrElem elType symb strNum startIndex alphaNumEnd)) (setf startIndex alphaNumEnd))))))))))))))))) (cond ((_and_ (_==_ (len st) 0) (_==_ phase STRING_PHASE)) (tl-append marks (makeStrElem STR_MID_ELEM (string #\Newline) strNum 0 1)))) (tl-append marks (makeStrElem LINE_END_ELEM nil strNum nil nil)) (values marks phase)))))
(defstruct (GrowingVect) streamObj (lineNum 0) (stringPhase REG_PHASE) (lineElems (_make-vector_)))
(defmethod initialize-instance :after ((gv GrowingVect) &key) (__readLine gv))
(defmethod __readLine ((str stream)) (read-line str nil nil))
(defmethod __readLine ((gv GrowingVect)) (let (line) (setf line (__readLine (slot-value gv 'streamObj))) (cond (line (_+=_ (slot-value gv 'lineNum) 1) (let (newElems) (setf (values newElems (slot-value gv 'stringPhase)) (markElemsInStr line (slot-value gv 'lineNum) (slot-value gv 'stringPhase))) (extend (slot-value gv 'lineElems) newElems)))) nil))
(defmethod len ((gv GrowingVect)) (len (slot-value gv 'lineElems)))
(defmethod _getitem_ ((gv GrowingVect) (index integer)) (_getitem_ (slot-value gv 'lineElems) index))
(defmethod _getitem_ ((gv GrowingVect) (sl _slice_)) (_getitem_ (slot-value gv 'lineElems) sl))
(defmethod growOnIndex ((gv GrowingVect) (index integer)) (cond ((_==_ index (len gv)) (__readLine gv))) index)
(defmethod growOnIndex ((vec vector) (index integer)) index)
