;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defun find-file-in-load-paths (fName) (let (str) (setf str (do ((str fName) semColInd (dirSepar (tl-dir-sep))) (nil) (setf semColInd (index str #\;)) (cond (semColInd (setf str (_+_ (_+_ (_getitem_ str (_make-slice_ nil semColInd nil)) dirSepar) (_getitem_ str (_make-slice_ (_+_ semColInd 1) nil nil))))) (t (return-from nil str))))) (cond ((_!=_ (_getitem_ str (_make-slice_ (_-_ (len str) 4) nil nil)) ".twl") (setf str (_+_ str ".twl")))) (let (fileExits folder) (setf (values str fileExits folder) (tl-for (dirName CUSTOM:*LOAD-PATHS* (dirSepar (tl-dir-sep))) ((values nil nil nil)) (cond ((typep dirName 'pathname) (setf dirName (namestring dirName)))) (do () (nil) (let (starInd) (setf starInd (index dirName #\*)) (cond (starInd (setf dirName (_+_ (_getitem_ dirName (_make-slice_ nil starInd nil)) (_getitem_ dirName (_make-slice_ (_+_ starInd 1) nil nil))))) (t (return-from nil ()))))) (cond ((probe-file (_+_ dirName str)) (return-from nil (values (_+_ dirName str) t nil)))) (cond ((probe-file (_+_ (_+_ (_+_ dirName (_getitem_ str (_make-slice_ nil (_-_ (len str) 4) nil))) dirSepar) "_load_.twl")) (return-from nil (values (_+_ (_+_ (_+_ dirName (_getitem_ str (_make-slice_ nil (_-_ (len str) 4) nil))) dirSepar) "_load_.twl") t (_+_ (_+_ dirName (_getitem_ str (_make-slice_ nil (_-_ (len str) 4) nil))) dirSepar))))))) (cond (fileExits (let (lispName) (setf lispName (_getitem_ str (_make-slice_ nil (_-_ (len str) 4) nil))) (cond ((probe-file (_+_ lispName ".lisp")) (cond ((_<_ (file-write-date (_+_ lispName ".lisp")) (file-write-date str)) (translate-file str (_+_ lispName ".lisp"))))) (t (translate-file str (_+_ lispName ".lisp")))) (values lispName folder))) (t (values fName nil))))))
(defun find-and-translate-file (filename) (cond ((typep filename 'string) (find-file-in-load-paths filename)) ((typep filename 'symbol) (find-file-in-load-paths (string-downcase (_%_ "~A" filename)))) (t (error (_%_ "&tl-load and &tl-require do not support filename of type '~A'" (type-of filename))))))
(defmacro tl-load (filename &rest rest) (let ((lispPath (gensym)) (folder (gensym))) `(let (,lispPath ,folder) (setf (values ,lispPath ,folder) (find-and-translate-file ,filename)) (cond (,folder (insert CUSTOM:*LOAD-PATHS* 0 ,folder))) (prog1 (load ,lispPath ,@rest) (cond (,folder (tl-remove CUSTOM:*LOAD-PATHS* ,folder)))))))
(defmacro tl-require (filename &rest rest) (let ((lispPath (gensym)) (folder (gensym))) `(let (,lispPath ,folder) (setf (values ,lispPath ,folder) (find-and-translate-file ,filename)) (cond (,folder (insert CUSTOM:*LOAD-PATHS* 0 ,folder))) (prog1 (require ,lispPath ,@rest) (cond (,folder (tl-remove CUSTOM:*LOAD-PATHS* ,folder)))))))
