;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
;; Logical-not operator '_not_'
(defmethod _not_ ((obj t)) (not obj))
(defmethod _not_ ((bitVect bit-vector)) (bit-not bitVect))
;; Logical-and operator '_and_'
(defmethod _and_ ((fst t) (snd t)) (and fst snd))
(defmethod _and_ ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-and fstBitVect sndBitVect))
;; Logical-or operator '_or_'
(defmethod _or_ ((fst t) (snd t)) (or fst snd))
(defmethod _or_ ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-ior fstBitVect sndBitVect))
;; Logical exclusive-or operator '_xor_'
(defmethod _xor_ ((fst t) (snd t)) (_and_ (_or_ fst snd) (_or_ (_not_ fst) (_not_ snd))))
(defmethod _xor_ ((fstBitVect bit-vector) (sndBitVect bit-vector)) (bit-xor fstBitVect sndBitVect))
;; Equality operator '_==_'
(defmethod _==_ ((fstNum number) (sndNum number)) (= fstNum sndNum))
(defmethod _==_ ((fstChar character) (sndChar character)) (char= fstChar sndChar))
(defmethod _==_ ((fstStr string) (sndStr string)) (string= fstStr sndStr))
(defmethod _==_ ((fstBitVect bit-vector) (sndBitVect bit-vector)) (equal fstBitVect sndBitVect))
(defmethod _==_ ((fstVect vector) (sndVect vector)) (cond ((eq fstVect sndVect) t) ((_==_ (len fstVect) (len sndVect)) (let (vecLen) (setf vecLen (len fstVect)) (do ((i 0 (_+_ i 1))) ((_>=_ i vecLen) t) (cond ((_!=_ (_getitem_ fstVect i) (_getitem_ sndVect i)) (return-from nil nil)))))) (t nil)))
(defmethod _==_ ((fstLst list) (sndLst list)) (cond ((eq fstLst sndLst) t) (t (do ((fstCons fstLst) (sndCons sndLst)) (nil) (cond ((endp fstCons) (return-from nil (endp sndCons))) (t (cond ((endp sndCons) (return-from nil nil)) (t (cond ((_!=_ (car fstCons) (car sndCons)) (return-from nil nil)) ((_==_ (cdr fstCons) (cdr sndCons)) (return-from nil t)) (t (setf fstCons (cdr fstCons)) (setf sndCons (cdr sndCons)) (cond ((_or_ (eq fstCons fstLst) (eq sndCons sndLst)) (return-from nil (_and_ (eq fstCons fstLst) (eq sndCons sndLst)))))))))))))))
(defmethod _==_ ((fstTab hash-table) (sndTab hash-table)) (cond ((eq fstTab sndTab) t) ((_==_ (len fstTab) (len sndTab)) (maphash #'(lambda (fstKey fstVal) (let (sndVal keyPresent) (setf (values sndVal keyPresent) (_getitem_ sndTab fstKey)) (cond ((_or_ (_not_ keyPresent) (_!=_ sndVal fstVal)) (return-from _==_ nil))))) fstTab) t) (t nil)))
(defmethod _==_ ((fst t) (snd t)) (eq fst snd))
;; Non-equality operator '_!=_'
(defmethod _!=_ ((fst t) (snd t)) (_not_ (_==_ fst snd)))
;; Smaller-then operator '_<_'
(defmethod _<_ ((fstNum number) (sndNum number)) (< fstNum sndNum))
(defmethod _<_ ((fstChar character) (sndChar character)) (char< fstChar sndChar))
(defmethod _<_ ((fstStr string) (sndStr string)) (string< fstStr sndStr))
;; Smaller-or-equal operator '_<=_'
(defmethod _<=_ ((fstNum number) (sndNum number)) (<= fstNum sndNum))
(defmethod _<=_ ((fstChar character) (sndChar character)) (char<= fstChar sndChar))
(defmethod _<=_ ((fstStr string) (sndStr string)) (string<= fstStr sndStr))
;; Greater-then operator '_>_'
(defmethod _>_ ((fstNum number) (sndNum number)) (> fstNum sndNum))
(defmethod _>_ ((fstChar character) (sndChar character)) (char> fstChar sndChar))
(defmethod _>_ ((fstStr string) (sndStr string)) (string> fstStr sndStr))
;; Greater-or-equal operator '_>=_'
(defmethod _>=_ ((fstNum number) (sndNum number)) (>= fstNum sndNum))
(defmethod _>=_ ((fstChar character) (sndChar character)) (char>= fstChar sndChar))
(defmethod _>=_ ((fstStr string) (sndStr string)) (string>= fstStr sndStr))
;; Addition method '_+_'
(defmethod _+_ ((fstNum number) (sndNum number)) (+ fstNum sndNum))
(defmethod _+_ ((fstLst list) (sndLst list)) (concatenate 'list fstLst sndLst))
(defmethod _+_ ((fstVect vector) (sndVect vector)) (let (resultVect) (setf resultVect (_make-vector_)) (extend resultVect fstVect sndVect) resultVect))
(defmethod _+_ ((fstStr string) (sndStr string)) (concatenate 'string fstStr sndStr))
(defmethod _+_ ((str string) (char character)) (concatenate 'string str (string char)))
(defmethod _+_ ((char character) (str string)) (concatenate 'string (string char) str))
;; Unary plus method '_unary+_'
(defmethod _unary+_ ((num number)) num)
;; Subtraction method '_-_'
(defmethod _-_ ((fstNum number) (sndNum number)) (- fstNum sndNum))
;; Unary minus method '_unary-_'
(defmethod _unary-_ ((num number)) (- num))
;; Multiplication method '_*_'
(defmethod _*_ ((fstNum number) (sndNum number)) (* fstNum sndNum))
;; Division method '_/_'
(defmethod _/_ ((fstNum number) (sndNum number)) (/ fstNum sndNum))
;; Modulus division method '_%_'
(defmethod _%_ ((fstInt integer) (sndInt integer)) (nth-value 0 (floor fstInt sndInt)))
(defmethod _%_ ((fstStr string) (sndStr string)) (apply #'format (list nil fstStr sndStr)))
(defmethod _%_ ((str string) (lst list)) (cond ((null lst) (apply #'format (list nil str nil))) (t (apply #'format (_+_ (list nil str) lst)))))
(defmethod _%_ ((str string) (obj t)) (apply #'format (list nil str obj)))
(defmethod _%_ ((str string) (seq sequence)) (apply #'format (_+_ (list nil str) (coerce seq 'list))))
;; Exponentiation method '_**_'
(defmethod _**_ ((fstNum number) (sndNum number)) (expt fstNum sndNum))
;; Appending method '_<<_'
(defmethod _<<_ ((lst list) (obj t)) (err-on-null lst "Operator '<<' cannot append to null list") (setf (cdr (last lst)) (list obj)) lst)
(defmethod _<<_ ((vec vector) (obj t)) (vector-push-extend obj vec) vec)
(defmethod _<<_ ((str stream) (s string)) (write-string s str) str)
(defmethod _<<_ ((str stream) (char character)) (write-char char str) str)
(defmethod _<<_ ((str stream) (int integer)) (write-byte int str) str)
