;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defclass TestTranslFormBuildingThree (unittest:testcase) ((unittest:tName :initform "TestTranslFormBuildingThree.twl") (unittest:tFuns :initform '(test-getForms-Struct-1 test-getForms-Struct-2 test-getForms-Struct-3 test-getForms-Struct-4 test-getForms-Struct-5 test-getForms-Class-1 test-getForms-Class-2 test-getForms-Class-3 test-getForms-Class-4 test-getForms-Class-5 test-getForms-Meth-1 test-getForms-Meth-2 test-getForms-Meth-3 test-getForms-Use-1 test-getForms-Use-2 test-getForms-Use-3 test-getForms-Use-4 test-getForms-Use-5 test-getForms-ImplicitLexscope-1 test-getForms-ImplicitLexscope-2 test-getForms-ImplicitLexscope-3 test-getForms-ImplicitLexscope-4 test-getForms-ImplicitLexscope-5 test-getForms-ImplicitLexscope-6 test-getForms-ImplicitLexscope-7 test-getForms-ImplicitLexscope-8 test-getForms-ImplicitLexscope-9 test-getForms-ImplicitLexscope-10 test-getForms-ImplicitLexscope-11 test-getForms-ImplicitLexscope-12 test-getForms-ImplicitLexscope-13 test-getForms-ImplicitLexscope-14 test-getForms-ImplicitLexscope-15 test-getForms-ImplicitLexscope-16))))
(defmethod test-getForms-Struct-1 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "struct foo {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defstruct") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))))))))))))
(defmethod test-getForms-Struct-2 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "struct foo {a b
                      c}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defstruct") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))) (list ATOM_TYPE "a") (list ATOM_TYPE "b") (list ATOM_TYPE "c"))))))))))
(defmethod test-getForms-Struct-3 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "struct foo {a{0} b{1}
                      c}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defstruct") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "0")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "1")))) (list ATOM_TYPE "c"))))))))))
(defmethod test-getForms-Struct-4 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "struct foo { a {0,:type=integer}
                       b {1,:&read-only }
                       c}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defstruct") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "0") (list ATOM_TYPE ":type") (list ATOM_TYPE "integer")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "1") (list ATOM_TYPE ":read-only")))) (list ATOM_TYPE "c"))))))))))
(defmethod test-getForms-Struct-5 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "struct foo { a {0,:type=integer}
                       b {1,:&read-only }}
          options {:include=boo,:named}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defstruct") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":include") (list ATOM_TYPE "boo")))) (list ATOM_TYPE ":named")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "0") (list ATOM_TYPE ":type") (list ATOM_TYPE "integer")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "1") (list ATOM_TYPE ":read-only")))))))))))))
(defmethod test-getForms-Class-1 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "class foo {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defclass") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-Class-2 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "class foo {a b
                     c}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defclass") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "b") (list ATOM_TYPE "c")))))))))))))
(defmethod test-getForms-Class-3 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "class foo {
              a {:type=integer}
              c}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defclass") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE ":type") (list ATOM_TYPE "integer")))) (list ATOM_TYPE "c")))))))))))))
(defmethod test-getForms-Class-4 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "class foo {
              a {:type=integer}
              c}
           options {
               :documentation=\"doc-string\"
               :metaclass=boo}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defclass") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE ":type") (list ATOM_TYPE "integer")))) (list ATOM_TYPE "c")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"doc-string\"")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":metaclass") (list ATOM_TYPE "boo")))))))))))))
(defmethod test-getForms-Class-5 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "class foo (super1,super2) {
              a {:type=integer}
              ; this comment will be dropped out entirely
              c}
          options {
              :documentation=\"doc-string\"
              :metaclass=boo}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defclass") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "super1") (list ATOM_TYPE "super2")))) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE ":type") (list ATOM_TYPE "integer")))) (list ATOM_TYPE "c")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":documentation") (list ATOM_TYPE "\"doc-string\"")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE ":metaclass") (list ATOM_TYPE "boo")))))))))))))
(defmethod test-getForms-Meth-1 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "meth foo (a){}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defmethod") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))))))))))))
(defmethod test-getForms-Meth-2 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "meth foo :after (a){}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defmethod") (list ATOM_TYPE "foo") (list ATOM_TYPE ":after") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))))))))))))
(defmethod test-getForms-Meth-3 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "meth setter foo (a){}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defmethod") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "foo")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))))))))))))
(defmethod test-getForms-Use-1 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "use foo {x,y,z}
          x(a)
          y(b)
          z(c)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo:x") (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo:y") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo:z") (list ATOM_TYPE "c"))))))))))
(defmethod test-getForms-Use-2 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "use foo {x=e,y=f,z}
          e(a)
          x(a)
          f(b)
          y(b)
          z(c)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo:x") (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x") (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo:y") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "y") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo:z") (list ATOM_TYPE "c"))))))))))
(defmethod test-getForms-Use-3 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "use foo: {x,y,z}
          x(a)
          y(b)
          z(c)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo::x") (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo::y") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo::z") (list ATOM_TYPE "c"))))))))))
(defmethod test-getForms-Use-4 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "use foo {x}
          func(x)
          func(:x)
          func(cl:x)
          func(cl::x)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "func") (list ATOM_TYPE "foo:x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "func") (list ATOM_TYPE ":x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "func") (list ATOM_TYPE "cl:x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "func") (list ATOM_TYPE "cl::x"))))))))))
(defmethod test-getForms-Use-5 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "use {x=a,y=b}
          a(1)
          b(2)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "y") (list ATOM_TYPE "2"))))))))))
(defmethod test-getForms-ImplicitLexscope-1 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=1
              foo(x)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x"))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-2 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=y=1
              foo(x)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "y") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "1"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x"))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-3 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=0
              y=1
              foo(x)
              z:a=2}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "0")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "y")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "z:a") (list ATOM_TYPE "2")))))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-4 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=1
              global y
              y=0
              foo(x)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "0")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x"))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-5 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=1
              x=0
              foo(x)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "0")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x"))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-6 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=1
              lexscope explicit
              y=0
              foo(x)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "0")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x"))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-7 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=0
              lexscope explicit
              z=1
              lexscope implicit
              y=2
              foo(x)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "0")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "z") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "y")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "2")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-8 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=0
              lexscope explicit
              z=1
              lexscope implicit
              y=2
              foo(x)}") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo :implScope t :explScopeWarn t))))))
(defmethod test-getForms-ImplicitLexscope-9 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              foo(x)
              x=0
              lexscope explicit
              global z
              z=1
              lexscope implicit
              y=2
              foo(x)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t :explScopeWarn t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "0")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "z") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "y")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "2")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "x")))))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-10 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "def foo (a) {
              a = 1
              b = 2}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t :explScopeWarn t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "b") (list ATOM_TYPE "2"))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-11 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "mac foo (a) {
              a = 1
              b = 2}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defmacro") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "b") (list ATOM_TYPE "2")))))))))))))
(defmethod test-getForms-ImplicitLexscope-12 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "a = 1
          b = 2
          mac foo (a) {
              a = 1
              b = 2}") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo :implScope t :explScopeWarn t))))))
(defmethod test-getForms-ImplicitLexscope-13 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "a = 1
          b = 2
          mac foo (a) {
              a = 1
              global b
              b = 2}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t :explScopeWarn t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "b") (list ATOM_TYPE "2")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defmacro") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "b") (list ATOM_TYPE "2")))))))))))))
(defmethod test-getForms-ImplicitLexscope-14 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "a = 1
          b = 2
          def foo (a) {
              a = 1
              b = 2}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t :explScopeWarn t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "b") (list ATOM_TYPE "2")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "1")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "b") (list ATOM_TYPE "2"))))))))))))))))
(defmethod test-getForms-ImplicitLexscope-15 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "def foo (a,b=lambda{a=1}) { a=9 }") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t :explScopeWarn t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "lambda") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "1")))))))))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "9")))))))))))))
(defmethod test-getForms-ImplicitLexscope-16 ((ts TestTranslFormBuildingThree)) (let (st) (setf st "progn{
              x @ y = foo()
              x+y}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x") (list ATOM_TYPE "y")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "values") (list ATOM_TYPE "x") (list ATOM_TYPE "y")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list ATOM_TYPE "y"))))))))))))))))
