;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;;
;;   constants
;;
(in-package "TWINLISP")
(const CLISP_START_STRING "cl{{")
(const CLISP_END_STRING "}}")
; BRACKETS describes enclosing symbols (brackets): key is an openning 'bracket', value is a closing one
(const BRACKETS (_make-hash-table_ "(" ")" "[" "]" "{" "}" "~(" ")" "~[" "]"))
(const CLOSING_BRACKETS (tValues BRACKETS))
; types of operator association
(const RIGHT_ASSOC :right_assoc)
(const LEFT_ASSOC :left_assoc)
(const MULT_ARGS_ASSOC :mult_assoc)
(const UNAR_OPERS (_make-hash-table_ "+" (list "_unary+_" 2 RIGHT_ASSOC) "-" (list "_unary-_" 2 RIGHT_ASSOC) "!" (list "_not_" 2 RIGHT_ASSOC) "not" (list "_not_" 2 RIGHT_ASSOC)))
(const BIN_OPERS (_make-hash-table_ "**" (list "_**_" 3 RIGHT_ASSOC) "*" (list "_*_" 4 LEFT_ASSOC) "/" (list "_/_" 4 LEFT_ASSOC) "%" (list "_%_" 4 LEFT_ASSOC) "+" (list "_+_" 5 LEFT_ASSOC) "-" (list "_-_" 5 LEFT_ASSOC) "<" (list "_<_" 7 LEFT_ASSOC) ">" (list "_>_" 7 LEFT_ASSOC) "<=" (list "_<=_" 7 LEFT_ASSOC) ">=" (list "_>=_" 7 LEFT_ASSOC) "==" (list "_==_" 8 LEFT_ASSOC) "!=" (list "_!=_" 8 LEFT_ASSOC) "&" (list "_and_" 9 LEFT_ASSOC) "and" (list "_and_" 9 LEFT_ASSOC) "^" (list "_xor_" 10 LEFT_ASSOC) "xor" (list "_xor_" 10 LEFT_ASSOC) "|" (list "_or_" 11 LEFT_ASSOC) "or" (list "_or_" 11 LEFT_ASSOC) "<<" (list "_<<_" 13 LEFT_ASSOC) "@" (list "values" 14 MULT_ARGS_ASSOC) "=" (list "setf" 15 RIGHT_ASSOC) "+=" (list "_+=_" 15 RIGHT_ASSOC) "-=" (list "_-=_" 15 RIGHT_ASSOC) "*=" (list "_*=_" 15 RIGHT_ASSOC) "/=" (list "_/=_" 15 RIGHT_ASSOC)))
(const OPER_SYMB (list "and" "or" "xor" "not"))
; "word" operator, not a block structure
(const SHORTCUT_OPERS (_make-hash-table_ "'" "'" "#." "#." "#'" "#'" "`" "`" "$" "," "$@" ",@"))
(const COMPL_NUM_OPER (list "#C" "#c"))
; TwinLisp's names of funcs/methods
(const MAKE_SIMPLE_ARRAY_FUNC "_make-vector_")
(const MAKE_LIST_FUNC "list")
(const MAKE_COMPLEX_NUM_FUNC "complex")
(const MAKE_DICTIONARY_FUNC "_make-hash-table_")
(const GET_ITEM_FUNC "_getitem_")
(const MAKE_SLICE_FUNC "_make-slice_")
(const GET_OBJ_SLOT_FUNC "slot-value")
(const LISP_NIL "nil")
(const SETTER_FUNC "setf")
; Nicknames to "popular" methods
(const TWL_METH_NICKNAMES (_make-hash-table_ "pop" "tl-pop" "_pop" "pop" "remove" "tl-remove" "_remove" "remove" "append" "tl-append" "_append" "append" "count" "tl-count" "_count" "count" "load" "tl-load" "_load" "load" "require" "tl-require" "_require" "require" "times" "tl-times" "_times" "times"))
; DOUBLE_CHAR_OPERS is used in string reading to mark elements
(const MULTI_CHAR_OPERS (flet ((appTable (mTab opTab) (do* ((i 0 (_+_ i 1)) (items (tItems opTab))) ((_>=_ i (len items))) (let (oper) (setf oper (first (_getitem_ items i))) (cond ((_and_ (_==_ (tl-count OPER_SYMB oper) 0) (_>_ (len oper) 1)) (cond ((has_key mTab (_getitem_ oper 0)) (tl-append (_getitem_ mTab (_getitem_ oper 0)) oper)) (t (setf (_getitem_ mTab (_getitem_ oper 0)) (list oper))))))))) (addOper (mTab opers) (do* ((i 0 (_+_ i 1))) ((_>=_ i (len opers))) (let (oper) (setf oper (_getitem_ opers i)) (cond ((has_key mTab (_getitem_ oper 0)) (tl-append (_getitem_ mTab (_getitem_ oper 0)) oper)) (t (setf (_getitem_ mTab (_getitem_ oper 0)) (list oper)))))))) (let (multOpers) (setf multOpers (_make-hash-table_)) (appTable multOpers UNAR_OPERS) (appTable multOpers BIN_OPERS) (appTable multOpers SHORTCUT_OPERS) (addOper multOpers COMPL_NUM_OPER) (addOper multOpers (list "~(" "~[" "->" "::" "=?")) multOpers)))
; types of elements extracted from string
(const SYMB_ELEM :symbol_elem)
(const SPEC_SYMB_ELEM :spec_symbol_elem)
(const NUM_ELEM :number_elem)
(const SYNT_STRUCT_ELEM :syntactic_structure)
(const STR_START_ELEM :string_start_elem)
(const STR_MID_ELEM :string_middle_elem)
(const STR_END_ELEM :string_end_elem)
(const CLISP_START_ELEM :clisp_code_start_elem)
(const CLISP_MID_ELEM :clisp_code_middle_elem)
(const CLISP_END_ELEM :clisp_code_end_elem)
(const WHITE_ELEM :white_space_elem)
(const COMM_ELEM :comment_elem)
(const LINE_END_ELEM :end_of_line_elem)
(defstruct (StrElem) type value lineNum start end)
; AUX_SPEC_SYMB is a list of special words that might be used inside of TL_BLOCK's or TL's directives
(const AUX_SPEC_SYMB (list "elif" "else" "from" "is" "options" "finally" "at" "cond" "meth"))
(const SETTER_SPEC_SYMB "setter")
(tl-append AUX_SPEC_SYMB SETTER_SPEC_SYMB)
; TL_DIRECT_SPEC_SYMB is a list of special words that start TL's directives
(const TL_DIR_GLOBAL "global")
(const TL_DIR_LEXSCOPE "lexscope")
(const TL_EXPL_SCOPE "explicit")
(const TL_IMPL_SCOPE "implicit")
(const TL_DIR_USE "use")
(const TL_DIRECT_SPEC_SYMB (list TL_DIR_GLOBAL TL_DIR_LEXSCOPE TL_EXPL_SCOPE TL_IMPL_SCOPE TL_DIR_USE))
; TYPE's are types of nodes ready for writting 'em directly into lisp code
(const COMMENT_TYPE :comment_type)
(const SHORTCUT_TYPE :shortcut_type)
(const ATOM_TYPE :atom_type)
(const FORM_TYPE :form_type)
; constants for use in TL_BLOCK descriptions and/or in functions that work with elements from TL_BLOCK's
(const OPTIONAL :optional_element)
(const MULT :repeat_several_times)
(const LAMBDA_LIST_OPTIONS (list "&optional" "&rest" "&key" "&allow-other-keys" "&aux"))
(const MAC_LAMBDA_LIST_OPTIONS (_+_ LAMBDA_LIST_OPTIONS (list "&body" "&whole" "&environment")))
(const FUN_NAME :function_name)
; one form
(const GEN_FUN_NAME :generic_function_name)
; one form
(const NAME :name_on_current_line)
; one form
(const NAME2 :name_on_diff_line)
; one form
(const FUN_NAME_FROM_LEVEL :func_name_from_level_info)
; one form
(const LAMBDA_LIST :lambda_list)
; one form
(const MAC_LAMBDA_LIST :macro_lambda_list)
; one form
(const SPEC_LAMBDA_LIST :specializer_lambda_list)
; one form
(const LET_LIST :let_list)
; one form
(const DO_VAR_LIST :do_vars_list)
; one form
(const DO_TEST_RES_LIST :do_test_result_list)
; one form
(const BODY_BLOCK :body_block)
; many forms
(const MAC_BODY_BLOCK :mac_body_block)
; many forms
(const FUN_BODY_BLOCK :func_body_block)
; many forms
(const GEN_FUN_METH_BODY_BLOCK :generic_func_method_body_block)
; many forms
(const OPER_EXPR :oper_expr)
; one form
(const OPER_EXPR_IN_BRACK :oper_expr_in_round_brackets)
; one form
(const MULT_OPER_EXPR_IN_BRACK :mult_oper_expr_in_round_brackets)
; one form
(const STRUCT_SLOTS :struct_slots_defs)
(const STRUCT_OPTIONS :struct_options)
(const CLASS_SLOTS_LIST :class_slots_defs_list)
(const CLASS_OPTIONS :class_options)
(const METH_QUALIF :meth_qualifier)
; TL_BLOCK gives descriptions of each special TwinLisp language constract;
;  - keys are special words that start their respective TL_BLOCK's
(const TL_BLOCK (_make-hash-table_ "def" (list (_make-vector_ :initContent (list FUN_NAME (list LAMBDA_LIST OPTIONAL) FUN_BODY_BLOCK)) (_make-vector_ :initContent (list "defun" 0 1 2))) "lambda" (list (_make-vector_ :initContent (list (list LAMBDA_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "lambda" 0 1))) "mac" (list (_make-vector_ :initContent (list NAME2 (list MAC_LAMBDA_LIST OPTIONAL) MAC_BODY_BLOCK)) (_make-vector_ :initContent (list "defmacro" 0 1 2))) "block" (list (_make-vector_ :initContent (list (list NAME2 OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "block" 0 1))) "catch" (list (_make-vector_ :initContent (list NAME2 BODY_BLOCK)) (_make-vector_ :initContent (list "catch" 0 1))) "throw" (list (_make-vector_ :initContent (list NAME (list OPER_EXPR OPTIONAL))) (_make-vector_ :initContent (list "throw" 0 1))) "let" (list (_make-vector_ :initContent (list (list LET_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "let" 0 1))) "lets" (list (_make-vector_ :initContent (list (list LET_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "let*" 0 1))) "prog" (list (_make-vector_ :initContent (list (list LET_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "prog" 0 1))) "progs" (list (_make-vector_ :initContent (list (list LET_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "prog*" 0 1))) "do" (list (_make-vector_ :initContent (list DO_VAR_LIST (list DO_TEST_RES_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "do" 0 1 2))) "dos" (list (_make-vector_ :initContent (list DO_VAR_LIST (list DO_TEST_RES_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "do*" 0 1 2))) "for" (list (_make-vector_ :initContent (list DO_VAR_LIST (list DO_TEST_RES_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "tl-for" 0 1 2))) "times" (list (_make-vector_ :initContent (list DO_VAR_LIST (list DO_TEST_RES_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (list "tl-times" 0 1 2))) "flet" (list (_make-vector_ :initContent (list (list (_make-vector_ :initContent (list FUN_NAME (list LAMBDA_LIST OPTIONAL) FUN_BODY_BLOCK)) OPTIONAL MULT) BODY_BLOCK)) (_make-vector_ :initContent (list "flet" (_make-vector_ :initContent (list (list 0 OPTIONAL MULT (_make-vector_ :initContent (list 0 1 2))))) 1))) "labels" (list (_make-vector_ :initContent (list (list (_make-vector_ :initContent (list FUN_NAME (list LAMBDA_LIST OPTIONAL) FUN_BODY_BLOCK)) OPTIONAL MULT) BODY_BLOCK)) (_make-vector_ :initContent (list "labels" (_make-vector_ :initContent (list (list 0 OPTIONAL MULT (_make-vector_ :initContent (list 0 1 2))))) 1))) "maclet" (list (_make-vector_ :initContent (list (list (_make-vector_ :initContent (list NAME2 (list MAC_LAMBDA_LIST OPTIONAL) MAC_BODY_BLOCK)) OPTIONAL MULT) MAC_BODY_BLOCK)) (_make-vector_ :initContent (list "macrolet" (_make-vector_ :initContent (list (list 0 OPTIONAL MULT (_make-vector_ :initContent (list 0 1 2))))) 1))) "if" (list (_make-vector_ :initContent (list OPER_EXPR_IN_BRACK BODY_BLOCK (list (_make-vector_ :initContent (list "elif" OPER_EXPR_IN_BRACK BODY_BLOCK)) OPTIONAL MULT) (list (_make-vector_ :initContent (list "else" BODY_BLOCK)) OPTIONAL))) (_make-vector_ :initContent (list "cond" (_make-vector_ :initContent (list 0 1)) (list 2 MULT OPTIONAL (_make-vector_ :initContent (list 0 1))) (list 3 OPTIONAL (_make-vector_ :initContent (list "t" 0)))))) "case" (list (_make-vector_ :initContent (list OPER_EXPR_IN_BRACK (list (_make-vector_ :initContent (list "is" MULT_OPER_EXPR_IN_BRACK BODY_BLOCK)) OPTIONAL MULT) (list (_make-vector_ :initContent (list "else" BODY_BLOCK)) OPTIONAL))) (_make-vector_ :initContent (list "tl-case" 0 (list 2 OPTIONAL (_make-vector_ :initContent (list 0)) "nil") (list 1 MULT OPTIONAL (_make-vector_ :initContent (list (_make-vector_ :initContent (list 0)) 1)))))) "comcase" (list (_make-vector_ :initContent (list OPER_EXPR_IN_BRACK (list (_make-vector_ :initContent (list "is" MULT_OPER_EXPR_IN_BRACK BODY_BLOCK)) OPTIONAL MULT) (list (_make-vector_ :initContent (list "else" BODY_BLOCK)) OPTIONAL))) (_make-vector_ :initContent (list "case" 0 (list 1 MULT OPTIONAL (_make-vector_ :initContent (list (_make-vector_ :initContent (list 0)) 1))) (list 2 OPTIONAL (_make-vector_ :initContent (list "otherwise" 0)))))) "typecase" (list (_make-vector_ :initContent (list OPER_EXPR_IN_BRACK (list (_make-vector_ :initContent (list "is" OPER_EXPR_IN_BRACK BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (list "typecase" 0 (list 1 MULT OPTIONAL (_make-vector_ :initContent (list 0 1)))))) "return" (list (_make-vector_ :initContent (list FUN_NAME_FROM_LEVEL (list (_make-vector_ :initContent (list "from" NAME)) OPTIONAL) (list OPER_EXPR OPTIONAL))) (_make-vector_ :initContent (list "return-from" (list 1 OPTIONAL 0 0) 2))) "break" (list (_make-vector_ :initContent (list (list (_make-vector_ :initContent (list "from" NAME)) OPTIONAL) (list OPER_EXPR OPTIONAL))) (_make-vector_ :initContent (list "return-from" (list 0 OPTIONAL 0 "nil") 1))) "struct" (list (_make-vector_ :initContent (list NAME2 STRUCT_SLOTS (list (_make-vector_ :initContent (list "options" STRUCT_OPTIONS)) OPTIONAL))) (_make-vector_ :initContent (list "defstruct" (_make-vector_ :initContent (list 0 (list 2 OPTIONAL 0))) 1))) "class" (list (_make-vector_ :initContent (list NAME2 (list LET_LIST OPTIONAL) CLASS_SLOTS_LIST (list (_make-vector_ :initContent (list "options" CLASS_OPTIONS)) OPTIONAL))) (_make-vector_ :initContent (list "defclass" 0 1 2 (list 3 OPTIONAL 0)))) "cond" (list (_make-vector_ :initContent (list NAME2 (list LET_LIST OPTIONAL) CLASS_SLOTS_LIST (list (_make-vector_ :initContent (list "options" CLASS_OPTIONS)) OPTIONAL))) (_make-vector_ :initContent (list "define-condition" 0 1 2 (list 3 OPTIONAL 0)))) "meth" (list (_make-vector_ :initContent (list FUN_NAME (list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST FUN_BODY_BLOCK)) (_make-vector_ :initContent (list "defmethod" 0 1 2 3))) "package" (list (_make-vector_ :initContent (list NAME2 (list STRUCT_SLOTS OPTIONAL))) (_make-vector_ :initContent (list "defpackage" 0 1))) "inside" (list (_make-vector_ :initContent (list NAME2)) (_make-vector_ :initContent (list "in-package" 0))) "try" (list (_make-vector_ :initContent (list BODY_BLOCK (_make-vector_ :initContent (list "finally" BODY_BLOCK)))) (_make-vector_ :initContent (list "unwind-protect" (_make-vector_ :initContent (list "progn" 0)) (list 1 0)))) "restart" (list (_make-vector_ :initContent (list BODY_BLOCK (list (_make-vector_ :initContent (list "at" (list NAME2 OPTIONAL) (list LAMBDA_LIST OPTIONAL) BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (list "restart-case" (_make-vector_ :initContent (list "progn" 0)) (list 1 MULT OPTIONAL (_make-vector_ :initContent (list 0 1 2)))))) "handle" (list (_make-vector_ :initContent (list BODY_BLOCK (list (_make-vector_ :initContent (list "cond" NAME2 (list LET_LIST OPTIONAL) BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (list "handler-case" (_make-vector_ :initContent (list "progn" 0)) (list 1 MULT OPTIONAL (_make-vector_ :initContent (list 0 1 2)))))) "defgen" (list (_make-vector_ :initContent (list GEN_FUN_NAME LAMBDA_LIST (list (_make-vector_ :initContent (list "options" CLASS_OPTIONS)) OPTIONAL) (list (_make-vector_ :initContent (list "meth" (list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST GEN_FUN_METH_BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (list "defgeneric" 0 1 (list 2 OPTIONAL 0) (list 3 MULT OPTIONAL (_make-vector_ :initContent (list ":method" 0 1 2)))))) "glet" (list (_make-vector_ :initContent (list (list (_make-vector_ :initContent (list GEN_FUN_NAME LAMBDA_LIST (list (_make-vector_ :initContent (list "options" CLASS_OPTIONS)) OPTIONAL) (list (_make-vector_ :initContent (list "meth" (list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST GEN_FUN_METH_BODY_BLOCK)) OPTIONAL MULT))) OPTIONAL MULT) BODY_BLOCK)) (_make-vector_ :initContent (list "generic-flet" (_make-vector_ :initContent (list (list 0 OPTIONAL MULT (_make-vector_ :initContent (list 0 1 (list 2 OPTIONAL 0) (list 3 MULT OPTIONAL (_make-vector_ :initContent (list ":method" 0 1 2)))))))) 1))) "glabels" (list (_make-vector_ :initContent (list (list (_make-vector_ :initContent (list GEN_FUN_NAME LAMBDA_LIST (list (_make-vector_ :initContent (list "options" CLASS_OPTIONS)) OPTIONAL) (list (_make-vector_ :initContent (list "meth" (list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST GEN_FUN_METH_BODY_BLOCK)) OPTIONAL MULT))) OPTIONAL MULT) BODY_BLOCK)) (_make-vector_ :initContent (list "generic-labels" (_make-vector_ :initContent (list (list 0 OPTIONAL MULT (_make-vector_ :initContent (list 0 1 (list 2 OPTIONAL 0) (list 3 MULT OPTIONAL (_make-vector_ :initContent (list ":method" 0 1 2)))))))) 1))) "gfun" (list (_make-vector_ :initContent (list LAMBDA_LIST (list (_make-vector_ :initContent (list "options" CLASS_OPTIONS)) OPTIONAL) (list (_make-vector_ :initContent (list "meth" (list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (list "generic-function" 0 (list 1 OPTIONAL 0) (list 2 MULT OPTIONAL (_make-vector_ :initContent (list ":method" 0 1 2))))))))
; SPEC_SYMB is used in string reading to mark elements
(const SPEC_SYMB (_make-vector_))
(extend SPEC_SYMB OPER_SYMB (tKeys TL_BLOCK) AUX_SPEC_SYMB TL_DIRECT_SPEC_SYMB)
; tl-syntax-error
(define-condition tl-syntax-error (simple-error) ((message :initarg :message)))
; function for use inside of this package only
(defun signalSyntaxError (errorMessage) (error 'tl-syntax-error :message errorMessage :format-control errorMessage))
