;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defclass TestTranslFormBuilding (unittest:testcase) ((unittest:tName :initform "TestTranslFormBuilding.twl") (unittest:tFuns :initform '(test-getForms-BracketForm-1 test-getForms-BracketForm-2 test-getForms-BracketForm-3 test-getForms-BracketForm-4 test-getForms-OperForm-1 test-getForms-OperForm-2 test-getForms-OperForm-3 test-getForms-OperForm-4 test-getForms-OperForm-5 test-getForms-OperForm-6 test-getForms-OperForm-7 test-getForms-OperForm-8 test-getForms-OperForm-9 test-getForms-OperForm-10 test-getForms-OperForm-11 test-getForms-OperForm-12 test-getForms-OperForm-13 test-getForms-OperForm-14 test-getForms-OperForm-15 test-getForms-OperForm-16 test-getForms-OperForm-17 test-getForms-OperForm-18 test-getForms-OperForm-19 test-getForms-OperForm-20 test-getForms-OperForm-21 test-getForms-OperForm-22 test-getForms-OperForm-23 test-getForms-OperForm-24 test-getForms-OperForm-25 test-getForms-OperForm-26 test-getForms-OperForm-27 test-getForms-OperForm-28 test-getForms-OperForm-29 test-getForms-ComplexNum-1 test-getForms-ComplexNum-2 test-getForms-ComplexNum-3 test-getForms-Array-1 test-getForms-Array-2 test-getForms-List-1 test-getForms-List-2 test-getForms-BodyBlock-1 test-getForms-BodyBlock-2 test-getForms-BodyBlock-3 test-getForms-BodyBlock-4 test-getForms-BodyBlock-5 test-getForms-String-1 test-getForms-String-2 test-getForms-String-3 test-getForms-CLisp-1 test-getForms-CLisp-2 test-getForms-Column-1 test-getForms-Column-2 test-getForms-Column-3 test-getForms-Column-4 test-getForms-Column-5 test-getForms-Column-6 test-getForms-Column-7 test-getForms-ObjSlots-1 test-getForms-ObjSlots-2 test-getForms-ObjSlots-3 test-getForms-ObjSlots-4 test-getForms-ObjMeth-1 test-getForms-ObjMeth-2 test-getForms-ObjMeth-3 test-getForms-ObjMeth-4 test-getForms-ObjMeth-5 test-getForms-Func-1 test-getForms-Func-2 test-getForms-Func-3 test-getForms-Func-4 test-getForms-Func-5 test-getForms-InnerFuncCallList-1 test-getForms-Dict-1 test-getForms-Dict-2 test-getForms-Dict-3 test-getForms-Dict-4 test-getForms-Dict-5 test-getForms-Dict-6 test-getForms-Getitem-1 test-getForms-Getitem-2 test-getForms-Getitem-3 test-getForms-Getitem-4 test-getForms-Getitem-5 test-getForms-Getitem-6 test-getForms-Getitem-7 test-getForms-Getitem-8 test-getForms-Getitem-9 test-getForms-Getitem-10 test-getForms-Getitem-11))))
(defmethod test-getForms-BracketForm-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "~()") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) t)) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list COMMENT_TYPE "; source line # 1") (list FORM_TYPE (_make-vector_))))))))
(defmethod test-getForms-BracketForm-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "~(),~()
          ~(),~(~(),~())") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) t)) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list COMMENT_TYPE "; source line # 1") (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; source line # 1") (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; source line # 2") (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; source line # 2") (list FORM_TYPE (_make-vector_ :initContent (list (list COMMENT_TYPE "; source line # 2") (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; source line # 2") (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BracketForm-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "  ~(),~(), \\ anything to new line will be skipped
            ~(),
            ~(~(),~())") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) t)) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list COMMENT_TYPE "; source line # 1") (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; source line # 1") (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; source line # 2") (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; source line # 3") (list FORM_TYPE (_make-vector_ :initContent (list (list COMMENT_TYPE "; source line # 3") (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; source line # 3") (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BracketForm-4 ((ts TestTranslFormBuilding)) (let (st) (setf st "~() ; comment here
          ~()
          ~()") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_)) (list COMMENT_TYPE "; comment here") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_))))))))
(defmethod test-getForms-BracketForm-5 ((ts TestTranslFormBuilding)) (let (st) (setf st "~(a,b,c-d,~(foo))") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "b") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list ATOM_TYPE "c") (list ATOM_TYPE "d")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))))))))))))
(defmethod test-getForms-OperForm-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list ATOM_TYPE "x")))))))
(defmethod test-getForms-OperForm-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x,y") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list ATOM_TYPE "x") (list ATOM_TYPE "y")))))))
(defmethod test-getForms-OperForm-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x
          y") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list ATOM_TYPE "x") (list ATOM_TYPE "y")))))))
(defmethod test-getForms-OperForm-4 ((ts TestTranslFormBuilding)) (let (st) (setf st "x y") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-OperForm-5 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+y") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list ATOM_TYPE "y"))))))))))
(defmethod test-getForms-OperForm-6 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+y-z") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list ATOM_TYPE "y")))) (list ATOM_TYPE "z"))))))))))
(defmethod test-getForms-OperForm-7 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+y*d") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_*_") (list ATOM_TYPE "y") (list ATOM_TYPE "d")))))))))))))
(defmethod test-getForms-OperForm-8 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+'y") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list SHORTCUT_TYPE "'" (list ATOM_TYPE "y")))))))))))
(defmethod test-getForms-OperForm-9 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+'$y") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list SHORTCUT_TYPE "'" (list SHORTCUT_TYPE "," (list ATOM_TYPE "y"))))))))))))
(defmethod test-getForms-OperForm-10 ((ts TestTranslFormBuilding)) (let (st) (setf st "#'*") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list SHORTCUT_TYPE "#'" (list ATOM_TYPE "_*_"))))))))
(defmethod test-getForms-OperForm-11 ((ts TestTranslFormBuilding)) (let (st) (setf st "a=x+y*d") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_*_") (list ATOM_TYPE "y") (list ATOM_TYPE "d"))))))))))))))))
(defmethod test-getForms-OperForm-12 ((ts TestTranslFormBuilding)) (let (st) (setf st "a=x*(y+d)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_*_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "y") (list ATOM_TYPE "d"))))))))))))))))
(defmethod test-getForms-OperForm-13 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+y*d/c-z") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_/_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_*_") (list ATOM_TYPE "y") (list ATOM_TYPE "d")))) (list ATOM_TYPE "c"))))))) (list ATOM_TYPE "z"))))))))))
(defmethod test-getForms-OperForm-14 ((ts TestTranslFormBuilding)) (let (st) (setf st "a=x+=y=z") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+=_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "z"))))))))))))))))
(defmethod test-getForms-OperForm-15 ((ts TestTranslFormBuilding)) (let (st) (setf st "a=x*(y+d,s)") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-OperForm-16 ((ts TestTranslFormBuilding)) (let (st) (setf st "a=x*(y+d,)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_*_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "y") (list ATOM_TYPE "d"))))))))))))))))
(defmethod test-getForms-OperForm-17 ((ts TestTranslFormBuilding)) (let (st) (setf st "a=x*(y+d
                  s)") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-OperForm-18 ((ts TestTranslFormBuilding)) (let (st) (setf st "a=x+y \\
              *d") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_*_") (list ATOM_TYPE "y") (list ATOM_TYPE "d"))))))))))))))))
(defmethod test-getForms-OperForm-19 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+y**d**c-z") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_**_") (list ATOM_TYPE "y") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_**_") (list ATOM_TYPE "d") (list ATOM_TYPE "c")))))))))) (list ATOM_TYPE "z"))))))))))
(defmethod test-getForms-OperForm-20 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+~(foo,a+b)-z") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))) (list ATOM_TYPE "z"))))))))))
(defmethod test-getForms-OperForm-21 ((ts TestTranslFormBuilding)) (let (st) (setf st "x++y") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_unary+_") (list ATOM_TYPE "y")))))))))))))
(defmethod test-getForms-OperForm-22 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+-y") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_unary-_") (list ATOM_TYPE "y")))))))))))))
(defmethod test-getForms-OperForm-23 ((ts TestTranslFormBuilding)) (let (st) (setf st "a@b@c=x@y@z") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "values") (list ATOM_TYPE "a") (list ATOM_TYPE "b") (list ATOM_TYPE "c")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "values") (list ATOM_TYPE "x") (list ATOM_TYPE "y") (list ATOM_TYPE "z")))))))))))))
(defmethod test-getForms-OperForm-24 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-OperForm-25 ((ts TestTranslFormBuilding)) (let (st) (setf st "x+'") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-OperForm-26 ((ts TestTranslFormBuilding)) (let (st) (setf st "+") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-OperForm-27 ((ts TestTranslFormBuilding)) (let (st) (setf st "*") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-OperForm-28 ((ts TestTranslFormBuilding)) (let (st) (setf st "not x and y or z") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_or_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_and_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_not_") (list ATOM_TYPE "x")))) (list ATOM_TYPE "y")))) (list ATOM_TYPE "z"))))))))))
(defmethod test-getForms-OperForm-29 ((ts TestTranslFormBuilding)) (let (st) (setf st "!x & y | z") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_or_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_and_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_not_") (list ATOM_TYPE "x")))) (list ATOM_TYPE "y")))) (list ATOM_TYPE "z"))))))))))
(defmethod test-getForms-ComplexNum-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=#c(s-d,23/45)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "complex") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list ATOM_TYPE "s") (list ATOM_TYPE "d")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_/_") (list ATOM_TYPE "23") (list ATOM_TYPE "45"))))))))))))))))
(defmethod test-getForms-ComplexNum-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=#c(3.4e-10,23/45)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "complex") (list ATOM_TYPE "3.4e-10") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_/_") (list ATOM_TYPE "23") (list ATOM_TYPE "45"))))))))))))))))
(defmethod test-getForms-ComplexNum-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=#c(3.4e-10)") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-Array-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=[s-d,23/45,foo]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-vector_") (list ATOM_TYPE ":initContent") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "list") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list ATOM_TYPE "s") (list ATOM_TYPE "d")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_/_") (list ATOM_TYPE "23") (list ATOM_TYPE "45")))) (list ATOM_TYPE "foo"))))))))))))))))
(defmethod test-getForms-Array-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=[]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-vector_")))))))))))))
(defmethod test-getForms-List-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=~[s-d,23/45,foo]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "list") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list ATOM_TYPE "s") (list ATOM_TYPE "d")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_/_") (list ATOM_TYPE "23") (list ATOM_TYPE "45")))) (list ATOM_TYPE "foo")))))))))))))
(defmethod test-getForms-List-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=~[]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "list")))))))))))))
(defmethod test-getForms-BodyBlock-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo{a,b}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-BodyBlock-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo{a
                b=45}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "b") (list ATOM_TYPE "45"))))))))))))))))
(defmethod test-getForms-BodyBlock-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo{}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))))))))))))
(defmethod test-getForms-BodyBlock-4 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo{a
                b=45}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) t)) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list COMMENT_TYPE "; source line # 1") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list COMMENT_TYPE "; source line # 1") (list ATOM_TYPE "a") (list COMMENT_TYPE "; source line # 2") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "b") (list ATOM_TYPE "45"))))))))))))))))
(defmethod test-getForms-BodyBlock-5 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo{}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) t)) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list COMMENT_TYPE "; source line # 1") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))))))))))))
(defmethod test-getForms-String-1 ((ts TestTranslFormBuilding)) (let (st) (setf st " \"Hello, World!\" ") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list ATOM_TYPE "\"Hello, World!\"")))))))
(defmethod test-getForms-String-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=\"Hello, \"+\"World!\" ") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "\"Hello, \"") (list ATOM_TYPE "\"World!\"")))))))))))))
(defmethod test-getForms-String-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=\"Hello,
the\"+\" brave,
  new
   World!\" ") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "\"Hello,
the\"") (list ATOM_TYPE "\" brave,
  new
   World!\"")))))))))))))
(defmethod test-getForms-CLisp-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=cl{{(- 1 2)}}-3") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list ATOM_TYPE "(- 1 2)
") (list ATOM_TYPE "3")))))))))))))
(defmethod test-getForms-CLisp-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "cl{{(foo) ; comment
              (boo)}}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list ATOM_TYPE "(foo) ; comment
              (boo)
")))))))
(defmethod test-getForms-Column-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=:a") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE ":a"))))))))))
(defmethod test-getForms-Column-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=::a") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "::a"))))))))))
(defmethod test-getForms-Column-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x= foo : a") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "foo:a"))))))))))
(defmethod test-getForms-Column-4 ((ts TestTranslFormBuilding)) (let (st) (setf st ":x=a") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE ":x") (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-Column-5 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo{}:a") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-Column-6 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=('foo):a") ; have expr 'foo and expr :a - two expr together is illegal
 (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-Column-7 ((ts TestTranslFormBuilding)) (let (st) (setf st "x='foo:a") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list SHORTCUT_TYPE "'" (list ATOM_TYPE "foo:a")))))))))))
(defmethod test-getForms-ObjSlots-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x.a=y.a") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "slot-value") (list ATOM_TYPE "x") (list SHORTCUT_TYPE "'" (list ATOM_TYPE "a"))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "slot-value") (list ATOM_TYPE "y") (list SHORTCUT_TYPE "'" (list ATOM_TYPE "a"))))))))))))))
(defmethod test-getForms-ObjSlots-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x.a=\"Hi\".\\
                     a") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "slot-value") (list ATOM_TYPE "x") (list SHORTCUT_TYPE "'" (list ATOM_TYPE "a"))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "slot-value") (list ATOM_TYPE "\"Hi\"") (list SHORTCUT_TYPE "'" (list ATOM_TYPE "a"))))))))))))))
(defmethod test-getForms-ObjSlots-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x.a=y.
                a") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-ObjSlots-4 ((ts TestTranslFormBuilding)) (let (st) (setf st "x.a=y
               .a") (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-ObjMeth-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=y.foo{a,b}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "y") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-ObjMeth-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=y.foo{}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "y")))))))))))))
(defmethod test-getForms-ObjMeth-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=y.foo()") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "y")))))))))))))
(defmethod test-getForms-ObjMeth-4 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=y.foo(a,b)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "y") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-ObjMeth-5 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=y.foo(a,:b=67)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "y") (list ATOM_TYPE "a") (list ATOM_TYPE ":b") (list ATOM_TYPE "67")))))))))))))
(defmethod test-getForms-Func-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo{a,b}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-Func-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo{}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))))))))))))
(defmethod test-getForms-Func-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo()") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo")))))))))))))
(defmethod test-getForms-Func-4 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo(a,b)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-Func-5 ((ts TestTranslFormBuilding)) (let (st) (setf st "x=foo(a,:b=67)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "a") (list ATOM_TYPE ":b") (list ATOM_TYPE "67")))))))))))))
(defmethod test-getForms-InnerFuncCallList-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "foo(a,b=2, .(c=3,d) e,f)") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "a") (list ATOM_TYPE "b") (list ATOM_TYPE "2") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "c") (list ATOM_TYPE "3") (list ATOM_TYPE "d")))) (list ATOM_TYPE "e") (list ATOM_TYPE "f"))))))))))
(defmethod test-getForms-Dict-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "x={}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-hash-table_")))))))))))))
(defmethod test-getForms-Dict-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "x={a,b
               c}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-hash-table_") (list ATOM_TYPE "a") (list ATOM_TYPE "nil") (list ATOM_TYPE "b") (list ATOM_TYPE "nil") (list ATOM_TYPE "c") (list ATOM_TYPE "nil")))))))))))))
(defmethod test-getForms-Dict-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "x={a,b->45
             c->\"Hi\"}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-hash-table_") (list ATOM_TYPE "a") (list ATOM_TYPE "nil") (list ATOM_TYPE "b") (list ATOM_TYPE "45") (list ATOM_TYPE "c") (list ATOM_TYPE "\"Hi\"")))))))))))))
(defmethod test-getForms-Dict-4 ((ts TestTranslFormBuilding)) (let (st) (setf st "x={a
             b->45-y}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-hash-table_") (list ATOM_TYPE "a") (list ATOM_TYPE "nil") (list ATOM_TYPE "b") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list ATOM_TYPE "45") (list ATOM_TYPE "y"))))))))))))))))
(defmethod test-getForms-Dict-5 ((ts TestTranslFormBuilding)) (let (st) (setf st "x={a,->45
             c->\"Hi\"}") ; key is missing before '->'
 (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-Dict-6 ((ts TestTranslFormBuilding)) (let (st) (setf st "x={a,b->
             c->\"Hi\"}") ; value is missing after '->'
 (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-Getitem-1 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[]") ; missing any index
 (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-Getitem-2 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[->]") ; missing any index
 (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-Getitem-3 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[->,2]") ; missing any index
 (let (allElems) (setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(defmethod test-getForms-Getitem-4 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[2]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_getitem_") (list ATOM_TYPE "a") (list ATOM_TYPE "2"))))))))))
(defmethod test-getForms-Getitem-5 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[2->]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_getitem_") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-slice_") (list ATOM_TYPE "2") (list ATOM_TYPE "nil") (list ATOM_TYPE "nil")))))))))))))
(defmethod test-getForms-Getitem-6 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[->2]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_getitem_") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-slice_") (list ATOM_TYPE "nil") (list ATOM_TYPE "2") (list ATOM_TYPE "nil")))))))))))))
(defmethod test-getForms-Getitem-7 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[2->9]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_getitem_") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-slice_") (list ATOM_TYPE "2") (list ATOM_TYPE "9") (list ATOM_TYPE "nil")))))))))))))
(defmethod test-getForms-Getitem-8 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[2->9,2]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_getitem_") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-slice_") (list ATOM_TYPE "2") (list ATOM_TYPE "9") (list ATOM_TYPE "2")))))))))))))
(defmethod test-getForms-Getitem-9 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[2->,2]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_getitem_") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-slice_") (list ATOM_TYPE "2") (list ATOM_TYPE "nil") (list ATOM_TYPE "2")))))))))))))
(defmethod test-getForms-Getitem-10 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[->9,2]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_getitem_") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_make-slice_") (list ATOM_TYPE "nil") (list ATOM_TYPE "9") (list ATOM_TYPE "2")))))))))))))
(defmethod test-getForms-Getitem-11 ((ts TestTranslFormBuilding)) (let (st) (setf st "a[1,2,3,4]") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_getitem_") (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "list") (list ATOM_TYPE "1") (list ATOM_TYPE "2") (list ATOM_TYPE "3") (list ATOM_TYPE "4")))))))))))))
