;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defclass TestTranslFormBuildingTwo (unittest:testcase) ((unittest:tName :initform "TestTranslFormBuildingTwo.twl") (unittest:tFuns :initform '(test-getForms-BlockForm-1 test-getForms-BlockForm-2 test-getForms-BlockForm-3 test-getForms-BlockForm-4 test-getForms-BlockForm-5 test-getForms-BlockForm-6 test-getForms-BlockForm-7 test-getForms-BlockForm-8 test-getForms-BlockForm-9 test-getForms-BlockForm-10 test-getForms-BlockForm-11 test-getForms-LambdaList-1 test-getForms-LambdaList-2 test-getForms-LambdaList-3 test-getForms-LambdaList-4 test-getForms-LambdaList-5 test-getForms-LambdaList-6 test-getForms-LambdaList-7 test-getForms-LambdaList-8 test-getForms-LambdaList-9 test-getForms-LambdaList-10 test-getForms-LambdaList-11 test-getForms-LambdaList-12 test-getForms-MacLambdaList-1 test-getForms-LetList-1 test-getForms-LetList-2 test-getForms-LetList-3 test-getForms-LetList-4 test-getForms-LetList-5 test-getForms-BlockName-1 test-getForms-BlockName-2 test-getForms-BlockName-3 test-getForms-BlockName-4 test-getForms-BlockName-5 test-getForms-DoLists-1 test-getForms-DoLists-2 test-getForms-DoLists-3 test-getForms-DoLists-4 test-getForms-DoLists-5 test-getForms-DoLists-6 test-getForms-DoLists-7 test-getForms-DoLists-8 test-getForms-DoLists-9 test-getForms-Break-1 test-getForms-Break-2 test-getForms-Break-3 test-getForms-Break-4 test-getForms-Break-5 test-getForms-Break-6 test-getForms-Return-1 test-getForms-Return-2 test-getForms-Return-3 test-getForms-Return-4 test-getForms-If-1 test-getForms-If-2 test-getForms-If-3 test-getForms-If-4 test-getForms-If-5 test-getForms-If-6 test-getForms-Flet-1 test-getForms-Flet-2 test-getForms-Flet-And-Return-1))))
(defmethod test-getForms-BlockForm-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo() {
              ~()
              ~()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo\\
                () {
              ~()
              ~()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-3 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo
                () {
              ~()
              ~()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-4 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo ()
             {~()
              ~()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-5 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo() {
              progn{~(), ~()}
              ~()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "progn") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_))))) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-6 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo {
              ~()
              ~()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-7 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo 
             {~()
              ~()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-8 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def $foo {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list SHORTCUT_TYPE "," (list ATOM_TYPE "foo")) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-9 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def `$foo {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list SHORTCUT_TYPE "`" (list SHORTCUT_TYPE "," (list ATOM_TYPE "foo"))) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-10 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def setter foo {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "foo")))) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-BlockForm-11 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def setter $foo {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list SHORTCUT_TYPE "," (list ATOM_TYPE "foo"))))) (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-LambdaList-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))))))))))))
(defmethod test-getForms-LambdaList-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))))))))))))
(defmethod test-getForms-LambdaList-3 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,b) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-LambdaList-4 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,b,) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-LambdaList-5 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,b,&&key) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "b") (list ATOM_TYPE "&key")))))))))))))
(defmethod test-getForms-LambdaList-6 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,&&optional,b) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list ATOM_TYPE "b")))))))))))))
(defmethod test-getForms-LambdaList-7 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,b=5) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "5"))))))))))))))))
(defmethod test-getForms-LambdaList-8 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,b=5=?bPresent) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "5") (list ATOM_TYPE "bPresent"))))))))))))))))
(defmethod test-getForms-LambdaList-9 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,b=?bPresent) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "nil") (list ATOM_TYPE "bPresent"))))))))))))))))
(defmethod test-getForms-LambdaList-10 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,bKey->b=?bPresent) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&key") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bKey") (list ATOM_TYPE "b")))) (list ATOM_TYPE "nil") (list ATOM_TYPE "bPresent"))))))))))))))))
(defmethod test-getForms-LambdaList-11 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,bKey->b=5=?bPresent) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&key") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "bKey") (list ATOM_TYPE "b")))) (list ATOM_TYPE "5") (list ATOM_TYPE "bPresent"))))))))))))))))
(defmethod test-getForms-LambdaList-12 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo(a,&&aux b=5) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "&aux") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "5"))))))))))))))))
(defmethod test-getForms-MacLambdaList-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "mac foo(a,.(**body),b=5=?bPresent) {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defmacro") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "&body") (list ATOM_TYPE "body")))) (list ATOM_TYPE "&optional") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "5") (list ATOM_TYPE "bPresent"))))))))))))))))
(defmethod test-getForms-LetList-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "let () {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_)) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-LetList-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "let {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_)) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-LetList-3 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "let (x,y) {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x") (list ATOM_TYPE "y")))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-LetList-4 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "let (x,y=a) {y}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "y") (list ATOM_TYPE "a"))))))) (list ATOM_TYPE "y"))))))))))
(defmethod test-getForms-LetList-5 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "let (x,y=a=5) {y}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "let") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "x") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "y") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "a") (list ATOM_TYPE "5")))))))))) (list ATOM_TYPE "y"))))))))))
(defmethod test-getForms-BlockName-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "block {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "block") (list ATOM_TYPE "nil") (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-BlockName-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "block nil {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "block") (list ATOM_TYPE "nil") (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-BlockName-3 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "block foo {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "block") (list ATOM_TYPE "foo") (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-BlockName-4 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "block $foo {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "block") (list SHORTCUT_TYPE "," (list ATOM_TYPE "foo")) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-BlockName-5 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "block `$foo {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "block") (list SHORTCUT_TYPE "`" (list SHORTCUT_TYPE "," (list ATOM_TYPE "foo"))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do () {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE LISP_NIL)))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do () () {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE LISP_NIL)))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-3 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do () (a==2) {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_==_") (list ATOM_TYPE "a") (list ATOM_TYPE "2"))))))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-4 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do () (a==2,\"Some computed form\",\"Return result\") {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_==_") (list ATOM_TYPE "a") (list ATOM_TYPE "2")))) (list ATOM_TYPE "\"Some computed form\"") (list ATOM_TYPE "\"Return result\"")))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-5 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do (a) (a==2,\"Return result\") {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_==_") (list ATOM_TYPE "a") (list ATOM_TYPE "2")))) (list ATOM_TYPE "\"Return result\"")))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-6 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do (a=0,b) (a==2,\"Return result\") {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "0")))) (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_==_") (list ATOM_TYPE "a") (list ATOM_TYPE "2")))) (list ATOM_TYPE "\"Return result\"")))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-7 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do (a=0->a+b,b=1) {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "0") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "1"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE LISP_NIL)))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-8 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do (a->a+b,b=1) (a==2,\"Return result\") {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "nil") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list ATOM_TYPE "1"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_==_") (list ATOM_TYPE "a") (list ATOM_TYPE "2")))) (list ATOM_TYPE "\"Return result\"")))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-DoLists-9 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "do 
            (a=0->a+b)
            (a==2,\"Return result\") 
            {a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "0") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b")))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_==_") (list ATOM_TYPE "a") (list ATOM_TYPE "2")))) (list ATOM_TYPE "\"Return result\"")))) (list ATOM_TYPE "a"))))))))))
(defmethod test-getForms-Break-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "break
          x=3") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "nil") (list FORM_TYPE (_make-vector_))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "3"))))))))))
(defmethod test-getForms-Break-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "break x=3") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "nil") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "3")))))))))))))
(defmethod test-getForms-Break-3 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "break from blockName x=3") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "blockName") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "3")))))))))))))
(defmethod test-getForms-Break-4 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "break from blockName
          x=3") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "blockName") (list FORM_TYPE (_make-vector_))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "3"))))))))))
(defmethod test-getForms-Break-5 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "break from $blockName
          x=3") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list SHORTCUT_TYPE "," (list ATOM_TYPE "blockName")) (list FORM_TYPE (_make-vector_))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "3"))))))))))
(defmethod test-getForms-Break-6 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "break from `$blockName
          x=3") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list SHORTCUT_TYPE "`" (list SHORTCUT_TYPE "," (list ATOM_TYPE "blockName"))) (list FORM_TYPE (_make-vector_))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "3"))))))))))
(defmethod test-getForms-Return-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo {return}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_))))))))))))))
(defmethod test-getForms-Return-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo {return a}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list ATOM_TYPE "a")))))))))))))
(defmethod test-getForms-Return-3 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo {return a@b@c}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "values") (list ATOM_TYPE "a") (list ATOM_TYPE "b") (list ATOM_TYPE "c"))))))))))))))))
(defmethod test-getForms-Return-4 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "def foo {do () () {return a@b@c}}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "defun") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "do") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE LISP_NIL)))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "values") (list ATOM_TYPE "a") (list ATOM_TYPE "b") (list ATOM_TYPE "c")))))))))))))))))))
(defmethod test-getForms-If-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "if (a) {x=b}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "cond") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "b"))))))))))))))))
(defmethod test-getForms-If-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "if (a) {x=b}
          elif (c) {y=0}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "cond") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "c") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "0"))))))))))))))))
(defmethod test-getForms-If-3 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "if (a) {x=b}
          elif (c) {y=0}
          elif (d) {y=1}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "cond") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "c") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "0"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "d") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "1"))))))))))))))))
(defmethod test-getForms-If-4 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "if (a) {x=b}
          elif (c) {y=0}
          else {foo()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "cond") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "c") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "0"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "t") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo"))))))))))))))))
(defmethod test-getForms-If-5 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "if (a) {x=b}
          elif (b) {x=0}
          elif (c) {y=0}
          else {foo()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "cond") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "0"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "c") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "y") (list ATOM_TYPE "0"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "t") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo"))))))))))))))))
(defmethod test-getForms-If-6 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "if (a) {x=b}
          else {foo()}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "cond") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "setf") (list ATOM_TYPE "x") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "t") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo"))))))))))))))))
(defmethod test-getForms-Flet-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "flet {}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "flet") (list FORM_TYPE (_make-vector_)))))))))))
(defmethod test-getForms-Flet-2 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "flet foo (a,b) {a+b}
               boo (a,b) {a*b}
               pr {}
             {foo(1,2)-boo(3,4)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "flet") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_+_") (list ATOM_TYPE "a") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "boo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a") (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_*_") (list ATOM_TYPE "a") (list ATOM_TYPE "b"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "pr") (list FORM_TYPE (_make-vector_)))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "1") (list ATOM_TYPE "2")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "boo") (list ATOM_TYPE "3") (list ATOM_TYPE "4"))))))))))))))))
(defmethod test-getForms-Flet-And-Return-1 ((ts TestTranslFormBuildingTwo)) (let (st) (setf st "flet foo {return}
               boo (a) {return a}
               pr (b) {return}
             {foo(1,2)-boo(3,4)}") (let (forms) (setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "flet") (list FORM_TYPE (_make-vector_ :initContent (list (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "foo") (list FORM_TYPE (_make-vector_)))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "boo") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "a")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "boo") (list ATOM_TYPE "a"))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "pr") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "b")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "return-from") (list ATOM_TYPE "pr") (list FORM_TYPE (_make-vector_))))))))))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "_-_") (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "foo") (list ATOM_TYPE "1") (list ATOM_TYPE "2")))) (list FORM_TYPE (_make-vector_ :initContent (list (list ATOM_TYPE "boo") (list ATOM_TYPE "3") (list ATOM_TYPE "4"))))))))))))))))
