;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defun find-file-in-load-paths (fName) (cl:let (str) (cl:setf str (cl:do ((str fName) semColInd (dirSepar (tl-dir-sep))) (cl:nil) (cl:setf semColInd (index str #\;)) (cl:cond (semColInd (cl:setf str (_+_ (_+_ (_getitem_ str (_make-slice_ cl:nil semColInd cl:nil)) dirSepar) (_getitem_ str (_make-slice_ (_+_ semColInd 1) cl:nil cl:nil))))) (cl:t (cl:return-from cl:nil str))))) (cl:cond ((_!=_ (_getitem_ str (_make-slice_ (_-_ (len str) 4) cl:nil cl:nil)) ".twl") (cl:setf str (_+_ str ".twl")))) (cl:let (fileExits folder) (cl:setf (cl:values str fileExits folder) (tl-for (dirName CUSTOM:*LOAD-PATHS* (dirSepar (tl-dir-sep))) ((cl:values cl:nil cl:nil cl:nil)) (cl:cond ((typep dirName 'pathname) (cl:setf dirName (namestring dirName)))) (cl:do () (cl:nil) (cl:let (starInd) (cl:setf starInd (index dirName #\*)) (cl:cond (starInd (cl:setf dirName (_+_ (_getitem_ dirName (_make-slice_ cl:nil starInd cl:nil)) (_getitem_ dirName (_make-slice_ (_+_ starInd 1) cl:nil cl:nil))))) (cl:t (cl:return-from cl:nil ()))))) (cl:cond ((probe-file (_+_ dirName str)) (cl:return-from cl:nil (cl:values (_+_ dirName str) cl:t cl:nil)))) (cl:cond ((probe-file (_+_ (_+_ (_+_ dirName (_getitem_ str (_make-slice_ cl:nil (_-_ (len str) 4) cl:nil))) dirSepar) "_load_.twl")) (cl:return-from cl:nil (cl:values (_+_ (_+_ (_+_ dirName (_getitem_ str (_make-slice_ cl:nil (_-_ (len str) 4) cl:nil))) dirSepar) "_load_.twl") cl:t (_+_ (_+_ dirName (_getitem_ str (_make-slice_ cl:nil (_-_ (len str) 4) cl:nil))) dirSepar))))))) (cl:cond (fileExits (cl:let (lispName) (cl:setf lispName (_getitem_ str (_make-slice_ cl:nil (_-_ (len str) 4) cl:nil))) (cl:cond ((probe-file (_+_ lispName ".lisp")) (cl:cond ((_<_ (file-write-date (_+_ lispName ".lisp")) (file-write-date str)) (translate-file str (_+_ lispName ".lisp"))))) (cl:t (translate-file str (_+_ lispName ".lisp")))) (cl:values lispName folder))) (cl:t (cl:values fName cl:nil))))))
(cl:defun find-and-translate-file (filename) (cl:cond ((typep filename 'string) (find-file-in-load-paths filename)) ((typep filename 'symbol) (find-file-in-load-paths (string-downcase (_%_ "~A" filename)))) (cl:t (error (_%_ "&tl-load and &tl-require do not support filename of type '~A'" (type-of filename))))))
(cl:defmacro tl-load (filename &rest rest) (cl:let ((lispPath (gensym)) (folder (gensym))) `(cl:let (,lispPath ,folder) (cl:setf (cl:values ,lispPath ,folder) (find-and-translate-file ,filename)) (cl:cond (,folder (insert CUSTOM:*LOAD-PATHS* 0 ,folder))) (prog1 (cl:load ,lispPath ,@rest) (cl:cond (,folder (tl-remove CUSTOM:*LOAD-PATHS* ,folder)))))))
(cl:defmacro tl-require (filename &rest rest) (cl:let ((lispPath (gensym)) (folder (gensym))) `(cl:let (,lispPath ,folder) (cl:setf (cl:values ,lispPath ,folder) (find-and-translate-file ,filename)) (cl:cond (,folder (insert CUSTOM:*LOAD-PATHS* 0 ,folder))) (prog1 (cl:require ,lispPath ,@rest) (cl:cond (,folder (tl-remove CUSTOM:*LOAD-PATHS* ,folder)))))))
