;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;;
;;   constants
;;
(cl:in-package "TWINLISP")
; Common Lisp package name with a colomn to attach to names
(const CL_PACK "cl:")
(const CLISP_START_STRING "cl{{")
(const CLISP_END_STRING "}}")
; BRACKETS describes enclosing symbols (brackets): key is an openning 'bracket', value is a closing one
(const BRACKETS (_make-hash-table_ "(" ")" "[" "]" "{" "}" "~(" ")" "~[" "]"))
(const CLOSING_BRACKETS (tValues BRACKETS))
; types of operator association
(const RIGHT_ASSOC :right_assoc)
(const LEFT_ASSOC :left_assoc)
(const MULT_ARGS_ASSOC :mult_assoc)
(const UNAR_OPERS (_make-hash-table_ "+" (cl:list "_unary+_" 2 RIGHT_ASSOC) "-" (cl:list "_unary-_" 2 RIGHT_ASSOC) "!" (cl:list "_not_" 2 RIGHT_ASSOC) "not" (cl:list "_not_" 2 RIGHT_ASSOC)))
(const BIN_OPERS (_make-hash-table_ "**" (cl:list "_**_" 3 RIGHT_ASSOC) "*" (cl:list "_*_" 4 LEFT_ASSOC) "/" (cl:list "_/_" 4 LEFT_ASSOC) "%" (cl:list "_%_" 4 LEFT_ASSOC) "+" (cl:list "_+_" 5 LEFT_ASSOC) "-" (cl:list "_-_" 5 LEFT_ASSOC) "<" (cl:list "_<_" 7 LEFT_ASSOC) ">" (cl:list "_>_" 7 LEFT_ASSOC) "<=" (cl:list "_<=_" 7 LEFT_ASSOC) ">=" (cl:list "_>=_" 7 LEFT_ASSOC) "==" (cl:list "_==_" 8 LEFT_ASSOC) "!=" (cl:list "_!=_" 8 LEFT_ASSOC) "&" (cl:list "_and_" 9 LEFT_ASSOC) "and" (cl:list "_and_" 9 LEFT_ASSOC) "^" (cl:list "_xor_" 10 LEFT_ASSOC) "xor" (cl:list "_xor_" 10 LEFT_ASSOC) "|" (cl:list "_or_" 11 LEFT_ASSOC) "or" (cl:list "_or_" 11 LEFT_ASSOC) "<<" (cl:list "_<<_" 13 LEFT_ASSOC) "@" (cl:list (_+_ CL_PACK "values") 14 MULT_ARGS_ASSOC) "=" (cl:list (_+_ CL_PACK "setf") 15 RIGHT_ASSOC) "+=" (cl:list "_+=_" 15 RIGHT_ASSOC) "-=" (cl:list "_-=_" 15 RIGHT_ASSOC) "*=" (cl:list "_*=_" 15 RIGHT_ASSOC) "/=" (cl:list "_/=_" 15 RIGHT_ASSOC)))
(const OPER_SYMB (cl:list "and" "or" "xor" "not"))
; "word" operator, not a block structure
(const SHORTCUT_OPERS (_make-hash-table_ "'" "'" "#." "#." "#'" "#'" "`" "`" "$" "," "$@" ",@"))
(const COMPL_NUM_OPER (cl:list "#C" "#c"))
; TwinLisp's names of funcs/methods
(const MAKE_SIMPLE_ARRAY_FUNC "_make-vector_")
(const MAKE_LIST_FUNC (_+_ CL_PACK "list"))
(const MAKE_COMPLEX_NUM_FUNC (_+_ CL_PACK "complex"))
(const MAKE_DICTIONARY_FUNC "_make-hash-table_")
(const GET_ITEM_FUNC "_getitem_")
(const MAKE_SLICE_FUNC "_make-slice_")
(const GET_OBJ_SLOT_FUNC (_+_ CL_PACK "slot-value"))
(const LISP_NIL (_+_ CL_PACK "nil"))
(const LISP_T (_+_ CL_PACK "t"))
(const LISP_LET (_+_ CL_PACK "let"))
(const LISP_PROGN (_+_ CL_PACK "progn"))
(const SETTER_FUNC (_+_ CL_PACK "setf"))
; Nicknames to "popular" methods
(const TWL_METH_NICKNAMES (_make-hash-table_ "t" LISP_T "nil" LISP_NIL "progn" LISP_PROGN "tagbody" (_+_ CL_PACK "tagbody") "pop" "tl-pop" "_pop" (_+_ CL_PACK "pop") "remove" "tl-remove" "_remove" (_+_ CL_PACK "remove") "append" "tl-append" "_append" (_+_ CL_PACK "append") "count" "tl-count" "_count" (_+_ CL_PACK "count") "load" "tl-load" "_load" (_+_ CL_PACK "load") "require" "tl-require" "_require" (_+_ CL_PACK "require") "times" "tl-times" "_times" (_+_ CL_PACK "times")))
; DOUBLE_CHAR_OPERS is used in string reading to mark elements
(const MULTI_CHAR_OPERS (cl:flet ((appTable (mTab opTab) (cl:do* ((i 0 (_+_ i 1)) (items (tItems opTab))) ((_>=_ i (len items))) (cl:let (oper) (cl:setf oper (first (_getitem_ items i))) (cl:cond ((_and_ (_==_ (tl-count OPER_SYMB oper) 0) (_>_ (len oper) 1)) (cl:cond ((has_key mTab (_getitem_ oper 0)) (tl-append (_getitem_ mTab (_getitem_ oper 0)) oper)) (cl:t (cl:setf (_getitem_ mTab (_getitem_ oper 0)) (cl:list oper))))))))) (addOper (mTab opers) (cl:do* ((i 0 (_+_ i 1))) ((_>=_ i (len opers))) (cl:let (oper) (cl:setf oper (_getitem_ opers i)) (cl:cond ((has_key mTab (_getitem_ oper 0)) (tl-append (_getitem_ mTab (_getitem_ oper 0)) oper)) (cl:t (cl:setf (_getitem_ mTab (_getitem_ oper 0)) (cl:list oper)))))))) (cl:let (multOpers) (cl:setf multOpers (_make-hash-table_)) (appTable multOpers UNAR_OPERS) (appTable multOpers BIN_OPERS) (appTable multOpers SHORTCUT_OPERS) (addOper multOpers COMPL_NUM_OPER) (addOper multOpers (cl:list "~(" "~[" "->" "::" "=?")) multOpers)))
; types of elements extracted from string
(const SYMB_ELEM :symbol_elem)
(const SPEC_SYMB_ELEM :spec_symbol_elem)
(const NUM_ELEM :number_elem)
(const SYNT_STRUCT_ELEM :syntactic_structure)
(const STR_START_ELEM :string_start_elem)
(const STR_MID_ELEM :string_middle_elem)
(const STR_END_ELEM :string_end_elem)
(const CLISP_START_ELEM :clisp_code_start_elem)
(const CLISP_MID_ELEM :clisp_code_middle_elem)
(const CLISP_END_ELEM :clisp_code_end_elem)
(const WHITE_ELEM :white_space_elem)
(const COMM_ELEM :comment_elem)
(const LINE_END_ELEM :end_of_line_elem)
(cl:defstruct (StrElem) type value lineNum start end)
; AUX_SPEC_SYMB is a list of special words that might be used inside of TL_BLOCK's or TL's directives
(const AUX_SPEC_SYMB (cl:list "elif" "else" "from" "is" "options" "finally" "at" "cond" "meth"))
(const SETTER_SPEC_SYMB "setter")
(tl-append AUX_SPEC_SYMB SETTER_SPEC_SYMB)
; TL_DIRECT_SPEC_SYMB is a list of special words that start TL's directives
(const TL_DIR_GLOBAL "global")
(const TL_DIR_LEXSCOPE "lexscope")
(const TL_EXPL_SCOPE "explicit")
(const TL_IMPL_SCOPE "implicit")
(const TL_DIR_USE "use")
(const TL_DIRECT_SPEC_SYMB (cl:list TL_DIR_GLOBAL TL_DIR_LEXSCOPE TL_EXPL_SCOPE TL_IMPL_SCOPE TL_DIR_USE))
; TYPE's are types of nodes ready for writting 'em directly into lisp code
(const COMMENT_TYPE :comment_type)
(const SHORTCUT_TYPE :shortcut_type)
(const ATOM_TYPE :atom_type)
(const FORM_TYPE :form_type)
; constants for use in TL_BLOCK descriptions and/or in functions that work with elements from TL_BLOCK's
(const OPTIONAL :optional_element)
(const MULT :repeat_several_times)
(const LAMBDA_LIST_OPTIONS (cl:list "&optional" "&rest" "&key" "&allow-other-keys" "&aux"))
(const MAC_LAMBDA_LIST_OPTIONS (_+_ LAMBDA_LIST_OPTIONS (cl:list "&body" "&whole" "&environment")))
(const FUN_NAME :function_name)
; one form
(const GEN_FUN_NAME :generic_function_name)
; one form
(const NAME :name_on_current_line)
; one form
(const NAME2 :name_on_diff_line)
; one form
(const FUN_NAME_FROM_LEVEL :func_name_from_level_info)
; one form
(const LAMBDA_LIST :lambda_list)
; one form
(const MAC_LAMBDA_LIST :macro_lambda_list)
; one form
(const SPEC_LAMBDA_LIST :specializer_lambda_list)
; one form
(const LET_LIST :let_list)
; one form
(const DO_VAR_LIST :do_vars_list)
; one form
(const DO_TEST_RES_LIST :do_test_result_list)
; one form
(const BODY_BLOCK :body_block)
; many forms
(const MAC_BODY_BLOCK :mac_body_block)
; many forms
(const FUN_BODY_BLOCK :func_body_block)
; many forms
(const GEN_FUN_METH_BODY_BLOCK :generic_func_method_body_block)
; many forms
(const OPER_EXPR :oper_expr)
; one form
(const OPER_EXPR_IN_BRACK :oper_expr_in_round_brackets)
; one form
(const MULT_OPER_EXPR_IN_BRACK :mult_oper_expr_in_round_brackets)
; one form
(const STRUCT_SLOTS :struct_slots_defs)
(const STRUCT_OPTIONS :struct_options)
(const CLASS_SLOTS_LIST :class_slots_defs_list)
(const CLASS_OPTIONS :class_options)
(const METH_QUALIF :meth_qualifier)
; TL_BLOCK gives descriptions of each special TwinLisp language constract;
;  - keys are special words that start their respective TL_BLOCK's
(const TL_BLOCK (_make-hash-table_ "def" (cl:list (_make-vector_ :initContent (cl:list FUN_NAME (cl:list LAMBDA_LIST OPTIONAL) FUN_BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "defun") 0 1 2))) "lambda" (cl:list (_make-vector_ :initContent (cl:list (cl:list LAMBDA_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "lambda") 0 1))) "mac" (cl:list (_make-vector_ :initContent (cl:list NAME2 (cl:list MAC_LAMBDA_LIST OPTIONAL) MAC_BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "defmacro") 0 1 2))) "block" (cl:list (_make-vector_ :initContent (cl:list (cl:list NAME2 OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "block") 0 1))) "catch" (cl:list (_make-vector_ :initContent (cl:list NAME2 BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "catch") 0 1))) "throw" (cl:list (_make-vector_ :initContent (cl:list NAME (cl:list OPER_EXPR OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "throw") 0 1))) "let" (cl:list (_make-vector_ :initContent (cl:list (cl:list LET_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "let") 0 1))) "lets" (cl:list (_make-vector_ :initContent (cl:list (cl:list LET_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "let*") 0 1))) "prog" (cl:list (_make-vector_ :initContent (cl:list (cl:list LET_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "prog") 0 1))) "progs" (cl:list (_make-vector_ :initContent (cl:list (cl:list LET_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "prog*") 0 1))) "do" (cl:list (_make-vector_ :initContent (cl:list DO_VAR_LIST (cl:list DO_TEST_RES_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "do") 0 1 2))) "dos" (cl:list (_make-vector_ :initContent (cl:list DO_VAR_LIST (cl:list DO_TEST_RES_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "do*") 0 1 2))) "for" (cl:list (_make-vector_ :initContent (cl:list DO_VAR_LIST (cl:list DO_TEST_RES_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list "tl-for" 0 1 2))) "times" (cl:list (_make-vector_ :initContent (cl:list DO_VAR_LIST (cl:list DO_TEST_RES_LIST OPTIONAL) BODY_BLOCK)) (_make-vector_ :initContent (cl:list "tl-times" 0 1 2))) "flet" (cl:list (_make-vector_ :initContent (cl:list (cl:list (_make-vector_ :initContent (cl:list FUN_NAME (cl:list LAMBDA_LIST OPTIONAL) FUN_BODY_BLOCK)) OPTIONAL MULT) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "flet") (_make-vector_ :initContent (cl:list (cl:list 0 OPTIONAL MULT (_make-vector_ :initContent (cl:list 0 1 2))))) 1))) "labels" (cl:list (_make-vector_ :initContent (cl:list (cl:list (_make-vector_ :initContent (cl:list FUN_NAME (cl:list LAMBDA_LIST OPTIONAL) FUN_BODY_BLOCK)) OPTIONAL MULT) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "labels") (_make-vector_ :initContent (cl:list (cl:list 0 OPTIONAL MULT (_make-vector_ :initContent (cl:list 0 1 2))))) 1))) "maclet" (cl:list (_make-vector_ :initContent (cl:list (cl:list (_make-vector_ :initContent (cl:list NAME2 (cl:list MAC_LAMBDA_LIST OPTIONAL) MAC_BODY_BLOCK)) OPTIONAL MULT) MAC_BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "macrolet") (_make-vector_ :initContent (cl:list (cl:list 0 OPTIONAL MULT (_make-vector_ :initContent (cl:list 0 1 2))))) 1))) "if" (cl:list (_make-vector_ :initContent (cl:list OPER_EXPR_IN_BRACK BODY_BLOCK (cl:list (_make-vector_ :initContent (cl:list "elif" OPER_EXPR_IN_BRACK BODY_BLOCK)) OPTIONAL MULT) (cl:list (_make-vector_ :initContent (cl:list "else" BODY_BLOCK)) OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "cond") (_make-vector_ :initContent (cl:list 0 1)) (cl:list 2 MULT OPTIONAL (_make-vector_ :initContent (cl:list 0 1))) (cl:list 3 OPTIONAL (_make-vector_ :initContent (cl:list LISP_T 0)))))) "case" (cl:list (_make-vector_ :initContent (cl:list OPER_EXPR_IN_BRACK (cl:list (_make-vector_ :initContent (cl:list "is" MULT_OPER_EXPR_IN_BRACK BODY_BLOCK)) OPTIONAL MULT) (cl:list (_make-vector_ :initContent (cl:list "else" BODY_BLOCK)) OPTIONAL))) (_make-vector_ :initContent (cl:list "tl-case" 0 (cl:list 2 OPTIONAL (_make-vector_ :initContent (cl:list 0)) LISP_NIL) (cl:list 1 MULT OPTIONAL (_make-vector_ :initContent (cl:list (_make-vector_ :initContent (cl:list 0)) 1)))))) "comcase" (cl:list (_make-vector_ :initContent (cl:list OPER_EXPR_IN_BRACK (cl:list (_make-vector_ :initContent (cl:list "is" MULT_OPER_EXPR_IN_BRACK BODY_BLOCK)) OPTIONAL MULT) (cl:list (_make-vector_ :initContent (cl:list "else" BODY_BLOCK)) OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "case") 0 (cl:list 1 MULT OPTIONAL (_make-vector_ :initContent (cl:list (_make-vector_ :initContent (cl:list 0)) 1))) (cl:list 2 OPTIONAL (_make-vector_ :initContent (cl:list (_+_ CL_PACK "otherwise") 0)))))) "typecase" (cl:list (_make-vector_ :initContent (cl:list OPER_EXPR_IN_BRACK (cl:list (_make-vector_ :initContent (cl:list "is" OPER_EXPR_IN_BRACK BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "typecase") 0 (cl:list 1 MULT OPTIONAL (_make-vector_ :initContent (cl:list 0 1)))))) "return" (cl:list (_make-vector_ :initContent (cl:list FUN_NAME_FROM_LEVEL (cl:list (_make-vector_ :initContent (cl:list "from" NAME)) OPTIONAL) (cl:list OPER_EXPR OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "return-from") (cl:list 1 OPTIONAL 0 0) 2))) "break" (cl:list (_make-vector_ :initContent (cl:list (cl:list (_make-vector_ :initContent (cl:list "from" NAME)) OPTIONAL) (cl:list OPER_EXPR OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "return-from") (cl:list 0 OPTIONAL 0 LISP_NIL) 1))) "struct" (cl:list (_make-vector_ :initContent (cl:list NAME2 STRUCT_SLOTS (cl:list (_make-vector_ :initContent (cl:list "options" STRUCT_OPTIONS)) OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "defstruct") (_make-vector_ :initContent (cl:list 0 (cl:list 2 OPTIONAL 0))) 1))) "class" (cl:list (_make-vector_ :initContent (cl:list NAME2 (cl:list LET_LIST OPTIONAL) CLASS_SLOTS_LIST (cl:list (_make-vector_ :initContent (cl:list "options" CLASS_OPTIONS)) OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "defclass") 0 1 2 (cl:list 3 OPTIONAL 0)))) "cond" (cl:list (_make-vector_ :initContent (cl:list NAME2 (cl:list LET_LIST OPTIONAL) CLASS_SLOTS_LIST (cl:list (_make-vector_ :initContent (cl:list "options" CLASS_OPTIONS)) OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "define-condition") 0 1 2 (cl:list 3 OPTIONAL 0)))) "meth" (cl:list (_make-vector_ :initContent (cl:list FUN_NAME (cl:list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST FUN_BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "defmethod") 0 1 2 3))) "package" (cl:list (_make-vector_ :initContent (cl:list NAME2 (cl:list STRUCT_SLOTS OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "defpackage") 0 1))) "inside" (cl:list (_make-vector_ :initContent (cl:list NAME2)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "in-package") 0))) "try" (cl:list (_make-vector_ :initContent (cl:list BODY_BLOCK (_make-vector_ :initContent (cl:list "finally" BODY_BLOCK)))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "unwind-protect") (_make-vector_ :initContent (cl:list LISP_PROGN 0)) (cl:list 1 0)))) "restart" (cl:list (_make-vector_ :initContent (cl:list BODY_BLOCK (cl:list (_make-vector_ :initContent (cl:list "at" (cl:list NAME2 OPTIONAL) (cl:list LAMBDA_LIST OPTIONAL) BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "restart-case") (_make-vector_ :initContent (cl:list LISP_PROGN 0)) (cl:list 1 MULT OPTIONAL (_make-vector_ :initContent (cl:list 0 1 2)))))) "handle" (cl:list (_make-vector_ :initContent (cl:list BODY_BLOCK (cl:list (_make-vector_ :initContent (cl:list "cond" NAME2 (cl:list LET_LIST OPTIONAL) BODY_BLOCK)) OPTIONAL MULT) (cl:list (_make-vector_ :initContent (cl:list "else" LAMBDA_LIST BODY_BLOCK)) OPTIONAL))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "handler-case") (_make-vector_ :initContent (cl:list LISP_PROGN 0)) (cl:list 1 MULT OPTIONAL (_make-vector_ :initContent (cl:list 0 1 2))) (cl:list 2 OPTIONAL (_make-vector_ :initContent (cl:list ":no-error" 0 1)))))) "defgen" (cl:list (_make-vector_ :initContent (cl:list GEN_FUN_NAME LAMBDA_LIST (cl:list (_make-vector_ :initContent (cl:list "options" CLASS_OPTIONS)) OPTIONAL) (cl:list (_make-vector_ :initContent (cl:list "meth" (cl:list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST GEN_FUN_METH_BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "defgeneric") 0 1 (cl:list 2 OPTIONAL 0) (cl:list 3 MULT OPTIONAL (_make-vector_ :initContent (cl:list ":method" 0 1 2)))))) "glet" (cl:list (_make-vector_ :initContent (cl:list (cl:list (_make-vector_ :initContent (cl:list GEN_FUN_NAME LAMBDA_LIST (cl:list (_make-vector_ :initContent (cl:list "options" CLASS_OPTIONS)) OPTIONAL) (cl:list (_make-vector_ :initContent (cl:list "meth" (cl:list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST GEN_FUN_METH_BODY_BLOCK)) OPTIONAL MULT))) OPTIONAL MULT) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "generic-flet") (_make-vector_ :initContent (cl:list (cl:list 0 OPTIONAL MULT (_make-vector_ :initContent (cl:list 0 1 (cl:list 2 OPTIONAL 0) (cl:list 3 MULT OPTIONAL (_make-vector_ :initContent (cl:list ":method" 0 1 2)))))))) 1))) "glabels" (cl:list (_make-vector_ :initContent (cl:list (cl:list (_make-vector_ :initContent (cl:list GEN_FUN_NAME LAMBDA_LIST (cl:list (_make-vector_ :initContent (cl:list "options" CLASS_OPTIONS)) OPTIONAL) (cl:list (_make-vector_ :initContent (cl:list "meth" (cl:list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST GEN_FUN_METH_BODY_BLOCK)) OPTIONAL MULT))) OPTIONAL MULT) BODY_BLOCK)) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "generic-labels") (_make-vector_ :initContent (cl:list (cl:list 0 OPTIONAL MULT (_make-vector_ :initContent (cl:list 0 1 (cl:list 2 OPTIONAL 0) (cl:list 3 MULT OPTIONAL (_make-vector_ :initContent (cl:list ":method" 0 1 2)))))))) 1))) "gfun" (cl:list (_make-vector_ :initContent (cl:list LAMBDA_LIST (cl:list (_make-vector_ :initContent (cl:list "options" CLASS_OPTIONS)) OPTIONAL) (cl:list (_make-vector_ :initContent (cl:list "meth" (cl:list METH_QUALIF OPTIONAL) SPEC_LAMBDA_LIST BODY_BLOCK)) OPTIONAL MULT))) (_make-vector_ :initContent (cl:list (_+_ CL_PACK "generic-function") 0 (cl:list 1 OPTIONAL 0) (cl:list 2 MULT OPTIONAL (_make-vector_ :initContent (cl:list ":method" 0 1 2))))))))
; SPEC_SYMB is used in string reading to mark elements
(const SPEC_SYMB (_make-vector_))
(extend SPEC_SYMB OPER_SYMB (tKeys TL_BLOCK) AUX_SPEC_SYMB TL_DIRECT_SPEC_SYMB)
; tl-syntax-error
(cl:define-condition tl-syntax-error (simple-error) ((message :initarg :message)))
; function for use inside of this package only
(cl:defun signalSyntaxError (errorMessage) (error 'tl-syntax-error :message errorMessage :format-control errorMessage))
