;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
;; Generic container funcs
(cl:defgeneric iter (container &optional step))
(cl:defgeneric len (container))
(cl:defgeneric _getitem_ (container indexObject))
(cl:defgeneric (cl:setf _getitem_) (newVal container indexObject))
(cl:defgeneric index (container elem))
(cl:defgeneric tl-count (container elem))
(cl:defgeneric insert (container indexObject elem))
(cl:defgeneric tl-pop (container &optional indexObject))
(cl:defgeneric tl-remove (container elem))
(cl:defgeneric tl-append (seq &rest elems))
(cl:defgeneric extend (seq &rest elems))
;; --------------------------------------------------------
;; Additional funcs
(cl:defun _make-slice_ (start end step) (new _slice_ :start start :end end :step step))
(cl:defun _make-hash-table_ (&rest keyValPairs) "This should make new hash-table and populate it with given
     key->value pairs" (cl:do ((i 0 (_+_ i 2)) (tab (make-hash-table :test #'equal))) ((_>=_ i (len keyValPairs)) tab) (cl:setf (_getitem_ tab (_getitem_ keyValPairs i)) (_getitem_ keyValPairs (_+_ i 1)))))
(cl:defun _make-vector_ (&key ((:initContent initSeq) cl:nil initSeqPresent) ((:elemType elemType) cl:t) ((:initLen initDim) cl:nil initDimPresent)) (cl:cond (initSeqPresent (make-array (list (len initSeq)) :element-type elemType :initial-contents (coerce initSeq 'list) :adjustable cl:t :fill-pointer cl:t)) (cl:t (make-array (list (cl:cond (initDimPresent initDim) (cl:t 0))) :element-type elemType :adjustable cl:t :fill-pointer cl:t))))
(cl:defun _get-integer-slice-args_ (seqLen sl) "'start', 'end' and 'step' are returned, normalized according to provided
     _slice_ and sequence length" (cl:values (cl:cond ((cl:slot-value sl 'start) (cl:cond ((_<_ (cl:slot-value sl 'start) 0) 0) (cl:t (cl:slot-value sl 'start)))) (cl:t 0)) (cl:cond ((cl:slot-value sl 'end) (cl:cond ((_>_ (cl:slot-value sl 'end) seqLen) seqLen) (cl:t (cl:slot-value sl 'end)))) (cl:t seqLen)) (cl:slot-value sl 'step)))
(cl:defun _positive-index_ (seqLen ind seq errMess) "Normalizes index to be positive, according to a given sequence length" (cl:cond ((_and_ (_>=_ ind 0) (_<_ ind seqLen)) ind) ((_and_ (_<_ ind 0) (_<=_ (_unary-_ ind) seqLen)) (_+_ seqLen ind)) (cl:t ;;----------NOT FINISHED----------------
 ;; should it raise a continuable error? -- what restarts to use then?
 (error 'index-error :container seq :index ind :format-control errMess))))
(cl:defun err-on-null (lst errMess) "Signals an error when given an empty list" (cl:cond ((null lst) (error 'null-list-error :format-control errMess))))
;; --------------------------------------------------------
;; Sequence's class methods
(cl:defmethod iter ((seq sequence) &optional (step 1)) (new _sequence-iterator_ :sequence seq :step step))
(cl:defmethod len ((seq sequence)) (length seq))
(cl:defmethod _getitem_ ((seq sequence) (intIndex integer)) (cl:let (index) (cl:setf index (_positive-index_ (len seq) intIndex seq "Method _getitem_ is called on sequence with out-of-range integer index")) (elt seq index)))
(cl:defmethod (cl:setf _getitem_) (newVal (seq sequence) (intIndex integer)) (cl:let (index) (cl:setf index (_positive-index_ (len seq) intIndex seq "Method setter _getitem_ is called on sequence with out-of-range integer index")) (cl:setf (elt seq index) newVal)))
(cl:defmethod index ((seq sequence) (elem cl:t)) "Returns an index of the first item==elem in sequence.
     If it fails, nil is returned" (position elem seq :test '_==_))
(cl:defmethod tl-count ((seq sequence) (elem cl:t)) "Returns the number of times elem appears in the sequence" (cl:count elem seq :test '_==_))
;; --------------------------------------------------------
;; List's class methods
(cl:defmethod iter ((lst list) &optional (step 1)) (new _list-iterator_ :list (cons cl:nil lst) :step step))
(cl:defmethod len ((lst list)) (list-length lst))
(cl:defmethod _getitem_ ((lst list) (sl _slice_)) (cl:let (start end step) (cl:setf (cl:values start end step) (_get-integer-slice-args_ (len lst) sl)) (cl:cond (step (cl:do ((i start (_+_ i step)) (newSeq cl:nil) endCons (lstCons (nthcdr start lst) (nthcdr step lstCons))) ((_>=_ i end) newSeq) (cl:cond ((null newSeq) (cl:setf newSeq (cons (car lstCons) cl:nil)) (cl:setf endCons newSeq)) (cl:t (cl:setf (cdr endCons) (cons (car lstCons) cl:nil)) (cl:setf endCons (cdr endCons)))))) (cl:t (cl:cond ((_<_ start end) (subseq lst start end)) (cl:t cl:nil))))))
(cl:defmethod tl-append ((lst list) &rest elems) (extend lst elems))
(cl:defmethod extend ((lst list) &rest seqs) (err-on-null lst "Method extend should not be called on null list") (cl:let (endCons) (cl:setf endCons (last lst)) ;; will err if lst is circular
 (endp (cdr endCons)) ;; will err if lst was a dotted list
 (cl:setf (cdr endCons) (cdr (tl-for (seq seqs (extLst (cons cl:nil cl:nil)) (lastCons extLst (last lastCons))) (extLst) (cl:setf (cdr lastCons) (coerce seq 'list))))) cl:nil))
(cl:defmethod insert ((lst list) (intIndex integer) (elem cl:t)) (err-on-null lst "Method insert should not be called on null list") (cl:let (index) (cl:setf index (_positive-index_ (_+_ (len lst) 1) intIndex lst "Method insert is called on list with out-of-range integer index")) (cl:cond ((_>_ index 0) (cl:setf (cdr (nthcdr (_-_ index 1) lst)) (cons elem (nthcdr index lst)))) (cl:t (cl:let (newCons) (cl:setf newCons (cons (car lst) (cdr lst))) (cl:setf (car lst) elem) (cl:setf (cdr lst) newCons)))) cl:nil))
(cl:defmethod tl-pop ((lst list) &optional (intIndex cl:nil indexPresent)) "Remove the item at the given position in the list, and return it.
     When index is not given, the last element is poped.
     If list initially has only one element, it will be '~(nil) after poping" (err-on-null lst "Method pop should not be called on null list") (cl:let (lstLen) (cl:setf lstLen (len lst)) (cl:let (popedElem) (cl:setf popedElem cl:nil) (cl:cond (indexPresent (cl:let (index) (cl:setf index (_positive-index_ lstLen intIndex lst "Method pop is called on list with out-of-range integer index")) (cl:cond ((_>_ lstLen 1) (cl:cond ((_==_ index 0) (cl:setf popedElem (car lst)) (cl:setf (car lst) (car (cdr lst))) (cl:setf (cdr lst) (cdr (cdr lst)))) (cl:t (cl:let (cutCons) (cl:setf cutCons (nthcdr (_-_ index 1) lst)) (cl:setf popedElem (car (cdr cutCons))) (cl:setf (cdr cutCons) (cdr (cdr cutCons))))))) (cl:t (cl:setf popedElem (car lst)) ;; index==0 anyway
 (cl:setf (car lst) cl:nil))))) (cl:t (cl:cond ((_>_ lstLen 1) (cl:let (newEndCon) (cl:setf newEndCon (nthcdr (_-_ lstLen 2) lst)) (cl:setf popedElem (car (cdr newEndCon))) (cl:setf (cdr newEndCon) cl:nil))) (cl:t (cl:setf popedElem (car lst)) (cl:setf (car lst) cl:nil))))) popedElem)))
(cl:defmethod tl-remove ((lst list) (elem cl:t)) "Should remove the first item, s.t. item==elem.
     If succesful, returns index of a removed item,
     otherwise returns nil" (cl:let (index) (cl:setf index (index lst elem)) (cl:cond (index (tl-pop lst index))) index))
;; --------------------------------------------------------
;; Hash-table's class methods
(cl:defmethod len ((tab hash-table)) (hash-table-count tab))
(cl:defmethod _getitem_ ((hashTab hash-table) (key cl:t)) (gethash key hashTab))
(cl:defmethod (cl:setf _getitem_) (newVal (hashTab hash-table) (key cl:t)) (cl:setf (gethash key hashTab) newVal))
(cl:defmethod tl-pop ((hashTab hash-table) &optional (key cl:nil keyPresent)) (cl:cond (keyPresent (cl:let (popedElem) (cl:setf popedElem (_getitem_ hashTab key)) (cl:values popedElem (remhash key hashTab)))) (cl:t (cl:values cl:nil cl:nil))))
(cl:defmethod has_key ((hashTab hash-table) (key cl:t)) (nth-value 1 (gethash key hashTab)))
(cl:defmethod update ((tab hash-table) (upTab hash-table)) (maphash #'(cl:lambda (key value) (cl:setf (_getitem_ tab key) value)) upTab))
(cl:defmethod tKeys ((tab hash-table)) (cl:let (keys) (cl:setf keys (_make-vector_)) (maphash #'(cl:lambda (key value) (declare (ignore value)) (_<<_ keys key)) tab) keys))
(cl:defmethod tValues ((tab hash-table)) (cl:let (values) (cl:setf values (_make-vector_)) (maphash #'(cl:lambda (key value) (declare (ignore key)) (_<<_ values value)) tab) values))
(cl:defmethod tItems ((tab hash-table)) (cl:let (items) (cl:setf items (_make-vector_)) (maphash #'(cl:lambda (key value) (insert items (_unary-_ 1) (cl:list key value))) tab) items))
(cl:defmethod iter ((tab hash-table) &optional (step 1)) (declare (ignore step)) (iter (tItems tab)))
(cl:defmethod _copy_ ((tab hash-table)) (cl:let (newTab) (cl:setf newTab (_make-hash-table_)) (maphash #'(cl:lambda (key value) (cl:setf (_getitem_ newTab key) value)) tab) newTab))
;; --------------------------------------------------------
;; Array's class methods
(cl:defmethod _getitem_ ((arr array) (coord list)) (apply #'aref arr coord))
(cl:defmethod (cl:setf _getitem_) (newVal (arr array) (coord list)) (cl:setf (apply #'aref arr coord) newVal))
;; --------------------------------------------------------
;; Vector's class methods
(cl:defmethod _getitem_ ((vec vector) (sl _slice_)) (cl:let (start end step) (cl:setf (cl:values start end step) (_get-integer-slice-args_ (len vec) sl)) (cl:cond ((_<_ start end) (cl:cond (step (cl:do ((i start (_+_ i step)) (k 0 (_+_ k 1)) (tempVec (_make-vector_ :initLen (_+_ (_%_ (_-_ (_-_ end 1) start) step) 1)))) ((_>=_ i end) tempVec) (cl:setf (_getitem_ tempVec k) (_getitem_ vec i)))) (cl:t (subseq vec start end)))) (cl:t (subseq vec 0 0)))))
(cl:defmethod tl-append ((vec vector) &rest elems) (extend vec elems))
(cl:defmethod extend ((vec vector) &rest seqs) (tl-for (seq seqs) (cl:nil) (tl-for (elem seq) (cl:nil) (vector-push-extend elem vec))))
(cl:defmethod insert ((vec vector) (intIndex integer) (elem cl:t)) (cl:let (vecLen) (cl:setf vecLen (len vec)) (cl:let (index) (cl:setf index (_positive-index_ (_+_ vecLen 1) intIndex vec "Method insert is called on vector with out-of-range integer index")) (cl:cond ((_==_ index vecLen) (vector-push-extend elem vec)) (cl:t (vector-push-extend cl:nil vec) (cl:do ((i (_-_ vecLen 1) (_-_ i 1))) ((_<_ i index)) (cl:setf (_getitem_ vec (_+_ i 1)) (_getitem_ vec i))) (cl:setf (_getitem_ vec index) elem))) cl:nil)))
(cl:defmethod tl-pop ((vec vector) &optional (intIndex cl:nil indexPresent)) (cl:let (popedElem) (cl:setf popedElem cl:nil) (cl:cond (indexPresent (cl:let (vecLen) (cl:setf vecLen (len vec)) (cl:let (index) (cl:setf index (_positive-index_ vecLen intIndex vec "Method pop is called on vector with out-of-range integer index")) (cl:setf popedElem (_getitem_ vec index)) (cl:do ((i index (_+_ i 1))) ((_>=_ i (_-_ vecLen 1))) (cl:setf (_getitem_ vec i) (_getitem_ vec (_+_ i 1))))))) (cl:t (cl:setf popedElem (_getitem_ vec (_unary-_ 1))))) (cl:setf (_getitem_ vec (_unary-_ 1)) cl:nil) ; do not leave elements above fill-pointer
 (vector-pop vec) popedElem))
(cl:defmethod tl-remove ((vec vector) (elem cl:t)) (cl:let (index) (cl:setf index (index vec elem)) (cl:cond (index (tl-pop vec index))) index))
;; --------------------------------------------------------
;; iterator method
(cl:defmethod iter ((it _iterator_) &optional (step cl:nil stepPresent)) (cl:cond (stepPresent (cl:setf (cl:slot-value it 'step) step))) it)
;; --------------------------------------------------------
;; List-iterator methods
(cl:defmethod next ((iter _list-iterator_) &optional (step cl:nil stepPresent)) "Returns two values: 1) 'next' element, which is reached by a step,
     and 2) boolean value of a success of this operation" (cl:let (currStep) (cl:setf currStep (cl:cond (stepPresent step) (cl:t (cl:slot-value iter 'step)))) (cl:cond ((_>_ currStep 0) (cl:cond ((_not_ (cl:slot-value iter 'iterStarted)) (cl:setf (cl:slot-value iter 'iterStarted) cl:t))) (cl:setf (cl:slot-value iter 'lastCons) (nthcdr currStep (cl:slot-value iter 'lastCons))) (cl:values (car (cl:slot-value iter 'lastCons)) (_not_ (null (cl:slot-value iter 'lastCons))))) ((_==_ currStep 0) (cl:cond ((cl:slot-value iter 'iterStarted) (cl:values (car (cl:slot-value iter 'lastCons)) (_not_ (endp (cl:slot-value iter 'lastCons))))) (cl:t (cl:values cl:nil cl:nil)))) (cl:t (cl:values cl:nil cl:nil)))))
;; --------------------------------------------------------
;; Sequence-iterator methods
(cl:defmethod next ((iter _sequence-iterator_) &optional (step cl:nil stepPresent)) "Returns two values: 1) 'next' element, which is reached by a step,
     and 2) boolean value of a success of this operation" (cl:let (nextIndex) (cl:setf nextIndex (_+_ (cl:slot-value iter 'lastIndex) (cl:cond (stepPresent step) (cl:t (cl:slot-value iter 'step))))) (cl:cond ((_and_ (_>=_ nextIndex 0) (_<_ nextIndex (len (cl:slot-value iter 'seq)))) (cl:cond ((_not_ (cl:slot-value iter 'iterStarted)) (cl:setf (cl:slot-value iter 'iterStarted) cl:t))) (cl:setf (cl:slot-value iter 'lastIndex) nextIndex) (cl:values (_getitem_ (cl:slot-value iter 'seq) nextIndex) cl:t)) (cl:t (cl:values cl:nil cl:nil)))))
;; --------------------------------------------------------
