;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:defun write-tlisp-file (clispPath tlHomePath tlispPath) (cl:let (expr_re) (cl:setf expr_re (regexp:regexp-compile "(tlPath (namestring (ext:cd)))")) (with-open-file (twinlispFile "twinlisp.lisp" :direction :input) (with-open-file (tlisp tlispPath :direction :output) (write-line clispPath tlisp) (cl:let (line match) (cl:setf (cl:values line match) (cl:do ((line (read-line twinlispFile cl:nil cl:nil) (read-line twinlispFile cl:nil cl:nil)) match) (cl:nil) (cl:setf match (regexp:regexp-exec expr_re line)) (cl:cond (match (cl:return-from cl:nil (cl:values line match)))) (write-line line tlisp))) (write-string line tlisp :start 0 :end (cl:slot-value match 'regexp::start)) (write-string (concatenate 'string "(tlPath \"" tlHomePath "\")") tlisp) (write-line line tlisp :start (cl:slot-value match 'regexp::end)) (cl:do ((line (read-line twinlispFile cl:nil cl:nil) (read-line twinlispFile cl:nil cl:nil))) ((not line)) (write-line line tlisp)))))))
(write-line "Installing tlisp (TwinLisp on top of clisp)")
(write-string "Give a directory, where tlisp's libraries should be placed (you should have writting permission)
Default is /usr/lib/: ")
(cl:setf tlHomePath (read-line))
(cl:cond ((equal (length tlHomePath) 0) (cl:setf tlHomePath "/usr/lib/twlisp/")) (cl:t (cl:setf tlHomePath (concatenate 'string tlHomePath "/twlisp/"))))
(write-string "Give a directory, where tlisp's executable should be placed  (you should have writting permission)
Default is /usr/bin/: ")
(cl:setf tlispPath (read-line))
(cl:cond ((equal (length tlispPath) 0) (cl:setf tlispPath "/usr/bin/tlisp")) (cl:t (cl:setf tlispPath (concatenate 'string tlispPath "/tlisp"))))
(write-string "Give a path to a clisp executable (followed by arguments if need).
Default is /usr/bin/clisp: ")
(cl:setf clispPath (read-line))
(cl:cond ((equal (length clispPath) 0) (cl:setf clispPath "#!/usr/bin/clisp")) (cl:t (cl:setf clispPath (concatenate 'string "#!" clispPath))))
;  -------- COPY APPROPRIATE STUFF TO LIB LOCATION AND COMPILE IT ----------
(shell (concatenate 'string "mkdir " tlHomePath "; cp -r * " tlHomePath "; cd " tlHomePath "; echo \"Compiling core files ...\"" "; clisp compile-core.lisp" "; echo \"Setting up executable file ...\""))
(write-tlisp-file clispPath tlHomePath tlispPath)
(write-line "Compiling dist-packages ...")
(shell (concatenate 'string "clisp " tlispPath " compile-dist-packs.twl" "; echo \"Done.\""))
