;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defclass TestTranslFormWritting (unittest:testcase) ((unittest:tName :initform "TestTranslFormWritting.twl") (unittest:tFuns :initform '(test-formToText-1 test-formToText-2 test-translate-streams-1 test-translate-streams-2 test-translate-streams-3))))
(cl:defmethod test-formToText-1 ((ts TestTranslFormWritting)) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_*_") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "d"))))))))))) (unittest:assertEqual ts (formToText form) "(cl:setf a (_+_ x (_*_ y d)))")))
(cl:defmethod test-formToText-2 ((ts TestTranslFormWritting)) (cl:let (form) (cl:setf form (cl:list SHORTCUT_TYPE "'" (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_*_") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "d")))))))))))) (unittest:assertEqual ts (formToText form) "'(cl:setf a (_+_ x (_*_ y d)))")))
(cl:defmethod test-translate-streams-1 ((ts TestTranslFormWritting)) (cl:let (source) (cl:setf source (make-string-input-stream "let(x,y,d) {
                                            x=s+v**j**f-k
                                            y=d=e-r}")) (cl:let (dest) (cl:setf dest (make-string-output-stream)) (translate-streams source dest) (unittest:assertEqual ts (get-output-stream-string dest) "(cl:let (x y d) (cl:setf x (_-_ (_+_ s (_**_ v (_**_ j f))) k)) (cl:setf y (cl:setf d (_-_ e r))))
"))))
(cl:defmethod test-translate-streams-2 ((ts TestTranslFormWritting)) (cl:let (source) (cl:setf source (make-string-input-stream "s+v**j**f-k
                                        e-r")) (cl:let (dest) (cl:setf dest (make-string-output-stream)) (translate-streams source dest cl:t) (unittest:assertEqual ts (get-output-stream-string dest) "; source line # 1
(_-_ (_+_ s (_**_ v (_**_ j f))) k)
; source line # 2
(_-_ e r)
"))))
(cl:defmethod test-translate-streams-3 ((ts TestTranslFormWritting)) (cl:let (source) (cl:setf source (make-string-input-stream "`($s + v**j**f - $k)
                                        '(e-r)")) (cl:let (dest) (cl:setf dest (make-string-output-stream)) (translate-streams source dest) (unittest:assertEqual ts (get-output-stream-string dest) "`(_-_ (_+_ ,s (_**_ v (_**_ j f))) ,k)
'(_-_ e r)
"))))
