;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:defclass TestOtherMacs (unittest:testcase) ((unittest:tName :initform "TestOtherMacs.twl") (unittest:tFuns :initform '(test-new test-tl-case test-tl-for test-tl-times))))
(cl:defclass foo () (a b))
(cl:defstruct (soo) a b)
(cl:define-condition boo () (c d))
(cl:defmethod test-new ((ts TestOtherMacs)) (unittest:assertFalse ts (typep (new foo) 'condition) :textOnFail "If foo is not subtype of condition, then it is treated as class") (unittest:assertTrue ts (typep (new boo) 'condition) :textOnFail "If boo is subtype of condition, then it is treated as condition") (unittest:assertCondition ts error (new hoo) :textOnFail "It is not apparent here, but error will talk about missing class") (cl:let (a) (cl:setf a (new soo :a "a" :b 23)) (unittest:assertEqual ts (cl:slot-value a 'a) "a") (unittest:assertEqual ts (cl:slot-value a 'b) 23)))
(cl:defmethod test-tl-case ((ts TestOtherMacs)) (cl:let (a) (cl:setf a (cl:list 1 2 3)) (unittest:assertTrue ts (tl-case (tl-pop a) cl:nil ((2) cl:nil) (((_+_ 1 1)) cl:nil) (((_-_ 3 1)) cl:nil) ((3) cl:t))) (cl:setf a (cl:list 1 2 3)) (unittest:assertTrue ts (tl-case (tl-pop a) (cl:t) ((6) cl:nil) (((_*_ 6 3)) cl:nil) (((_+_ 8 2)) cl:nil))) (unittest:assertTrue ts (tl-case (cl:list 4 5) (cl:nil) ((6) cl:nil) (((cl:list)) cl:nil) (((cl:list 4 5)) cl:t))) (unittest:assertTrue ts (tl-case (cl:list 4 5) (cl:nil) ((6) cl:nil) (((cl:list) (cl:list 4 5)) cl:t)))))
(cl:defmethod test-tl-for ((ts TestOtherMacs)) (cl:let (a) (cl:setf a (cl:list 1 2 3 4 5)) (cl:let (c) (cl:setf c (_make-vector_)) (tl-for (elem a) (cl:nil) (tl-append c elem)) (unittest:assertEqual ts c (_make-vector_ :initContent (cl:list 1 2 3 4 5))) (cl:setf c (_make-vector_)) (cl:let (b) (cl:setf b (_make-vector_ :initContent (cl:list 6 7 8 9 0))) (tl-for (elem b) (cl:nil) (tl-append c elem)) (unittest:assertEqual ts c b) (unittest:assertEqual ts (tl-for (elem b (i 1 (_+_ i 1))) ((_-_ i 1))) (len b))))))
(cl:defmethod test-tl-times ((ts TestOtherMacs)) (cl:let (a) (cl:setf a (tl-times (i 9 (vec (_make-vector_))) (vec) (tl-append vec i))) (unittest:assertEqual ts a (_make-vector_ :initContent (cl:list 0 1 2 3 4 5 6 7 8)))))
