;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defun read-tl-code (inStream firstChar arg) (declare (ignore arg)) (cl:cond ((_!=_ firstChar #\t) (cl:return-from read-tl-code (values)))) (cl:cond ((_!=_ (read-char inStream) #\{) (cl:return-from read-tl-code (values)))) (cl:let (charBuff) (cl:setf charBuff (make-string-output-stream)) (cl:let (innerSyntChangeLevels) (cl:setf innerSyntChangeLevels 1) (cl:handler-case (cl:progn (cl:do ((char (read-char inStream) (read-char inStream))) (cl:nil) (cl:cond ((_==_ char #\#) (cl:let (char) (cl:setf char (read-char inStream)) (cl:cond ((_==_ char #\t) (cl:setf char (read-char inStream)) (cl:cond ((_==_ char #\{) (_+=_ innerSyntChangeLevels 1) (_<<_ (_<<_ (_<<_ charBuff #\#) #\t) #\{)) ((_==_ char #\}) (_-=_ innerSyntChangeLevels 1) (cl:cond ((_==_ innerSyntChangeLevels 0) (cl:return-from cl:nil ())) (cl:t (_<<_ (_<<_ (_<<_ charBuff #\#) #\t) #\})))) (cl:t (_<<_ (_<<_ (_<<_ charBuff #\#) #\t) char)))) (cl:t (_<<_ (_<<_ charBuff #\#) char))))) (cl:t (_<<_ charBuff char))))) (end-of-file () (error (new end-of-file :stream inStream :format-string (_+_ "~S: input stream ~S ends within tl code block" #\Newline) :format-arguments (cl:list 'read-tl-code inStream))))) (cl:let (twInStream) (cl:setf twInStream (make-string-input-stream (get-output-stream-string charBuff))) (cl:let (lispCodeBuff) (cl:setf lispCodeBuff (make-string-output-stream)) (translate-streams twInStream lispCodeBuff) (cl:let (lispInStream) (cl:setf lispInStream (make-string-input-stream (get-output-stream-string lispCodeBuff))) (cl:let (forms) (cl:setf forms (_make-vector_)) (cl:handler-case (cl:progn (cl:do () (cl:nil) (tl-append forms (read lispInStream)))) (end-of-file ())) ; this is just a point of a control transfer
 (cons 'cl:progn (coerce forms 'list)))))))))
(set-dispatch-macro-character #\# #\t #'read-tl-code)
