;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defstruct (LevelInfo) blockName implScope explScopeWarn isTopLevel (_lowerLevelFuncName cl:nil) (_lowerLevelGenFuncName cl:nil) _nickToRealNames (currImplVar (_make-vector_)) (newVars (_make-vector_)) (_lowerLevelImplVar (_make-vector_)))
(cl:defun makeLevelInfo (&key ((:blockName blockName) cl:nil) ((:implScope implScope) cl:nil) ((:isTopLevel isTopLevel) cl:t) ((:explScopeWarn explScopeWarn) cl:nil) ((:nickToRealNames nickToRealNames) cl:nil)) (make-LevelInfo :blockName blockName :implScope implScope :explScopeWarn explScopeWarn :isTopLevel isTopLevel :_nickToRealNames (cl:cond (nickToRealNames (_copy_ nickToRealNames)) (cl:t (_copy_ TWL_METH_NICKNAMES)))))
(cl:defmethod lowerFuncLevel ((li LevelInfo)) (cl:cond ((_not_ (cl:slot-value li '_lowerLevelFuncName)) (error "Programming error: function name should be set before calling LevelInfo.lowerFuncLevel"))) (cl:let (funcName) (cl:setf funcName (cl:slot-value li '_lowerLevelFuncName)) (cl:setf (cl:slot-value li '_lowerLevelFuncName) cl:nil) (cl:let (lowerLevel) (cl:setf lowerLevel (lowerMacLevel li)) (cl:setf (cl:slot-value lowerLevel 'blockName) funcName) (cl:setf (cl:slot-value lowerLevel 'implScope) (cl:slot-value li 'implScope)) lowerLevel)))
(cl:defmethod lowerGenFuncMethLevel ((li LevelInfo)) (cl:cond ((_not_ (cl:slot-value li '_lowerLevelGenFuncName)) (error "Programming error: generic function name should be set before calling LevelInfo.lowerGenFuncMethLevel"))) (cl:let (gfuncName) (cl:setf gfuncName (cl:slot-value li '_lowerLevelGenFuncName)) (cl:let (lowerLevel) (cl:setf lowerLevel (lowerMacLevel li)) (cl:setf (cl:slot-value lowerLevel 'blockName) gfuncName) (cl:setf (cl:slot-value lowerLevel 'implScope) (cl:slot-value li 'implScope)) lowerLevel)))
(cl:defmethod lowerLambdaLevel ((li LevelInfo)) (cl:let (lowerLevel) (cl:setf lowerLevel (lowerMacLevel li)) (cl:setf (cl:slot-value lowerLevel 'implScope) (cl:slot-value li 'implScope)) lowerLevel))
(cl:defmethod lowerRegLevel ((li LevelInfo)) (cl:let (lowerLevel) (cl:setf lowerLevel (makeLevelInfo :blockName (cl:slot-value li 'blockName) :implScope (cl:slot-value li 'implScope) :isTopLevel cl:nil :explScopeWarn (cl:slot-value li 'explScopeWarn) :nickToRealNames (cl:slot-value li '_nickToRealNames))) (cl:setf (cl:slot-value lowerLevel 'currImplVar) (_+_ (cl:slot-value li '_lowerLevelImplVar) (cl:slot-value li 'currImplVar))) (cl:setf (cl:slot-value li '_lowerLevelImplVar) (_make-vector_)) lowerLevel))
(cl:defmethod lowerMacLevel ((li LevelInfo)) (cl:let (lowerLevel) (cl:setf lowerLevel (makeLevelInfo :blockName (cl:slot-value li 'blockName) :implScope cl:nil :isTopLevel cl:nil :explScopeWarn (cl:slot-value li 'explScopeWarn) :nickToRealNames (cl:slot-value li '_nickToRealNames))) (cl:setf (cl:slot-value lowerLevel 'currImplVar) (cl:slot-value li '_lowerLevelImplVar)) (cl:setf (cl:slot-value li '_lowerLevelImplVar) (_make-vector_)) lowerLevel))
(cl:defmethod addSymbSynonym ((li LevelInfo) nickName realName) (cl:setf (_getitem_ (cl:slot-value li '_nickToRealNames) nickName) realName))
(cl:defmethod getRealSymbol ((li LevelInfo) symb) (cl:cond ((has_key (cl:slot-value li '_nickToRealNames) symb) (_getitem_ (cl:slot-value li '_nickToRealNames) symb)) (cl:t symb)))
(cl:defmethod appImplVarForLowerLevel ((li LevelInfo) symbList) (extend (cl:slot-value li '_lowerLevelImplVar) symbList))
(cl:defun _formSymbAsImplVarForLowerLevel (symbList form) (cl:let (tf) (cl:setf tf form) (cl:cond ((_==_ (_getitem_ tf 0) SHORTCUT_TYPE) (cl:setf tf form) (cl:do () ((_!=_ (_getitem_ tf 0) SHORTCUT_TYPE)) (cl:setf tf (_getitem_ tf 2))))) (cl:cond ((_==_ (_getitem_ tf 0) ATOM_TYPE) (tl-append symbList (_getitem_ tf 1))))))
(cl:defun _formSymbAsImplVar (level form) (cl:let (tf) (cl:setf tf form) (cl:cond ((_==_ (_getitem_ tf 0) SHORTCUT_TYPE) (cl:setf tf form) (cl:do () ((_!=_ (_getitem_ tf 0) SHORTCUT_TYPE)) (cl:setf tf (_getitem_ tf 2))))) (tl-case (_getitem_ tf 0) cl:nil ((FORM_TYPE) (cl:cond ((_==_ (_getitem_ (_getitem_ tf 1) 0) (cl:list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS "@") 0))) (tl-for (innerForm (_getitem_ (_getitem_ tf 1) (_make-slice_ 1 cl:nil cl:nil))) (cl:nil) (_formSymbAsImplVar level innerForm))))) ((ATOM_TYPE) (cl:cond ((cl:slot-value level 'implScope) (cl:cond ((_and_ (_==_ (tl-count (cl:slot-value level 'currImplVar) (_getitem_ tf 1)) 0) (_==_ (tl-count (_getitem_ tf 1) #\:) 0)) (tl-append (cl:slot-value level 'currImplVar) (_getitem_ tf 1)) (tl-append (cl:slot-value level 'newVars) (_getitem_ tf 1))))) (cl:t (cl:cond ((_and_ (cl:slot-value level 'explScopeWarn) (_==_ (tl-count (cl:slot-value level 'currImplVar) (_getitem_ tf 1)) 0)) (signalSyntaxError (_%_ "Assignment to unknown variable '~A'. You have to use 'let'-type constructs, or declare variable global." (_getitem_ tf 1)))))))))))
(cl:defun _macLambdaListForm (elems level) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_))) (cl:let (symbList) (cl:setf symbList (_make-vector_)) (cl:do ((ind 0) (option "no-option")) ((_>=_ ind (len elems))) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM ",")) ind elems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ()))) (cl:cond ((_and_ (_==_ (cl:slot-value (_getitem_ elems ind) 'type) SYMB_ELEM) (_!=_ (tl-count MAC_LAMBDA_LIST_OPTIONS (cl:slot-value (_getitem_ elems ind) 'value)) 0)) (cl:cond ((_and_ (_!=_ (cl:slot-value (_getitem_ elems ind) 'value) "&whole") (_!=_ (cl:slot-value (_getitem_ elems ind) 'value) "&environment")) (cl:setf option (cl:slot-value (_getitem_ elems ind) 'value)))) (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE (cl:slot-value (_getitem_ elems ind) 'value))) (_+=_ ind 1)) ((_==_ (cl:slot-value (_getitem_ elems ind) 'type) ".") (cl:let (brackInd) (cl:setf brackInd (getRequiredElemInd "(" (_+_ ind 1) elems)) (cl:let (trueVal innerLambdaListForm) (cl:setf (cl:values trueVal innerLambdaListForm ind) (_procSpecificList brackInd elems level MAC_LAMBDA_LIST)) (extend (_getitem_ form 1) innerLambdaListForm)))) ((_==_ (cl:slot-value (_getitem_ elems ind) 'type) "*") (cl:cond ((_or_ (_==_ option "no-option") (_==_ option "&optional")) (cl:setf option "&rest") (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE "&rest"))) ((_!=_ option "&rest") (signalSyntaxError (_%_ "The '&rest' parameter on line ~D, position ~D, cannot follow option '~A'" (cl:list (cl:slot-value (_getitem_ elems ind) 'lineNum) (cl:slot-value (_getitem_ elems ind) 'start) option))))) (cl:let (restForm) (cl:setf (cl:values restForm ind) (getOneForm (_+_ ind 1) elems level cl:nil)) (tl-append (_getitem_ form 1) restForm))) ((_==_ (cl:slot-value (_getitem_ elems ind) 'type) "**") (cl:cond ((_or_ (_==_ option "no-option") (_==_ option "&optional")) (cl:setf option "&rest") (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE "&body"))) ((_!=_ option "&rest") (signalSyntaxError (_%_ "The '&body' parameter on line ~D, position ~D, cannot follow option '~A'" (cl:list (cl:slot-value (_getitem_ elems ind) 'lineNum) (cl:slot-value (_getitem_ elems ind) 'start) option))))) (cl:let (restForm) (cl:setf (cl:values restForm ind) (getOneForm (_+_ ind 1) elems level cl:nil)) (tl-append (_getitem_ form 1) restForm))) (cl:t (cl:let (keyPresent arrowInd) (cl:setf (cl:values keyPresent arrowInd) (getElemIndInOperExpr "->" ind elems)) (cl:let (svarFormEnd svarForm keyForm questInd svarPresent) (cl:setf svarPresent (cl:setf questInd (cl:setf keyForm (cl:setf svarForm (cl:setf svarFormEnd cl:nil))))) (cl:cond (keyPresent (cl:setf keyForm (getOneForm 0 (_getitem_ elems (_make-slice_ ind arrowInd cl:nil)) level cl:nil)) (cl:cond ((_not_ keyForm) (signalSyntaxError (_%_ "Missing a keyword before '->' on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems arrowInd) 'lineNum) (cl:slot-value (_getitem_ elems arrowInd) 'start)))))) (cl:cond ((_or_ (_or_ (_==_ option "no-option") (_==_ option "&optional")) (_==_ option "&rest")) (cl:setf option "&key") (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE "&key"))) ((_!=_ option "&key") (signalSyntaxError (_%_ "The '&key' parameter on line ~D, position ~D, cannot follow option '~A'" (cl:list (cl:slot-value (_getitem_ elems ind) 'lineNum) (cl:slot-value (_getitem_ elems ind) 'start) option))))) (cl:setf (cl:values svarPresent questInd) (getElemIndInOperExpr "=?" (_+_ arrowInd 1) elems))) (cl:t (cl:setf (cl:values svarPresent questInd) (getElemIndInOperExpr "=?" ind elems)))) (cl:cond (svarPresent (cl:setf (cl:values svarForm svarFormEnd) (getOneForm (_+_ questInd 1) elems level cl:nil)) (cl:cond ((_not_ svarForm) (signalSyntaxError (_%_ "Missing a variable name after '=?' on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems questInd) 'lineNum) (cl:slot-value (_getitem_ elems questInd) 'start)))))) (cl:cond ((_==_ option "no-option") (cl:setf option "&optional") (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE "&optional"))) ((_==_ option "&rest") (cl:setf option "&key") (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE "&key"))) ((_and_ (_!=_ option "&optional") (_!=_ option "&key")) (signalSyntaxError (_%_ "'=?' on line ~D, position ~D, has no sense after option '~A'" (cl:list (cl:slot-value (_getitem_ elems questInd) 'lineNum) (cl:slot-value (_getitem_ elems questInd) 'start) option))))))) (cl:cond ((_and_ keyPresent svarPresent) (cl:let (varForms) (cl:setf varForms (getFormsSeparByElem "=" 0 (_getitem_ elems (_make-slice_ (_+_ arrowInd 1) questInd cl:nil)) level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ varForms 0)) (_formSymbAsImplVarForLowerLevel symbList svarForm) (cl:setf ind svarFormEnd) (cl:case (len varForms) ((1) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list keyForm (_getitem_ varForms 0)))) (cl:list ATOM_TYPE LISP_NIL) svarForm))))) ((2) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list keyForm (_getitem_ varForms 0)))) (_getitem_ varForms 1) svarForm)))))))) ((_and_ (_not_ keyPresent) svarPresent) (cl:let (varForms) (cl:setf varForms (getFormsSeparByElem "=" 0 (_getitem_ elems (_make-slice_ ind questInd cl:nil)) level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ varForms 0)) (_formSymbAsImplVarForLowerLevel symbList svarForm) (cl:setf ind svarFormEnd) (cl:case (len varForms) ((1) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (_getitem_ varForms 0) (cl:list ATOM_TYPE LISP_NIL) svarForm))))) ((2) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (_getitem_ varForms 0) (_getitem_ varForms 1) svarForm)))))))) ((_and_ keyPresent (_not_ svarPresent)) (cl:let (varForms) (cl:setf (cl:values varForms ind) (getFormsSeparByElem "=" (_+_ arrowInd 1) elems level)) (cl:case (len varForms) ((1) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list keyForm (_getitem_ varForms 0))))))))) ((2) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list keyForm (_getitem_ varForms 0)))) (_getitem_ varForms 1))))))))) ((_and_ (_not_ keyPresent) (_not_ svarPresent)) (cl:let (varForms) (cl:setf (cl:values varForms ind) (getFormsSeparByElem "=" ind elems level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ varForms 0)) (cl:case (len varForms) ((1) (tl-append (_getitem_ form 1) (_getitem_ varForms 0))) ((2) (tl-case option cl:nil (("no-option") (cl:setf option "&optional") (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE "&optional"))) (("&rest") (cl:setf option "&key") (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE "&key"))) (("&allow-other-keys") (cl:setf option "&aux") (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE "&aux")))) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (_getitem_ varForms 0) (_getitem_ varForms 1)))))))))))))))) (appImplVarForLowerLevel level symbList) form)))
(cl:defun _specLambdaListForm (elems level) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_))) (cl:let (symbList) (cl:setf symbList (_make-vector_)) (cl:do ((ind 0)) ((_>=_ ind (len elems))) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM ",")) ind elems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ()))) (cl:cond ((_or_ (_and_ (_==_ (cl:slot-value (_getitem_ elems ind) 'type) SYMB_ELEM) (_!=_ (tl-count MAC_LAMBDA_LIST_OPTIONS (cl:slot-value (_getitem_ elems ind) 'value)) 0)) (tl-case (cl:slot-value (_getitem_ elems ind) 'type) (cl:nil) (("." "*" "**") cl:t))) ; current and following elements are like those in a lambda-list
 (extend (_getitem_ form 1) (_getitem_ (_macLambdaListForm (_getitem_ elems (_make-slice_ ind cl:nil cl:nil)) level) 1)) (cl:return-from cl:nil ()))) (cl:let (eqSignPresent eqSignInd) (cl:setf (cl:values eqSignPresent eqSignInd) (getElemIndInOperExpr "==" ind elems)) (cl:cond ((cl:cond (eqSignPresent (_not_ (getElemIndInOperExpr "=" 0 (_getitem_ elems (_make-slice_ ind eqSignInd cl:nil))))) (cl:t cl:nil)) (cl:let (varForms) (cl:setf (cl:values varForms ind) (getFormsSeparByElem "==" ind elems level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ varForms 0)) (cl:case (len varForms) ((1) (tl-append (_getitem_ form 1) (_getitem_ varForms 0))) ((2) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (_getitem_ varForms 0) (_getitem_ varForms 1))))))))) (cl:t (cl:cond ((_or_ (_or_ (getElemIndInOperExpr "=" 0 (_getitem_ elems (_make-slice_ ind cl:nil cl:nil))) (getElemIndInOperExpr "->" 0 (_getitem_ elems (_make-slice_ ind cl:nil cl:nil)))) (getElemIndInOperExpr "=?" 0 (_getitem_ elems (_make-slice_ ind cl:nil cl:nil)))) ; current and following elements are like those in a lambda-list
 (extend (_getitem_ form 1) (_getitem_ (_macLambdaListForm (_getitem_ elems (_make-slice_ ind cl:nil cl:nil)) level) 1)) (cl:return-from cl:nil ())) (cl:t (cl:let (varForm) (cl:setf (cl:values varForm ind) (getOneForm ind elems level cl:nil)) (cl:cond (varForm (_formSymbAsImplVarForLowerLevel symbList varForm) (tl-append (_getitem_ form 1) varForm))))))))))) (appImplVarForLowerLevel level symbList) form)))
(cl:defun _letListForm (innerElems level) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_))) (cl:let (symbList) (cl:setf symbList (_make-vector_)) (cl:do ((ind 0)) ((_>=_ ind (len innerElems))) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM ",")) ind innerElems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ()))) (cl:let (forms) (cl:setf (cl:values forms ind) (getFormsSeparByElem "=" ind innerElems level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ forms 0)) (cl:case (len forms) ((2) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (_getitem_ forms 0) (_getitem_ forms 1)))))) ((1) (tl-append (_getitem_ form 1) (_getitem_ forms 0))))))) (appImplVarForLowerLevel level symbList) form)))
(cl:defun _doVarListForm (innerElems level) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_))) (cl:let (symbList) (cl:setf symbList (_make-vector_)) (cl:do ((ind 0)) ((_>=_ ind (len innerElems))) (cl:let (stepForm arrowInd end) (cl:setf (cl:values stepForm arrowInd end) (getFormAfterElem "->" ind innerElems level)) (cl:cond (stepForm (cl:let (forms) (cl:setf forms (getFormsSeparByElem "=" 0 (_getitem_ innerElems (_make-slice_ ind arrowInd cl:nil)) level)) (cl:case (len forms) ((2) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (_getitem_ forms 0) (_getitem_ forms 1) stepForm))))) ((1) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (_getitem_ forms 0) (cl:list ATOM_TYPE LISP_NIL) stepForm)))))))) (cl:t (cl:let (forms) (cl:setf (cl:values forms end) (getFormsSeparByElem "=" ind innerElems level)) (_formSymbAsImplVarForLowerLevel symbList (_getitem_ forms 0)) (cl:case (len forms) ((2) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (_getitem_ forms 0) (_getitem_ forms 1)))))) ((1) (tl-append (_getitem_ form 1) (_getitem_ forms 0))))))) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM ",")) end innerElems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ())))))) (appImplVarForLowerLevel level symbList) form)))
(cl:defun _procName (start elems level onSameLine) (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 SYMB_ELEM start elems onSameLine)) (cl:cond (elemFound (cl:return-from _procName (cl:values cl:t (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE (getRealSymbol level (cl:slot-value (_getitem_ elems ind) 'value))))) (_+_ ind 1))))) (cl:setf (cl:values elemFound ind) (getShortcutInd start elems onSameLine)) (cl:cond (elemFound (cl:do () ((_not_ elemFound)) (cl:setf (cl:values elemFound ind) (getShortcutInd (_+_ ind 1) elems))) (cl:setf ind (getRequiredElemInd SYMB_ELEM ind elems)) (cl:setf (cl:slot-value (_getitem_ elems ind) 'value) (getRealSymbol level (cl:slot-value (_getitem_ elems ind) 'value))) (cl:let (form) (cl:setf form (getOneForm 0 (_getitem_ elems (_make-slice_ start (_+_ ind 1) cl:nil)) level cl:nil)) (cl:return-from _procName (cl:values cl:t (_make-vector_ :initContent (cl:list form)) (_+_ ind 1)))))) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 STR_START_ELEM start elems onSameLine)) (cl:cond (elemFound (cl:let (strAtom end) (cl:setf (cl:values strAtom end) (getStringAtom ind elems)) (cl:return-from _procName (cl:values cl:t (_make-vector_ :initContent (cl:list strAtom)) end))))) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 ":" start elems onSameLine)) (cl:cond (elemFound (cl:setf ind (getRequiredElemInd SYMB_ELEM (_+_ ind 1) elems)) (cl:return-from _procName (cl:values cl:t (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE (_+_ ":" (cl:slot-value (_getitem_ elems ind) 'value))))) (_+_ ind 1))))) (cl:values cl:nil (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE LISP_NIL))) start)))
(cl:defun procName (start elems level addLineNums) (declare (ignore addLineNums)) (_procName start elems level cl:t))
(cl:defun procName2 (start elems level addLineNums) (declare (ignore addLineNums)) (_procName start elems level cl:nil))
(cl:defun procFunName (start elems level addLineNums) (declare (ignore addLineNums)) (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 SPEC_SYMB_ELEM start elems cl:nil)) (cl:let (isSetter) (cl:setf (cl:values isSetter ind) (cl:cond ((_and_ elemFound (_==_ (cl:slot-value (_getitem_ elems ind) 'value) SETTER_SPEC_SYMB)) (cl:values cl:t (_+_ ind 1))) (cl:t (cl:values cl:nil ind)))) (cl:let (succ formList end) (cl:setf (cl:values succ formList end) (_procName ind elems level cl:nil)) (cl:setf (cl:slot-value level '_lowerLevelFuncName) (_getitem_ (_getitem_ formList 0) 1)) (cl:cond (isSetter (cl:values succ (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE SETTER_FUNC) (_getitem_ formList 0)))))) end)) (cl:t (cl:values succ formList end)))))))
(cl:defun procGenFunName (start elems level addLineNums) (declare (ignore addLineNums)) (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 SPEC_SYMB_ELEM start elems cl:nil)) (cl:let (isSetter) (cl:setf (cl:values isSetter ind) (cl:cond ((_and_ elemFound (_==_ (cl:slot-value (_getitem_ elems ind) 'value) SETTER_SPEC_SYMB)) (cl:values cl:t (_+_ ind 1))) (cl:t (cl:values cl:nil ind)))) (cl:let (succ formList end) (cl:setf (cl:values succ formList end) (_procName ind elems level cl:nil)) (cl:setf (cl:slot-value level '_lowerLevelGenFuncName) (_getitem_ (_getitem_ formList 0) 1)) (cl:cond (isSetter (cl:values succ (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE SETTER_FUNC) (_getitem_ formList 0)))))) end)) (cl:t (cl:values succ formList end)))))))
(cl:defun procFunNameFromLevelInfo (start elems level addLineNums) (declare (ignore addLineNums)) (cl:let (funcName) (cl:setf funcName (cl:slot-value level 'blockName)) (cl:cond ((_not_ funcName) (cl:let (errorLineNum) (cl:setf errorLineNum (cl:cond ((_<_ start (len elems)) (cl:slot-value (_getitem_ elems start) 'lineNum)) (cl:t (cl:cond ((_==_ (len elems) 0) (signalSyntaxError "Function name is underfined")) (cl:t (cl:slot-value (_getitem_ elems (_unary-_ 1)) 'lineNum)))))) (signalSyntaxError (_%_ "Function name on line ~D is underfined" errorLineNum)))) (cl:t (cl:values cl:t (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE funcName))) start)))))
(cl:defun procDoTestResultList (start elems level addLineNums) (cl:let (ind) (cl:setf ind (cl:handler-case (cl:progn (getRequiredElemInd "(" start elems cl:nil)) (tl-syntax-error () (cl:return-from procDoTestResultList (cl:values cl:nil (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE LISP_NIL)))))) start))))) (cl:let (innerElems) (cl:setf (cl:values innerElems ind) (getElemsInBrackets ind elems)) (cl:let (forms) (cl:setf forms (getForms innerElems level addLineNums)) (cl:cond ((_==_ (len forms) 0) (cl:setf forms (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE LISP_NIL)))))) (cl:values cl:t (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE forms))) (_+_ ind 1))))))
(cl:defun procOperExpr (start elems level addLineNums) (declare (ignore addLineNums)) (cl:let (form end) (cl:setf (cl:values form end) (getOneForm start elems level cl:nil)) (cl:cond (form (cl:values cl:t (_make-vector_ :initContent (cl:list form)) end)) (cl:t (cl:values cl:nil (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_)))) start)))))
(cl:defun _operExprInBrack (start elems level addLineNums singleExpr) (cl:let (brackInd) (cl:setf brackInd (cl:handler-case (cl:progn (getRequiredElemInd "(" start elems)) (tl-syntax-error () (cl:return-from _operExprInBrack (cl:values cl:nil (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_)))) start))))) (cl:let (innerElems ind) (cl:setf (cl:values innerElems ind) (getElemsInBrackets brackInd elems)) (cl:let (forms) (cl:setf forms (getForms innerElems level addLineNums)) (cl:cond ((_==_ (len forms) 0) (signalSyntaxError (_%_ "Missing form(s) in brackets, starting line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems brackInd) 'lineNum) (cl:slot-value (_getitem_ elems brackInd) 'start))))) ((_and_ singleExpr (_>_ (len forms) 1)) (signalSyntaxError (_%_ "Expect one form in brackets, starting line ~D, position ~D, but got ~D forms" (cl:list (cl:slot-value (_getitem_ elems brackInd) 'lineNum) (cl:slot-value (_getitem_ elems brackInd) 'start) (len forms)))))) (cl:values cl:t forms (_+_ ind 1))))))
(cl:defun procOperExprInBrack (start elems level addLineNums) (_operExprInBrack start elems level addLineNums cl:t))
(cl:defun procMultOperExprInBrack (start elems level addLineNums) (_operExprInBrack start elems level addLineNums cl:nil))
(cl:defun _procSpecificList (start elems level listType) (cl:let (ind) (cl:setf ind (cl:handler-case (cl:progn (getRequiredElemInd "(" start elems cl:nil)) (tl-syntax-error () (cl:return-from _procSpecificList (cl:values cl:nil (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_)))) start))))) (cl:let (innerElems) (cl:setf (cl:values innerElems ind) (getElemsInBrackets ind elems)) (cl:let (form) (cl:setf form (tl-case listType cl:nil ((LAMBDA_LIST MAC_LAMBDA_LIST) (_macLambdaListForm innerElems level)) ((LET_LIST) (_letListForm innerElems level)) ((DO_VAR_LIST) (_doVarListForm innerElems level)) ((SPEC_LAMBDA_LIST) (_specLambdaListForm innerElems level)))) (cl:values cl:t (_make-vector_ :initContent (cl:list form)) (_+_ ind 1))))))
(cl:defun procDoVarList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level DO_VAR_LIST))
(cl:defun procLetList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level LET_LIST))
(cl:defun procLambdaList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level LAMBDA_LIST))
(cl:defun procMacLambdaList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level MAC_LAMBDA_LIST))
(cl:defun procSpecLambdaList (start elems level addLineNums) (declare (ignore addLineNums)) (_procSpecificList start elems level SPEC_LAMBDA_LIST))
(cl:defun _procBlock (start elems level addLineNums) (cl:let (ind) (cl:setf ind (cl:handler-case (cl:progn (getRequiredElemInd "{" start elems cl:nil)) (tl-syntax-error () (cl:return-from _procBlock (cl:values cl:nil (_make-vector_) start))))) (cl:let (innerElems) (cl:setf (cl:values innerElems ind) (getElemsInBrackets ind elems)) (cl:values cl:t (getForms innerElems level addLineNums) (_+_ ind 1)))))
(cl:defun procBodyBlock (start elems level addLineNums) (_procBlock start elems (lowerRegLevel level) addLineNums))
(cl:defun procMacBodyBlock (start elems level addLineNums) (_procBlock start elems (lowerMacLevel level) addLineNums))
(cl:defun procFunBodyBlock (start elems level addLineNums) (_procBlock start elems (lowerFuncLevel level) addLineNums))
(cl:defun procLambdaBodyBlock (start elems level addLineNums) (_procBlock start elems (lowerLambdaLevel level) addLineNums))
(cl:defun procGenFunMethBodyBlock (start elems level addLineNums) (_procBlock start elems (lowerGenFuncMethLevel level) addLineNums))
(cl:defun _letLikeElemsInBraces (start elems) (cl:let (ind) (cl:setf ind (cl:handler-case (cl:progn (getRequiredElemInd "{" start elems cl:nil)) (tl-syntax-error () (cl:return-from _letLikeElemsInBraces (cl:values cl:nil (_make-vector_) start))))) (cl:let (innerElems end) (cl:setf (cl:values innerElems end) (getElemsInBrackets ind elems)) (cl:values cl:t (_getitem_ (_letListForm innerElems (makeLevelInfo)) 1) (_+_ end 1)))))
(cl:defun procClassOptions (start elems level addLineNums) (declare (ignore addLineNums) (ignore level)) (_letLikeElemsInBraces start elems))
(cl:defun procStructOptions (start elems level addLineNums) (declare (ignore addLineNums) (ignore level)) (_letLikeElemsInBraces start elems))
(cl:defun _funCallLikeElemsInBraces (start elems level slotNameAtom) (cl:let (ind) (cl:setf ind (cl:handler-case (cl:progn (getRequiredElemInd "{" start elems cl:nil)) (tl-syntax-error () (cl:return-from _funCallLikeElemsInBraces (cl:values cl:nil (_make-vector_) start))))) (cl:let (form end) (cl:setf (cl:values form end) (funcCall ind elems level slotNameAtom)) (cl:values cl:t (_getitem_ form 1) end))))
(cl:defun procClassSlotsList (start elems level addLineNums) (declare (ignore addLineNums)) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_))) (cl:let (brackInd) (cl:setf brackInd (cl:handler-case (cl:progn (getRequiredElemInd "{" start elems cl:nil)) (tl-syntax-error () (cl:return-from procClassSlotsList (cl:values cl:nil (_make-vector_ :initContent (cl:list form)) start))))) (cl:let (innerElems end) (cl:setf (cl:values innerElems end) (getElemsInBrackets brackInd elems)) (cl:do ((ind 0)) ((_>=_ ind (len innerElems))) (cl:let (slPresent slName) (cl:setf (cl:values slPresent slName ind) (_procName ind innerElems level cl:nil)) (cl:cond (slPresent (cl:let (optPresent optForms) (cl:setf (cl:values optPresent optForms ind) (_funCallLikeElemsInBraces ind innerElems level (_getitem_ slName 0))) (cl:cond (optPresent (tl-append (_getitem_ form 1) (cl:list FORM_TYPE optForms))) (cl:t (tl-append (_getitem_ form 1) (_getitem_ slName 0)))))) (cl:t (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM COMM_ELEM ",")) ind innerElems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ())))))))) (cl:values cl:t (_make-vector_ :initContent (cl:list form)) (_+_ end 1))))))
(cl:defun procStructSlots (start elems level addLineNums) (cl:let (strPres form end) (cl:setf (cl:values strPres form end) (procClassSlotsList start elems level addLineNums)) (cl:values strPres (_getitem_ (_getitem_ form 0) 1) end)))
(cl:defun procMethQualif (start elems level addLineNums) (declare (ignore addLineNums)) (cl:let (brackInd) (cl:setf brackInd (cl:do ((ind start (_+_ ind 1))) ((_>=_ ind (len elems)) cl:nil) (cl:cond ((has_key BRACKETS (cl:slot-value (_getitem_ elems ind) 'type)) (cl:return-from cl:nil ind))))) (cl:cond (brackInd (tl-case (cl:slot-value (_getitem_ elems brackInd) 'type) ((signalSyntaxError (_%_ "Missing elements in {-brackets after position ~D, on line ~D" (cl:list (cl:slot-value (_getitem_ elems brackInd) 'start) (cl:slot-value (_getitem_ elems brackInd) 'lineNum))))) (("(" "{") (cl:let (forms) (cl:setf forms (getForms (_getitem_ elems (_make-slice_ start brackInd cl:nil)) level cl:nil)) (cl:cond (forms (cl:values cl:t forms brackInd)) (cl:t (cl:values cl:nil (_make-vector_) brackInd))))))) (cl:t (signalSyntaxError (_%_ "Missing elements in {-brackets after position ~D, on line ~D" (cl:list (cl:slot-value (_getitem_ elems (_-_ (len elems) 1)) 'start) (cl:slot-value (_getitem_ elems (_-_ (len elems) 1)) 'lineNum))))))))
(const BLOCK_FUNCS (_make-hash-table_ FUN_NAME #'procFunName GEN_FUN_NAME #'procGenFunName NAME #'procName NAME2 #'procName2 FUN_NAME_FROM_LEVEL #'procFunNameFromLevelInfo LAMBDA_LIST #'procLambdaList MAC_LAMBDA_LIST #'procMacLambdaList SPEC_LAMBDA_LIST #'procSpecLambdaList MAC_BODY_BLOCK #'procMacBodyBlock FUN_BODY_BLOCK #'procFunBodyBlock LAMBDA_BODY_BLOCK #'procLambdaBodyBlock GEN_FUN_METH_BODY_BLOCK #'procGenFunMethBodyBlock BODY_BLOCK #'procBodyBlock LET_LIST #'procLetList DO_VAR_LIST #'procDoVarList DO_TEST_RES_LIST #'procDoTestResultList OPER_EXPR #'procOperExpr OPER_EXPR_IN_BRACK #'procOperExprInBrack MULT_OPER_EXPR_IN_BRACK #'procMultOperExprInBrack STRUCT_SLOTS #'procStructSlots STRUCT_OPTIONS #'procStructOptions CLASS_SLOTS_LIST #'procClassSlotsList CLASS_OPTIONS #'procClassOptions METH_QUALIF #'procMethQualif))
(cl:defun _isStructPresent (part start elems) (cl:cond ((typep (_getitem_ part 0) 'symbol) (cl:let (blockFunc keyPresent) (cl:setf (cl:values blockFunc keyPresent) (_getitem_ BLOCK_FUNCS (_getitem_ part 0))) (cl:cond ((_not_ keyPresent) (signalSyntaxError (_%_ "Handling of block structure '~A' is not implemented." (_getitem_ part 0))))) ; level info object here should be dummy
 (cl:values (funcall blockFunc start elems (makeLevelInfo) cl:nil) start part))) ((_!=_ (tl-count AUX_SPEC_SYMB (_getitem_ part 0)) 0) (cl:handler-case (cl:progn (cl:let (ind) (cl:setf ind (getRequiredElemInd SPEC_SYMB_ELEM start elems cl:nil)) (cl:cond ((_==_ (_getitem_ part 0) (cl:slot-value (_getitem_ elems ind) 'value)) (cl:values cl:t (_+_ ind 1) (_getitem_ part (_make-slice_ 1 cl:nil cl:nil)))) (cl:t (cl:values cl:nil start part))))) (tl-syntax-error () (cl:values cl:nil start part)))) (cl:t (signalSyntaxError (_%_ "Programming error: inner forms' descriptions in TL_BLOCK should start from either AUX_SPEC_SYMB or a block structure symbol; instead got: ~A" part)))))
(cl:defun _readBlockStructElems (blockDescr firstElemInd elems level addLineNums) (cl:let (forms) (cl:setf forms (_make-vector_)) (cl:let (ind) (cl:setf ind firstElemInd) (tl-for (descr blockDescr) (cl:nil) (cl:let (isOptional) (cl:setf isOptional cl:nil) (cl:let (multiple) (cl:setf multiple cl:nil) (cl:let (part) (cl:setf part (cl:typecase descr (list (tl-for (opt (_getitem_ descr (_make-slice_ 1 cl:nil cl:nil))) (cl:nil) (cl:cond ((_==_ opt OPTIONAL) (cl:setf isOptional cl:t)) ((_==_ opt MULT) (cl:setf multiple cl:t)))) (_getitem_ descr 0)) ((or symbol vector) descr) (cl:t (error (_%_ "Programming error: wrong element in Const.TL_BLOCK - ~A" descr))))) (cl:typecase part (symbol (cl:let (blockFunc keyPresent) (cl:setf (cl:values blockFunc keyPresent) (_getitem_ BLOCK_FUNCS part)) (cl:cond ((_not_ keyPresent) (signalSyntaxError (_%_ "Handling of block structure '~A' is not implemented." part)))) (cl:let (partFound newForms) (cl:setf (cl:values partFound newForms ind) (funcall blockFunc ind elems level addLineNums)) (cl:cond (partFound (cl:cond (multiple (tl-append forms (_make-vector_ :initContent (cl:list newForms))) (cl:do () ((_not_ partFound)) (cl:setf (cl:values partFound newForms ind) (funcall blockFunc ind elems level addLineNums)) (cl:cond (partFound (tl-append (_getitem_ forms (_unary-_ 1)) newForms))))) (cl:t (tl-append forms newForms)))) (cl:t (cl:cond (isOptional (tl-append forms newForms)) (cl:t (signalSyntaxError (_%_ "Required '~A' part of a block structure is missing on line ~D" (cl:list part (cl:slot-value (_getitem_ elems ind) 'lineNum))))))))))) (vector (cl:let (partFound partToRead) (cl:setf (cl:values partFound ind partToRead) (_isStructPresent part ind elems)) (cl:cond (partFound (cl:let (newForms) (cl:setf (cl:values newForms ind) (_readBlockStructElems partToRead ind elems level addLineNums)) (cl:cond (multiple (tl-append forms (_make-vector_ :initContent (cl:list newForms))) (cl:do () (cl:nil) (cl:setf (cl:values partFound ind partToRead) (_isStructPresent part ind elems)) (cl:cond (partFound (cl:setf (cl:values newForms ind) (_readBlockStructElems partToRead ind elems level addLineNums)) (tl-append (_getitem_ forms (_unary-_ 1)) newForms)) (cl:t (cl:return-from cl:nil ()))))) (cl:t (tl-append forms newForms))))) (cl:t (cl:cond (isOptional (tl-append forms (_make-vector_))) (cl:t (signalSyntaxError (_%_ "Required special symbol '~A' is missing on line ~D, position ~D" (cl:list (_getitem_ part 0) (cl:slot-value (_getitem_ elems ind) 'lineNum) (cl:slot-value (_getitem_ elems ind) 'start)))))))))) (cl:t (error (_%_ "Programming error: wrong element in Const.TL_BLOCK - ~A" part)))))))) (cl:values forms ind))))
(cl:defun _descrProcessing (descr blockParts) (cl:typecase descr (string (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE descr)))) (integer (_getitem_ blockParts descr)) (list (cl:let (isOptional) (cl:setf isOptional cl:nil) (cl:let (multiple) (cl:setf multiple cl:nil) (cl:let (partInd) (cl:setf partInd (_getitem_ descr 0)) (cl:let (descrInd) (cl:setf descrInd 1) (cl:do () (cl:nil) (cl:cond ((_==_ (_getitem_ descr descrInd) OPTIONAL) (cl:setf isOptional cl:t) (cl:setf descrInd (_+_ descrInd 1))) ((_==_ (_getitem_ descr descrInd) MULT) (cl:setf multiple cl:t) (cl:setf descrInd (_+_ descrInd 1))) (cl:t (cl:return-from cl:nil ())))) (cl:cond ((_==_ (len (_getitem_ blockParts partInd)) 0) (cl:cond (isOptional (cl:cond ((_<=_ (len descr) (_+_ descrInd 1)) (_make-vector_)) (cl:t (_descrProcessing (_getitem_ descr (_+_ descrInd 1)) blockParts)))) (cl:t (error "Programming error: not optional element is empty in _writeBlockStructForm")))) (cl:t (cl:cond (multiple (tl-for (part (_getitem_ blockParts partInd) (res (_make-vector_))) (res) (extend res (_descrProcessing (_getitem_ descr descrInd) part)))) (cl:t (_descrProcessing (_getitem_ descr descrInd) (_getitem_ blockParts partInd))))))))))) (vector (_make-vector_ :initContent (cl:list (_writeBlockStructForm descr blockParts)))) (cl:t (error (_%_ "Programming error: description of unknown type in TL_BLOCK's form: ~A" descr)))))
(cl:defun _writeBlockStructForm (formDescr blockParts) (tl-for (descr formDescr (form (cl:list FORM_TYPE (_make-vector_)))) (form) (extend (_getitem_ form 1) (_descrProcessing descr blockParts))))
(cl:defun getBlockForm (firstElemInd elems level addLineNums) (cl:let (blockName) (cl:setf blockName (cl:slot-value (_getitem_ elems firstElemInd) 'value)) (cl:let (blockParts end) (cl:setf (cl:values blockParts end) (_readBlockStructElems (_getitem_ (_getitem_ TL_BLOCK blockName) 0) (_+_ firstElemInd 1) elems level addLineNums)) (cl:values (_writeBlockStructForm (_getitem_ (_getitem_ TL_BLOCK blockName) 1) blockParts) end))))
(cl:defun getBracketedForm (indOpenBr elems level addLineNums) (cl:let (innerElems indClosBr) (cl:setf (cl:values innerElems indClosBr) (getElemsInBrackets indOpenBr elems)) (cl:values (cl:list FORM_TYPE (getForms innerElems level addLineNums)) (_+_ indClosBr 1))))
(cl:defun getSimpleArrayForm (start elems level) (cl:let (innerElems indClosBr) (cl:setf (cl:values innerElems indClosBr) (getElemsInBrackets start elems)) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE MAKE_SIMPLE_ARRAY_FUNC))))) (cl:let (initElems) (cl:setf initElems (getForms innerElems level cl:nil)) (cl:cond ((_!=_ (len initElems) 0) (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE ":initContent")) (tl-append (_getitem_ form 1) (cl:list FORM_TYPE (_+_ (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE MAKE_LIST_FUNC))) initElems))))) (cl:values form (_+_ indClosBr 1))))))
(cl:defun getListForm (start elems level) (cl:let (innerElems indClosBr) (cl:setf (cl:values innerElems indClosBr) (getElemsInBrackets start elems)) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE MAKE_LIST_FUNC))))) (extend (_getitem_ form 1) (getForms innerElems level cl:nil)) (cl:values form (_+_ indClosBr 1)))))
(cl:defun getFormAfterElem (elemType start elems level) (cl:let (elemFound separInd) (cl:setf (cl:values elemFound separInd) (getElemIndInOperExpr elemType start elems)) (cl:cond (elemFound (cl:let (form end) (cl:setf (cl:values form end) (getOneForm (_+_ separInd 1) elems level cl:nil)) (cl:cond ((_not_ form) (signalSyntaxError (_%_ "Missing a form after '~A' on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems separInd) 'type) (cl:slot-value (_getitem_ elems separInd) 'lineNum) (cl:slot-value (_getitem_ elems separInd) 'start)))))) (cl:values form separInd end))) (cl:t (cl:values cl:nil cl:nil separInd)))))
(cl:defun getFormsSeparByElem (elemType start elems level) (cl:let (forms) (cl:setf forms (_make-vector_)) (cl:let (secondForm separInd end) (cl:setf (cl:values secondForm separInd end) (getFormAfterElem elemType start elems level)) (cl:cond (secondForm (cl:let (firstForm) (cl:setf firstForm (getOneForm 0 (_getitem_ elems (_make-slice_ start separInd cl:nil)) level cl:nil)) (cl:cond (firstForm (tl-append forms firstForm)) (cl:t (signalSyntaxError (_%_ "Missing a form before '~A' on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems separInd) 'type) (cl:slot-value (_getitem_ elems separInd) 'lineNum) (cl:slot-value (_getitem_ elems separInd) 'start)))))) (tl-append forms secondForm))) (cl:t (cl:let (firstForm) (cl:setf (cl:values firstForm end) (getOneForm start elems level cl:nil)) (cl:cond (firstForm (tl-append forms firstForm)))))) (cl:values forms end))))
(cl:defun getDictForm (start elems level) (cl:let (innerElems indClosBr) (cl:setf (cl:values innerElems indClosBr) (getElemsInBrackets start elems)) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE MAKE_DICTIONARY_FUNC))))) (cl:do ((ind 0)) ((_>=_ ind (len innerElems))) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list COMM_ELEM WHITE_ELEM ",")) ind innerElems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ()))) (cl:let (forms) (cl:setf (cl:values forms ind) (getFormsSeparByElem "->" ind innerElems level)) (tl-append (_getitem_ form 1) (_getitem_ forms 0)) (cl:case (len forms) ((2) (tl-append (_getitem_ form 1) (_getitem_ forms 1))) ((1) (tl-append (_getitem_ form 1) (cl:list ATOM_TYPE LISP_NIL))))))) (cl:values form (_+_ indClosBr 1)))))
(cl:defun getNFormsInBrack (start elems level numForms) (cl:let (innerElems indClosBr) (cl:setf (cl:values innerElems indClosBr) (getElemsInBrackets start elems)) (cl:let (forms) (cl:setf forms (getForms innerElems level cl:nil)) (cl:cond ((_==_ (len forms) 0) (signalSyntaxError (_%_ "Empty brackets, starting line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems start) 'lineNum) (cl:slot-value (_getitem_ elems start) 'start))))) ((_!=_ (len forms) numForms) (signalSyntaxError (_%_ "Brackets, starting line ~D, position ~D, contain ~D forms instead of ~D" (cl:list (cl:slot-value (_getitem_ elems start) 'lineNum) (cl:slot-value (_getitem_ elems start) 'start) (len forms) numForms))))) (cl:values forms (_+_ indClosBr 1)))))
(cl:defun getComplNumForm (start elems level) (cl:let (ind) (cl:setf ind (getRequiredElemInd "(" (_+_ start 1) elems)) (cl:let (forms end) (cl:setf (cl:values forms end) (getNFormsInBrack ind elems level 2)) (cl:values (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE MAKE_COMPLEX_NUM_FUNC) (_getitem_ forms 0) (_getitem_ forms 1)))) end))))
(cl:defun funcCall (start elems level lastForm) (cl:let (innerElems indClosBr) (cl:setf (cl:values innerElems indClosBr) (getElemsInBrackets start elems)) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_))) (cl:cond (lastForm (tl-append (_getitem_ form 1) lastForm))) (cl:do ((ind 0)) ((_>=_ ind (len innerElems))) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM ",")) ind innerElems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ()))) (cl:cond ((_==_ (cl:slot-value (_getitem_ innerElems ind) 'type) ".") (cl:let (brackInd) (cl:setf brackInd (getRequiredElemInd "(" (_+_ ind 1) innerElems)) (cl:let (innerListForm) (cl:setf (cl:values innerListForm ind) (funcCall brackInd innerElems level cl:nil)) (tl-append (_getitem_ form 1) innerListForm)))) (cl:t (cl:let (forms) (cl:setf (cl:values forms ind) (getFormsSeparByElem "=" ind innerElems level)) (extend (_getitem_ form 1) forms)))))) (cl:values form (_+_ indClosBr 1)))))
(cl:defun getitemFuncCall (start elems level lastForm) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE GET_ITEM_FUNC) lastForm)))) (cl:let (innerElems indClosBr) (cl:setf (cl:values innerElems indClosBr) (getElemsInBrackets start elems)) (cl:let (arrowPres arrowInd) (cl:setf (cl:values arrowPres arrowInd) (getElemIndInOperExpr "->" 0 innerElems)) (tl-append (_getitem_ form 1) (cl:cond (arrowPres (cl:let (indexForm) (cl:setf indexForm (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE MAKE_SLICE_FUNC))))) (cl:let (startForm) (cl:setf startForm (getOneForm 0 (_getitem_ innerElems (_make-slice_ 0 arrowInd cl:nil)) level cl:nil)) (cl:let (endForm endEndForm) (cl:setf (cl:values endForm endEndForm) (getOneForm (_+_ arrowInd 1) innerElems level cl:nil)) (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM ",")) endEndForm innerElems cl:nil)) (cl:let (stepForm) (cl:setf stepForm (cl:cond (elemFound (getOneForm ind innerElems level cl:nil)) (cl:t cl:nil))) (cl:cond (startForm (tl-append (_getitem_ indexForm 1) startForm)) (cl:t (tl-append (_getitem_ indexForm 1) (cl:list ATOM_TYPE LISP_NIL)))) (cl:cond (endForm (tl-append (_getitem_ indexForm 1) endForm)) (cl:t (cl:cond ((_not_ startForm) (signalSyntaxError (_%_ "No index present in brackets on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems start) 'lineNum) (cl:slot-value (_getitem_ elems start) 'start)))))) (tl-append (_getitem_ indexForm 1) (cl:list ATOM_TYPE LISP_NIL)))) (cl:cond (stepForm (tl-append (_getitem_ indexForm 1) stepForm)) (cl:t (tl-append (_getitem_ indexForm 1) (cl:list ATOM_TYPE LISP_NIL)))) indexForm)))))) (cl:t (cl:let (indexForms) (cl:setf indexForms (getForms innerElems level cl:nil)) (cl:case (len indexForms) ((1) (_getitem_ indexForms 0)) ((0) (signalSyntaxError (_%_ "Expected index is missing in brackets on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems start) 'lineNum) (cl:slot-value (_getitem_ elems start) 'start))))) (cl:otherwise (cl:list FORM_TYPE (_+_ (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE MAKE_LIST_FUNC))) indexForms)))))))) (cl:values form (_+_ indClosBr 1))))))
(cl:defun slotOrFuncCall (start elems level lastForm addLineNums) (cl:let (nameInd) (cl:setf nameInd (getRequiredElemInd SYMB_ELEM (_+_ start 1) elems)) (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM)) (_+_ nameInd 1) elems)) (cl:cond (elemFound (tl-case (cl:slot-value (_getitem_ elems ind) 'type) cl:nil (("(") (cl:let (form) (cl:setf (cl:values form ind) (funcCall ind elems level lastForm)) (insert (_getitem_ form 1) 0 (cl:list ATOM_TYPE (getRealSymbol level (cl:slot-value (_getitem_ elems nameInd) 'value)))) (cl:return-from slotOrFuncCall (cl:values form ind)))) (("{") (cl:return-from slotOrFuncCall (extendWithBodyBlock ind elems level (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE (getRealSymbol level (cl:slot-value (_getitem_ elems nameInd) 'value))) lastForm))) addLineNums)))))) (cl:values (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE GET_OBJ_SLOT_FUNC) lastForm (cl:list SHORTCUT_TYPE "'" (cl:list ATOM_TYPE (getRealSymbol level (cl:slot-value (_getitem_ elems nameInd) 'value))))))) (_+_ nameInd 1)))))
(cl:defun packOrKeywName (start elems lastForm) (cl:cond (lastForm (cl:let (updatedLastForm) (cl:setf updatedLastForm lastForm) (cl:let (packageNamePresent) (cl:setf packageNamePresent cl:nil) (cl:cond ((_==_ (_getitem_ updatedLastForm 0) ATOM_TYPE) (cl:setf updatedLastForm (cl:list ATOM_TYPE (_+_ (_getitem_ updatedLastForm 1) (cl:slot-value (_getitem_ elems start) 'type)))) (cl:setf packageNamePresent cl:t))) (cl:let (ind) (cl:setf ind (getRequiredElemInd SYMB_ELEM (_+_ start 1) elems)) (cl:cond (packageNamePresent (cl:values cl:nil (cl:list ATOM_TYPE (_+_ (_getitem_ updatedLastForm 1) (cl:slot-value (_getitem_ elems ind) 'value))) (_+_ ind 1))) (cl:t (cl:values (cl:list ATOM_TYPE (_+_ (cl:slot-value (_getitem_ elems start) 'type) (cl:slot-value (_getitem_ elems ind) 'value))) updatedLastForm (_+_ ind 1)))))))) (cl:t (cl:let (ind) (cl:setf ind (getRequiredElemInd SYMB_ELEM (_+_ start 1) elems)) (cl:values (cl:list ATOM_TYPE (_+_ (cl:slot-value (_getitem_ elems start) 'type) (cl:slot-value (_getitem_ elems ind) 'value))) cl:nil (_+_ ind 1))))))
(cl:defun extendWithBodyBlock (start elems level lastForm addLineNums) (cl:let (trueVal forms end) (cl:setf (cl:values trueVal forms end) (procBodyBlock start elems level addLineNums)) (cl:let (form) (cl:setf form lastForm) (cl:cond ((_!=_ (_getitem_ form 0) FORM_TYPE) (cl:setf form (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list form)))))) (extend (_getitem_ form 1) forms) (cl:values form end))))
(cl:defun getStringAtom (start elems) (cl:do ((atom (cl:list ATOM_TYPE (cl:slot-value (_getitem_ elems start) 'value))) (ind (_+_ start 1))) ((_>=_ ind (len elems)) (signalSyntaxError (_%_ "Cannot find the end of the string started on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems start) 'lineNum) (cl:slot-value (_getitem_ elems start) 'start))))) (tl-case (cl:slot-value (_getitem_ elems ind) 'type) ((error (_%_ "Programming error: Before string ends, have an unexpected type of StrElem - '~A', on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems ind) 'type) (cl:slot-value (_getitem_ elems ind) 'lineNum) (cl:slot-value (_getitem_ elems ind) 'start))))) ((LINE_END_ELEM) (cl:setf ind (growOnIndex elems (_+_ ind 1)))) ((STR_MID_ELEM) (_+=_ (_getitem_ atom 1) (cl:slot-value (_getitem_ elems ind) 'value)) (_+=_ ind 1)) ((STR_END_ELEM) (_+=_ (_getitem_ atom 1) (cl:slot-value (_getitem_ elems ind) 'value)) (cl:return-from cl:nil (cl:values atom (_+_ ind 1)))))))
(cl:defun getCLispAtom (start elems) (cl:do ((atom (cl:list ATOM_TYPE "")) (ind (_+_ start 1))) ((_>=_ ind (len elems)) (signalSyntaxError (_%_ "Cannot find the end of the common lisp code started on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems start) 'lineNum) (cl:slot-value (_getitem_ elems start) 'start))))) (tl-case (cl:slot-value (_getitem_ elems ind) 'type) ((error (_%_ "Programming error: Before Common Lisp code ends, have an unexpected type of StrElem - '~A', from line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems ind) 'type) (cl:slot-value (_getitem_ elems ind) 'lineNum) (cl:slot-value (_getitem_ elems ind) 'start))))) ((LINE_END_ELEM) (cl:setf ind (growOnIndex elems (_+_ ind 1)))) ((CLISP_MID_ELEM) (_+=_ (_getitem_ atom 1) (cl:slot-value (_getitem_ elems ind) 'value)) (_+=_ ind 1)) ((CLISP_END_ELEM) (_+=_ (_getitem_ atom 1) (cl:slot-value (_getitem_ elems ind) 'value)) (cl:return-from cl:nil (cl:values atom (_+_ ind 1)))))))
(cl:defun twLispDirectiveProc (start elems level) (tl-case (cl:slot-value (_getitem_ elems start) 'value) ((error (_%_ "Handling of a TwinLisp directive '~A' on line ~D, position ~D, is not implemented, yet." (cl:list (cl:slot-value (_getitem_ elems start) 'value) (cl:slot-value (_getitem_ elems start) 'lineNum) (cl:slot-value (_getitem_ elems start) 'start))))) ((TL_DIR_GLOBAL) (cl:let (ind) (cl:setf ind (getRequiredElemInd SYMB_ELEM (_+_ start 1) elems cl:nil)) (cl:cond ((_==_ (tl-count (cl:slot-value level 'currImplVar) (cl:slot-value (_getitem_ elems ind) 'value)) 0) (tl-append (cl:slot-value level 'currImplVar) (cl:slot-value (_getitem_ elems ind) 'value)))) (_+_ ind 1))) ((TL_DIR_LEXSCOPE) (cl:let (ind) (cl:setf ind (getRequiredElemInd SPEC_SYMB_ELEM (_+_ start 1) elems cl:nil)) (cl:cond ((_==_ (cl:slot-value (_getitem_ elems ind) 'value) TL_EXPL_SCOPE) (cl:setf (cl:slot-value level 'implScope) cl:nil)) ((_==_ (cl:slot-value (_getitem_ elems ind) 'value) TL_IMPL_SCOPE) (cl:setf (cl:slot-value level 'implScope) cl:t)) (cl:t (signalSyntaxError (_%_ "Unexpected element '~A' on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ elems ind) 'value) (cl:slot-value (_getitem_ elems ind) 'lineNum) (cl:slot-value (_getitem_ elems ind) 'start)))))) (_+_ ind 1))) ((TL_DIR_USE) (cl:let (packName) (cl:setf packName "") (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 SYMB_ELEM (_+_ start 1) elems cl:nil)) (cl:cond (elemFound (_+=_ packName (_+_ (cl:slot-value (_getitem_ elems ind) 'value) ":")) (_+=_ ind 1))) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 ":" ind elems cl:nil)) (cl:cond (elemFound (_+=_ packName ":") (_+=_ ind 1))) (cl:setf ind (getRequiredElemInd "{" ind elems cl:nil)) (cl:let (innerElems) (cl:setf (cl:values innerElems ind) (getElemsInBrackets ind elems)) (cl:let (end) (cl:setf end (_+_ ind 1)) (cl:do ((ind 0)) ((_>=_ ind (len innerElems))) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM ",")) ind innerElems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ()))) (cl:setf ind (getRequiredElemInd SYMB_ELEM ind innerElems cl:nil)) (cl:let (symbName) (cl:setf symbName (cl:slot-value (_getitem_ innerElems ind) 'value)) (cl:cond ((_<_ (_+_ ind 1) (len innerElems)) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 "=" (_+_ ind 1) innerElems))) (cl:t (cl:setf elemFound cl:nil))) (cl:let (nickName) (cl:setf nickName (cl:cond (elemFound (cl:cond ((_<_ (_+_ ind 1) (len innerElems)) (cl:setf ind (getRequiredElemInd SYMB_ELEM (_+_ ind 1) innerElems cl:nil))) (cl:t (signalSyntaxError (_%_ "Expected element '~A', on line ~D is missing" (cl:list SYMB_ELEM (cl:slot-value (_getitem_ innerElems ind) 'lineNum)))))) (cl:slot-value (_getitem_ innerElems ind) 'value)) (cl:t symbName))) (addSymbSynonym level nickName (_+_ packName symbName)) (_+=_ ind 1)))) end)))))))
(const _COMMENT :comment)
(const _OP :operator)
(const _UN_OP :unar-oper)
(const _UN_BIN_OP :unar-or-bin-oper)
(const _BIN_OP :bin-oper)
(const _EXPR :expression)
(const _SHORTCUT :shortcut)
(const _NONE :none)
(cl:defun _lastOpExType (operAndExpr) (cl:cond ((_>_ (len operAndExpr) 0) (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 0)) (cl:t _NONE)))
(cl:defun getOperAndExpr (startInd elems level addLineNums) (cl:do ((operAndExpr (_make-vector_)) (ind startInd)) ((_>=_ ind (len elems)) (cl:values operAndExpr ind)) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM)) ind elems)) ; Does not go to the next line
 (cl:cond ((_not_ elemFound) (cl:return-from cl:nil (cl:values operAndExpr ind)))) (cl:let (el) (cl:setf el (_getitem_ elems ind)) (cl:cond ((_or_ (_==_ (cl:slot-value el 'type) ",") (_==_ (cl:slot-value el 'type) LINE_END_ELEM)) (cl:return-from cl:nil (cl:values operAndExpr ind))) ((_==_ (cl:slot-value el 'type) COMM_ELEM) (cl:cond ((_==_ (len operAndExpr) 0) (tl-append operAndExpr (cl:list _COMMENT (cl:list COMMENT_TYPE (cl:slot-value el 'value)))) (_+=_ ind 1))) (cl:return-from cl:nil (cl:values operAndExpr ind))) ((_==_ (cl:slot-value el 'type) SYMB_ELEM) (tl-append operAndExpr (cl:list _EXPR (cl:list ATOM_TYPE (getRealSymbol level (cl:slot-value el 'value))))) (_+=_ ind 1)) ((_or_ (_==_ (cl:slot-value el 'type) NUM_ELEM) (_==_ (cl:slot-value el 'type) SYNT_STRUCT_ELEM)) (tl-append operAndExpr (cl:list _EXPR (cl:list ATOM_TYPE (cl:slot-value el 'value)))) (_+=_ ind 1)) ((_==_ (cl:slot-value el 'type) STR_START_ELEM) (cl:let (atom) (cl:setf (cl:values atom ind) (getStringAtom ind elems)) (tl-append operAndExpr (cl:list _EXPR atom)))) ((_==_ (cl:slot-value el 'type) CLISP_START_ELEM) (cl:let (atom) (cl:setf (cl:values atom ind) (getCLispAtom ind elems)) (tl-append operAndExpr (cl:list _EXPR atom)))) ((_or_ (_==_ (cl:slot-value el 'type) ":") (_==_ (cl:slot-value el 'type) "::")) (cl:let (lastForm) (cl:setf lastForm (cl:cond ((_==_ (_lastOpExType operAndExpr) _EXPR) (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1)) (cl:t cl:nil))) (cl:let (form) (cl:setf (cl:values form lastForm ind) (packOrKeywName ind elems lastForm)) (cl:cond (lastForm (cl:setf (_getitem_ operAndExpr (_unary-_ 1)) (cl:list _EXPR lastForm)))) (cl:cond (form (tl-append operAndExpr (cl:list _EXPR form))))))) ((_==_ (cl:slot-value el 'type) SPEC_SYMB_ELEM) (cl:cond ((has_key TL_BLOCK (cl:slot-value el 'value)) (cl:let (form) (cl:setf (cl:values form ind) (getBlockForm ind elems level addLineNums)) (tl-append operAndExpr (cl:list _EXPR form)))) ((_!=_ (tl-count TL_DIRECT_SPEC_SYMB (cl:slot-value el 'value)) 0) (cl:setf ind (twLispDirectiveProc ind elems level))) (cl:t (signalSyntaxError (_%_ "Unexpected element '~A' on line ~D, position ~D" (cl:list (cl:slot-value el 'value) (cl:slot-value el 'lineNum) (cl:slot-value el 'start))))))) ((_==_ (cl:slot-value el 'type) "~(") (cl:let (form) (cl:setf (cl:values form ind) (getBracketedForm ind elems level addLineNums)) (tl-append operAndExpr (cl:list _EXPR form)))) ((_==_ (cl:slot-value el 'type) "~[") (cl:let (form) (cl:setf (cl:values form ind) (getListForm ind elems level)) (tl-append operAndExpr (cl:list _EXPR form)))) ((_==_ (cl:slot-value el 'type) "(") (cl:cond ((_==_ (_lastOpExType operAndExpr) _EXPR) (cl:let (form) (cl:setf (cl:values form ind) (funcCall ind elems level (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1))) (cl:setf (_getitem_ operAndExpr (_unary-_ 1)) (cl:list _EXPR form)))) (cl:t (cl:let (forms) (cl:setf (cl:values forms ind) (getNFormsInBrack ind elems level 1)) (tl-append operAndExpr (cl:list _EXPR (_getitem_ forms 0))))))) ((_==_ (cl:slot-value el 'type) "[") (cl:cond ((_==_ (_lastOpExType operAndExpr) _EXPR) (cl:let (form) (cl:setf (cl:values form ind) (getitemFuncCall ind elems level (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1))) (cl:setf (_getitem_ operAndExpr (_unary-_ 1)) (cl:list _EXPR form)))) (cl:t (cl:let (form) (cl:setf (cl:values form ind) (getSimpleArrayForm ind elems level)) (tl-append operAndExpr (cl:list _EXPR form)))))) ((_==_ (cl:slot-value el 'type) "{") (cl:cond ((_==_ (_lastOpExType operAndExpr) _EXPR) (cl:let (form) (cl:setf (cl:values form ind) (extendWithBodyBlock ind elems level (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1) addLineNums)) (cl:setf (_getitem_ operAndExpr (_unary-_ 1)) (cl:list _EXPR form)))) (cl:t (cl:let (form) (cl:setf (cl:values form ind) (getDictForm ind elems level)) (tl-append operAndExpr (cl:list _EXPR form)))))) ((_and_ (_==_ (cl:slot-value el 'type) ".") (_==_ (_lastOpExType operAndExpr) _EXPR)) (cl:let (form) (cl:setf (cl:values form ind) (slotOrFuncCall ind elems level (_getitem_ (_getitem_ operAndExpr (_unary-_ 1)) 1) addLineNums)) (cl:setf (_getitem_ operAndExpr (_unary-_ 1)) (cl:list _EXPR form)))) ((has_key SHORTCUT_OPERS (cl:slot-value el 'type)) (tl-append operAndExpr (cl:list _SHORTCUT el)) (_+=_ ind 1)) ((_!=_ (tl-count COMPL_NUM_OPER (cl:slot-value el 'type)) 0) (cl:let (form) (cl:setf (cl:values form ind) (getComplNumForm ind elems level)) (tl-append operAndExpr (cl:list _EXPR form)))) ((has_key UNAR_OPERS (cl:slot-value el 'type)) (cl:cond ((has_key BIN_OPERS (cl:slot-value el 'type)) (tl-append operAndExpr (cl:list _UN_BIN_OP el))) (cl:t (tl-append operAndExpr (cl:list _UN_OP el)))) (_+=_ ind 1)) ((has_key BIN_OPERS (cl:slot-value el 'type)) (tl-append operAndExpr (cl:list _BIN_OP el)) (_+=_ ind 1)) (cl:t (signalSyntaxError (_%_ "Unexpected element of type '~A' on line ~D at position ~D" (cl:list (cl:slot-value el 'type) (cl:slot-value el 'lineNum) (cl:slot-value el 'start))))))))))
(cl:defun _reduceBinaryOper (operStack exprStack nextOper) (cl:let (nextOpPrec) (cl:setf nextOpPrec (_getitem_ (_getitem_ BIN_OPERS (cl:slot-value nextOper 'type)) 1)) (cl:do () ((_==_ (len operStack) 0)) (cl:let (lastOpType) (cl:setf lastOpType (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type)) (cl:let (lastOpPrec) (cl:setf lastOpPrec (_getitem_ (_getitem_ BIN_OPERS lastOpType) 1)) (cl:cond ((_or_ (_<_ lastOpPrec nextOpPrec) (_and_ (_==_ lastOpPrec nextOpPrec) (_or_ (_==_ (_getitem_ (_getitem_ BIN_OPERS lastOpType) 2) LEFT_ASSOC) (_==_ (_getitem_ (_getitem_ BIN_OPERS lastOpType) 2) MULT_ARGS_ASSOC)))) (cl:let (reducedExpr) (cl:setf reducedExpr cl:nil) (cl:cond ((_and_ (_==_ (_getitem_ (_getitem_ BIN_OPERS lastOpType) 2) MULT_ARGS_ASSOC) (_==_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 0) FORM_TYPE)) (cl:cond ((_==_ (_getitem_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 1) 0) (cl:list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS lastOpType) 0))) (cl:setf reducedExpr (cl:list (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 0) (_+_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 1) (_make-vector_ :initContent (cl:list (_getitem_ exprStack (_unary-_ 1))))))))))) (cl:cond ((_not_ reducedExpr) (cl:setf reducedExpr (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS lastOpType) 0)) (_getitem_ exprStack (_unary-_ 2)) (_getitem_ exprStack (_unary-_ 1)))))))) (tl-pop exprStack) (cl:setf (_getitem_ exprStack (_unary-_ 1)) reducedExpr) (tl-pop operStack))) (cl:t (cl:return-from cl:nil ()))))))))
(cl:defun _reduceUnaryOper (operStack exprStack expr) (cl:let (reducedExpr) (cl:setf reducedExpr expr) (cl:do () ((_==_ (len operStack) 0)) (cl:cond ((_==_ (_getitem_ (_getitem_ operStack (_unary-_ 1)) 0) _UN_OP) (cl:let (funcName) (cl:setf funcName (_getitem_ (_getitem_ UNAR_OPERS (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type)) 0)) (cl:setf reducedExpr (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE funcName) reducedExpr)))) (tl-pop operStack))) (cl:t (cl:return-from cl:nil ())))) (tl-append exprStack reducedExpr)))
(cl:defun _reduceShorcut (operStack exprStack opex) (cl:let (reducedExpr) (cl:setf reducedExpr (tl-case (_getitem_ opex 0) cl:nil ((_EXPR) (_getitem_ opex 1)) ((_BIN_OP _UN_BIN_OP) (cl:list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS (cl:slot-value (_getitem_ opex 1) 'type)) 0))) ((_UN_OP) (cl:list ATOM_TYPE (_getitem_ (_getitem_ UNAR_OPERS (cl:slot-value (_getitem_ opex 1) 'type)) 0))))) (cl:do () ((_==_ (len operStack) 0)) (cl:cond ((_==_ (_getitem_ (_getitem_ operStack (_unary-_ 1)) 0) _SHORTCUT) (cl:setf reducedExpr (cl:list SHORTCUT_TYPE (_getitem_ SHORTCUT_OPERS (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type)) reducedExpr)) (tl-pop operStack)) (cl:t (cl:return-from cl:nil ())))) (_reduceUnaryOper operStack exprStack reducedExpr)))
(cl:defun _getFinalForm (operStack exprStack level) "This works with the assumption that only binary operators could have been left" (cl:cond ((_==_ (len exprStack) 0) (cl:cond ((_==_ (len operStack) 0) (cl:return-from _getFinalForm cl:nil)) (cl:t (signalSyntaxError (_%_ "Missing expression(s) to apply operator '~A' on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type) (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'lineNum) (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'start)))))))) (cl:do () ((_==_ (len operStack) 0)) (cl:let (lastOpType) (cl:setf lastOpType (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'type)) (cl:let (reducedExpr) (cl:setf reducedExpr cl:nil) (cl:cond ((_and_ (_==_ (_getitem_ (_getitem_ BIN_OPERS lastOpType) 2) MULT_ARGS_ASSOC) (_==_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 0) FORM_TYPE)) (cl:cond ((_==_ (_getitem_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 1) 0) (cl:list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS lastOpType) 0))) (cl:setf reducedExpr (cl:list (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 0) (_+_ (_getitem_ (_getitem_ exprStack (_unary-_ 2)) 1) (_make-vector_ :initContent (cl:list (_getitem_ exprStack (_unary-_ 1))))))))))) (cl:cond ((_not_ reducedExpr) (cl:cond ((_==_ lastOpType "=") (_formSymbAsImplVar level (_getitem_ exprStack (_unary-_ 2))))) (cl:setf reducedExpr (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE (_getitem_ (_getitem_ BIN_OPERS lastOpType) 0)) (_getitem_ exprStack (_unary-_ 2)) (_getitem_ exprStack (_unary-_ 1)))))))) (tl-pop exprStack) (cl:setf (_getitem_ exprStack (_unary-_ 1)) reducedExpr) (tl-pop operStack)))) (_getitem_ exprStack (_unary-_ 1)))
(cl:defun getOperForm (operAndExpr level) "Takes mixture of expr's and oper's and puts 'em into expr, whos form is returned.
    _SHORTCUT has precedence 0, and RIGHT_ASSOC. Note: _SHORTCUT changes the following oper to expr.
    Looking at UNAR_OPERS we note that all unary operators are RIGHT_ASSOC. Since there are no LEFT_ASSOC unary operators, their precedence does not matter. So, here we'll assume that *all unary* operators are RIGHT_ASSOC, and we won't bother with looking ahead, etc.
    Two consequent expr's is an error. Later, check for this should be moved to getOperAndExpr, were info about line positions is available, and more informative error message can be generated." (cl:let (operStack) (cl:setf operStack (_make-vector_)) (cl:let (exprStack) (cl:setf exprStack (_make-vector_)) (cl:let (lastElemType) (cl:setf lastElemType _NONE) (cl:do ((ind 0)) ((_>=_ ind (len operAndExpr))) (cl:let (opex) (cl:setf opex (_getitem_ operAndExpr ind)) (cl:let (curr) (cl:setf curr (_getitem_ opex 0)) (tl-case lastElemType ((error (_%_ "Programming error: lastElemType has invalid value '~A'" curr))) ((_EXPR) (tl-case curr ((error (_%_ "Programming error: type of element in operAndExpr has invalid value '~A'" curr))) ((_EXPR _UN_OP _SHORTCUT) (signalSyntaxError "It is illegal to have two consequent expressions in an operator form")) ((_BIN_OP _UN_BIN_OP) (_reduceBinaryOper operStack exprStack (_getitem_ opex 1)) (tl-append operStack (cl:list _BIN_OP (_getitem_ opex 1))) (cl:setf lastElemType _OP)) ((_COMMENT) (error "Programming error: getOperAndExpr should separate operator expressions and comments")))) ((_OP) (tl-case curr ((error (_%_ "Programming error: type of element in operAndExpr has invalid value '~A'" curr))) ((_BIN_OP) (signalSyntaxError (_%_ "Unexpected operator '~A' on line ~D, position ~D" (cl:list (cl:slot-value (_getitem_ opex 1) 'type) (cl:slot-value (_getitem_ opex 1) 'lineNum) (cl:slot-value (_getitem_ opex 1) 'start))))) ((_UN_OP _UN_BIN_OP) (tl-append operStack (cl:list _UN_OP (_getitem_ opex 1)))) ((_SHORTCUT) (tl-append operStack opex) (cl:setf lastElemType _SHORTCUT)) ((_EXPR) (_reduceUnaryOper operStack exprStack (_getitem_ opex 1)) (cl:setf lastElemType _EXPR)) ((_COMMENT) (signalSyntaxError (_%_ "Comment prematurely ends operator form on line ~D, after position ~D" (cl:list (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'lineNum) (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'end))))))) ((_NONE) (tl-case curr ((signalSyntaxError (_%_ "Programming error: type of element in operAndExpr has invalid value '~A'" curr))) ((_BIN_OP) (signalSyntaxError (_%_ "Operator '~A' on line ~D, position ~D, is not preceded by any expression" (cl:list (cl:slot-value (_getitem_ opex 1) 'type) (cl:slot-value (_getitem_ opex 1) 'lineNum) (cl:slot-value (_getitem_ opex 1) 'start))))) ((_UN_OP _UN_BIN_OP) (tl-append operStack (cl:list _UN_OP (_getitem_ opex 1))) (cl:setf lastElemType _OP)) ((_SHORTCUT) (tl-append operStack opex) (cl:setf lastElemType _SHORTCUT)) ((_EXPR) (tl-append exprStack (_getitem_ opex 1)) (cl:setf lastElemType _EXPR)) ((_COMMENT) (cl:return-from getOperForm (_getitem_ opex 1))))) ((_SHORTCUT) (tl-case curr ((_reduceShorcut operStack exprStack opex) (cl:setf lastElemType _EXPR)) ((_SHORTCUT) (tl-append operStack opex)) ((_COMMENT) (signalSyntaxError (_%_ "Comment prematurely ends operator form on line ~D, after position ~D" (cl:list (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'lineNum) (cl:slot-value (_getitem_ (_getitem_ operStack (_unary-_ 1)) 1) 'end)))))))) (_+=_ ind 1)))) (cl:cond ((_or_ (_==_ lastElemType _OP) (_==_ lastElemType _SHORTCUT)) (signalSyntaxError "Premature end of operator expression"))) (_getFinalForm operStack exprStack level)))))
(cl:defun getOneForm (startInd elems level addLineNums) ; returns only one first form or atom
 (cl:let (operAndExpr end) (cl:setf (cl:values operAndExpr end) (getOperAndExpr startInd elems level addLineNums)) (cl:let (form) (cl:setf form (getOperForm operAndExpr level)) (cl:values form end))))
(cl:defun getForms (elems level &optional (addLineNums cl:nil)) (cl:let (formsAndVars) (cl:setf formsAndVars (_make-vector_)) (cl:do ((ind 0)) ((_>=_ ind (len elems))) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (_make-vector_ :initContent (cl:list WHITE_ELEM ",")) ind elems cl:nil)) (cl:cond ((_not_ elemFound) (cl:return-from cl:nil ()))) (cl:cond (addLineNums (tl-append formsAndVars (cl:list (_make-vector_) (cl:list COMMENT_TYPE (_%_ "; source line # ~D" (cl:slot-value (_getitem_ elems ind) 'lineNum))))))) (cl:let (form) (cl:setf (cl:values form ind) (getOneForm ind elems level addLineNums)) (cl:cond (form (tl-append formsAndVars (cl:list (cl:slot-value level 'newVars) form)) (cl:setf (cl:slot-value level 'newVars) (_make-vector_))))))) (cl:let (forms) (cl:setf forms (_make-vector_)) (cl:cond ((cl:slot-value level 'isTopLevel) (tl-for (varAndForm formsAndVars) (cl:nil) (tl-append forms (_getitem_ varAndForm 1)))) (cl:t (cl:let (innerForms) (cl:setf innerForms forms) (tl-for (varAndForm formsAndVars) (cl:nil) (cl:cond ((_!=_ (len (_getitem_ varAndForm 0)) 0) (cl:let (form) (cl:setf form (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE LISP_LET) (cl:list FORM_TYPE (_make-vector_)))))) (tl-for (symbName (_getitem_ varAndForm 0)) (cl:nil) (tl-append (_getitem_ (_getitem_ (_getitem_ form 1) 1) 1) (cl:list ATOM_TYPE symbName))) (tl-append innerForms form) (cl:setf innerForms (_getitem_ form 1))))) (tl-append innerForms (_getitem_ varAndForm 1)))))) forms)))
