;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defclass TestTranslFormBuildingFour (unittest:testcase) ((unittest:tName :initform "TestTranslFormBuildingFour.twl") (unittest:tFuns :initform '(test-getForms-meth-specializers test-getForms-meth-specifiers test-getForms-defgen-1 test-getForms-defgen-2 test-getForms-defgen-3 test-getForms-defgen-4 test-getForms-gfun-1 test-getForms-gfun-2 test-getForms-glet-1 test-getForms-glet-2 test-getForms-glet-3 test-getForms-glabels-1 test-getForms-glabels-2 test-getForms-glabels-3 test-getForms-handle-1 test-getForms-handle-2))))
(cl:defmethod test-getForms-meth-specializers ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "meth foo (a==integer,b,c==character,d=0) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defmethod") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "integer")))) (cl:list ATOM_TYPE "b") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "c") (cl:list ATOM_TYPE "character")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "d") (cl:list ATOM_TYPE "0"))))))))))))))))
(cl:defmethod test-getForms-meth-specifiers ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "meth foo progn, :&other-qualifier (a==integer) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defmethod") (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "cl:progn") (cl:list ATOM_TYPE ":other-qualifier") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "integer"))))))))))))))))
(cl:defmethod test-getForms-defgen-1 ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "defgen foo (a,&&optional b)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defgeneric") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-defgen-2 ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "defgen foo (a,&&optional b)
            options {
                :documentation=\"foo doc-string\"}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defgeneric") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"foo doc-string\"")))))))))))))
(cl:defmethod test-getForms-defgen-3 ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "defgen foo (a,&&optional b)
            options {
                :documentation=\"foo doc-string\"}
            meth (a==character,b=#\A) {
                return a }
            meth (a==integer,b=0) {
                return a }
            meth :before (a==t,b=nil) {
                print(a) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defgeneric") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"foo doc-string\"")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "character")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "#\A"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "integer")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "0"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list ATOM_TYPE ":before") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:t")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "cl:nil"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "print") (cl:list ATOM_TYPE "a"))))))))))))))))
(cl:defmethod test-getForms-defgen-4 ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "defgen foo (a,&&optional b)
            meth (a==character,b=#\A) {
                return a }
            meth (a==integer,b=0) {
                return a }
            meth :before (a==t,b=nil) {
                print(a) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defgeneric") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "character")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "#\A"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "integer")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "0"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list ATOM_TYPE ":before") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:t")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "cl:nil"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "print") (cl:list ATOM_TYPE "a"))))))))))))))))
(cl:defmethod test-getForms-gfun-1 ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "gfun (a,&&optional b)
            options {
                :documentation=\"foo doc-string\"}
            meth (a==character,b=#\A) {
                a+b }
            meth (a==integer,b=0) {
                a+b }
            meth :before (a==t,b=nil) {
                print(a) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:generic-function") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"foo doc-string\"")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "character")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "#\A"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "integer")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "0"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list ATOM_TYPE ":before") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:t")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "cl:nil"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "print") (cl:list ATOM_TYPE "a"))))))))))))))))
(cl:defmethod test-getForms-gfun-2 ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "gfun (a,&&optional b)
            meth (a==character,b=#\A) {
                a+b }
            meth (a==integer,b=0) {
                a+b }
            meth :before (a==t,b=nil) {
                print(a) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:generic-function") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "character")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "#\A"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "integer")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "0"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list ATOM_TYPE ":before") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:t")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "cl:nil"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "print") (cl:list ATOM_TYPE "a"))))))))))))))))
(cl:defmethod test-getForms-glet-1 ((ts TestTranslFormBuildingFour)) ;; Attention, in CLisp generic-flet is available only from clos
 (cl:let (st) (cl:setf st "glet foo (a,&&optional b)
               bar (a) {
              foo(bar(1)) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "clos:generic-flet") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list ATOM_TYPE "1"))))))))))))))))
(cl:defmethod test-getForms-glet-2 ((ts TestTranslFormBuildingFour)) ;; Attention, in CLisp generic-flet is available only from clos
 (cl:let (st) (cl:setf st "glet foo (a,&&optional b)
               bar (a)
               options {
                :documentation=\"bar doc-string\"} {
              foo(bar(1)) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "clos:generic-flet") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"bar doc-string\"")))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list ATOM_TYPE "1"))))))))))))))))
(cl:defmethod test-getForms-glet-3 ((ts TestTranslFormBuildingFour)) ;; Attention, in CLisp generic-flet is available only from clos
 (cl:let (st) (cl:setf st "glet foo (a,&&optional b)
                   meth (a==character,b=#\A) {
                       a+b }
               bar (a)
               options {
                :documentation=\"bar doc-string\"} {
              foo(bar(1)) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "clos:generic-flet") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "character")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "#\A"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"bar doc-string\"")))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list ATOM_TYPE "1"))))))))))))))))
(cl:defmethod test-getForms-glabels-1 ((ts TestTranslFormBuildingFour)) ;; Attention, in CLisp generic-labels is available only from clos
 (cl:let (st) (cl:setf st "glabels
               foo (a,&&optional b)
               bar (a) {
              foo(bar(1)) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "clos:generic-labels") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list ATOM_TYPE "1"))))))))))))))))
(cl:defmethod test-getForms-glabels-2 ((ts TestTranslFormBuildingFour)) ;; Attention, in CLisp generic-labels is available only from clos
 (cl:let (st) (cl:setf st "glabels
               foo (a,&&optional b)
               bar (a)
               options {
                :documentation=\"bar doc-string\"} {
              foo(bar(1)) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "clos:generic-labels") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"bar doc-string\"")))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list ATOM_TYPE "1"))))))))))))))))
(cl:defmethod test-getForms-glabels-3 ((ts TestTranslFormBuildingFour)) ;; Attention, in CLisp generic-labels is available only from clos
 (cl:let (st) (cl:setf st "glabels
               foo (a,&&optional b)
                   meth (a==character,b=#\A) {
                       a+b }
               bar (a)
               options {
                :documentation=\"bar doc-string\"} {
              foo(bar(1)) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "clos:generic-labels") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":method") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "character")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "#\A"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":documentation") (cl:list ATOM_TYPE "\"bar doc-string\"")))))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list ATOM_TYPE "1"))))))))))))))))
(cl:defmethod test-getForms-handle-1 ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "handle { foo(), boo() }
          cond error1 { &act-on-error1() }
          cond error2 (er) { &act-on-error1(er) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:handler-case") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "boo"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "error1") (cl:list FORM_TYPE (_make-vector_)) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "act-on-error1"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "error2") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "er")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "act-on-error1") (cl:list ATOM_TYPE "er"))))))))))))))))
(cl:defmethod test-getForms-handle-2 ((ts TestTranslFormBuildingFour)) (cl:let (st) (cl:setf st "handle { foo(), boo() }
          cond error1 { &act-on-error1() }
          cond error2 (er) { &act-on-error1(er) }
          else (a,b=nil) { bar(a,b) }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo :implScope cl:t))) (unittest:assertEqual ts forms (_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:handler-case") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "boo"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "error1") (cl:list FORM_TYPE (_make-vector_)) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "act-on-error1"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "error2") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "er")))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "act-on-error1") (cl:list ATOM_TYPE "er"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE ":no-error") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "cl:nil"))))))) (cl:list FORM_TYPE (_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bar") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))))))))))))
