;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:let ((twlType "twl") (lispType "lisp") (faslType "fas") (dirLoadFileName "_load_")) (cl:labels ((translate-file-if-needed (fName) (cl:cond ((tl:_==_ (pathname-type fName) twlType) (cl:let (twlTime) (cl:setf twlTime (file-write-date fName)) (cl:let (lispName) (cl:setf lispName (merge-pathnames (make-pathname :type lispType) fName)) (cl:cond ((probe-file lispName) (cl:cond ((tl:_>_ twlTime (file-write-date lispName)) (translate-file fName lispName)))) (cl:t (translate-file fName lispName))) (cl:let (lispTime) (cl:setf lispTime (file-write-date lispName)) (cl:let (faslName) (cl:setf faslName (merge-pathnames (make-pathname :type faslType) fName)) (cl:cond ((probe-file faslName) (cl:cond ((tl:_>_ lispTime (file-write-date faslName)) lispName) (cl:t faslName))) (cl:t lispName))))))) (cl:t fName))) (probe-file-in-paths (fName) (tl:tl-for (defPath *tl-load-paths* res) (cl:nil) (cl:setf res (probe-file (merge-pathnames fName defPath))) (cl:cond (res (cl:return-from cl:nil res))))) (find-file-in-load-paths (fName) (tl:tl-case (pathname-type fName) ((cl:let (truePath) (cl:setf truePath (probe-file-in-paths fName)) (cl:cond (truePath (cl:values truePath cl:nil)) (cl:t (cl:values fName cl:nil))))) ((twlType) (cl:let (truePath) (cl:setf truePath (probe-file-in-paths fName)) (cl:cond ((tl:_not_ truePath) (error (tl:_%_ "File 'A~' does not exist" (namestring truePath))))) (cl:values (translate-file-if-needed truePath) cl:nil))) ((cl:nil) (cl:let (truePath) (cl:setf truePath (tl:tl-for (fileType (cl:list twlType lispType faslType) res) (cl:nil) (cl:setf res (probe-file-in-paths (merge-pathnames fName (make-pathname :type fileType)))) (cl:cond (res (cl:return-from cl:nil res))))) (cl:cond (truePath (cl:values (translate-file-if-needed truePath) cl:nil)) (cl:t (cl:let (dirLst) (cl:setf dirLst (tl:_+_ (pathname-directory fName) (cl:cond ((file-namestring fName) (cl:list (file-namestring fName))) (cl:t (cl:list))))) (cl:let (loadFName) (cl:setf loadFName (merge-pathnames (make-pathname :directory dirLst :name dirLoadFileName) fName)) (cl:setf truePath (tl:tl-for (fileType (cl:list twlType lispType faslType) res) (cl:nil) (cl:setf res (probe-file-in-paths (merge-pathnames loadFName (make-pathname :type fileType)))) (cl:cond (res (cl:return-from cl:nil res))))) (cl:cond (truePath (cl:values (translate-file-if-needed truePath) (merge-pathnames (make-pathname :directory (pathname-directory truePath) :name "") fName))) (cl:t (cl:values fName cl:nil))))))))))) (find-and-translate-file (filename) (cl:typecase filename (logical-pathname (find-file-in-load-paths (translate-logical-pathname filename))) (pathname (find-file-in-load-paths filename)) (string (find-file-in-load-paths (pathname filename))) (symbol (find-file-in-load-paths (pathname (string-downcase (tl:_%_ "~A" filename))))) (cl:t (cl:values filename cl:nil))))) (cl:defun tl-load (filename &rest rest) (cl:let (lispPath folder) (cl:setf (cl:values lispPath folder) (find-and-translate-file filename)) (cl:cond (folder (insert *tl-load-paths* 0 folder))) (prog1 (cl:unwind-protect (cl:progn (apply #'cl:load (tl:_+_ (cl:list lispPath) rest))) (cl:cond (folder (tl-remove *tl-load-paths* folder))))))) (cl:defun tl-require (filename &rest rest) (cl:let (lispPath folder) (cl:setf (cl:values lispPath folder) (find-and-translate-file filename)) (cl:cond (folder (insert *tl-load-paths* 0 folder))) (prog1 (cl:unwind-protect (cl:progn (apply #'cl:require (tl:_+_ (cl:list (namestring lispPath)) rest))) (cl:cond (folder (tl-remove *tl-load-paths* folder)))))))))
