;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defun getElemsInBrackets (indOpenBr elems &optional (retWithBrackets cl:nil)) (cl:let (indClosBr) (cl:setf indClosBr cl:nil) (cl:do* ((expClosBr (tl:_make-vector_ :initContent (cl:list (tl:_getitem_ BRACKETS (cl:slot-value (tl:_getitem_ elems indOpenBr) 'type))))) (numOpenBr 0) (ind (growOnIndex elems (tl:_+_ indOpenBr 1)))) ((tl:_>=_ ind (len elems)) (signalSyntaxError (tl:_%_ "Expected closing bracket to match '~A' on line ~D, position ~D, is missing" (cl:list (cl:slot-value (tl:_getitem_ elems indOpenBr) 'type) (cl:slot-value (tl:_getitem_ elems indOpenBr) 'lineNum) (cl:slot-value (tl:_getitem_ elems indOpenBr) 'start))))) (cl:let (el) (cl:setf el (tl:_getitem_ elems ind)) (cl:cond ((has_key BRACKETS (cl:slot-value el 'type)) ; it is an openning bracket
 (cl:setf numOpenBr (tl:_+_ numOpenBr 1)) (tl-append expClosBr (tl:_getitem_ BRACKETS (cl:slot-value el 'type)))) (cl:t (cl:cond ((tl:_!=_ (tl-count CLOSING_BRACKETS (cl:slot-value el 'type)) 0) ; it is a closing bracket, but is it a correct one?
 (cl:cond ((tl:_==_ (cl:slot-value el 'type) (string (tl:_getitem_ expClosBr (tl:_unary-_ 1)))) (cl:setf numOpenBr (tl:_-_ numOpenBr 1)) (tl-pop expClosBr) (cl:cond ((tl:_<_ numOpenBr 0) (cl:setf indClosBr ind) (cl:return-from cl:nil ())))) (cl:t (signalSyntaxError (tl:_%_ "Expect closing bracket '~A' on line ~D, position ~D, but got '~A' instead" (cl:list (tl:_getitem_ expClosBr (tl:_unary-_ 1)) (cl:slot-value el 'lineNum) (cl:slot-value el 'start) (cl:slot-value el 'type)))))))))) (cl:setf ind (growOnIndex elems (tl:_+_ ind 1))))) (cl:cond (retWithBrackets (cl:values (tl:_getitem_ elems (tl:_make-slice_ indOpenBr (tl:_+_ indClosBr 1) cl:nil)) (tl:_+_ indClosBr 1))) (cl:t (cl:values (tl:_getitem_ elems (tl:_make-slice_ (tl:_+_ indOpenBr 1) indClosBr cl:nil)) indClosBr)))))
(cl:defun _getLineEndElemInd (startInd elems) "Return the first line end element, or None" (cl:do ((ind startInd (tl:_+_ ind 1))) ((tl:_>=_ ind (len elems)) (cl:values cl:nil ind)) (cl:cond ((tl:_==_ (cl:slot-value (tl:_getitem_ elems ind) 'type) LINE_END_ELEM) (cl:return-from cl:nil (cl:values cl:t ind))))))
(cl:defun skipElems (elemTypes startInd elems &optional (onSameLine cl:t)) "Seeks index of the first element other then the ones that have to be skipped. If found, returns True and index, else False and len(elems) or LINE_END_ELEM index" (cl:do ((ind startInd)) ((tl:_>=_ ind (len elems)) (cl:values cl:nil ind)) (cl:let (elType) (cl:setf elType (cl:slot-value (tl:_getitem_ elems ind) 'type)) (cl:cond ((tl:_==_ elType LINE_END_ELEM) (cl:cond (onSameLine (cl:return-from cl:nil (cl:values cl:nil ind))))) ((tl:_==_ elType "\\") (cl:let (lineEndFound) (cl:setf (cl:values lineEndFound ind) (_getLineEndElemInd ind elems)) (cl:cond ((tl:_not_ lineEndFound) (cl:return-from cl:nil (cl:values cl:nil (len elems))))))) ((tl:_==_ (tl-count elemTypes elType) 0) (cl:return-from cl:nil (cl:values cl:t ind)))) (cl:setf ind (growOnIndex elems (tl:_+_ ind 1))))))
(cl:defun getRequiredElemInd (elemType startInd elems &optional (onSameLine cl:t)) "Required element shall always be on the same line (or continued line)" (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM)) startInd elems onSameLine)) (cl:cond ((tl:_not_ elemFound) (cl:cond (onSameLine (signalSyntaxError (tl:_%_ "Expect element '~A' on line ~D, but line ends" (cl:list elemType (cl:slot-value (tl:_getitem_ elems startInd) 'lineNum))))) (cl:t (cl:cond ((tl:_<_ startInd (len elems)) (signalSyntaxError (tl:_%_ "Expected element '~A' is missing on/after line ~D" (cl:list elemType (cl:slot-value (tl:_getitem_ elems startInd) 'lineNum))))) (cl:t (signalSyntaxError (tl:_%_ "Expected element '~A' is missing" elemType)))))))) (cl:cond ((tl:_==_ (cl:slot-value (tl:_getitem_ elems ind) 'type) elemType) ind) (cl:t (signalSyntaxError (tl:_%_ "Expected element '~A', but got instead element '~A' on line ~D" (cl:list elemType (cl:slot-value (tl:_getitem_ elems ind) 'type) (cl:slot-value (tl:_getitem_ elems ind) 'lineNum))))))))
(cl:defun getRequiredElemInd2 (elemType startInd elems &optional (onSameLine cl:t)) (cl:handler-case (cl:progn (cl:values cl:t (getRequiredElemInd elemType startInd elems onSameLine))) (tl-syntax-error () (cl:values cl:nil startInd))))
(cl:defun getShortcutInd (startInd elems &optional (onSameLine cl:t)) (tl:tl-for (elemType (tKeys SHORTCUT_OPERS)) ((cl:values cl:nil startInd)) (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (getRequiredElemInd2 elemType startInd elems onSameLine)) (cl:cond (elemFound (cl:return-from cl:nil (cl:values cl:t ind)))))))
(cl:defun getElemIndInOperExpr (elemType startInd elems) (cl:do ((ind startInd)) ((tl:_>=_ ind (len elems)) (cl:values cl:nil cl:nil)) (cl:let (elemFound) (cl:setf (cl:values elemFound ind) (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM)) ind elems)) (cl:cond ((tl:_not_ elemFound) (cl:return-from cl:nil (cl:values cl:nil cl:nil)))) (cl:cond ((tl:_==_ (cl:slot-value (tl:_getitem_ elems ind) 'type) elemType) (cl:return-from cl:nil (cl:values cl:t ind))) ((has_key BRACKETS (cl:slot-value (tl:_getitem_ elems ind) 'type)) (cl:setf ind (nth-value 1 (getElemsInBrackets ind elems cl:t)))) ((tl:_or_ (tl:_==_ (cl:slot-value (tl:_getitem_ elems ind) 'type) LINE_END_ELEM) (tl:_==_ (cl:slot-value (tl:_getitem_ elems ind) 'type) ",")) (cl:return-from cl:nil (cl:values cl:nil cl:nil))) (cl:t (cl:setf ind (tl:_+_ ind 1)))))))
