;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:defun write-tlisp-file (clispPath tlHomePath fileName destPath) (cl:let (expr_re) (cl:setf expr_re (regexp:regexp-compile "(tlPath (namestring (ext:cd)))")) (with-open-file (twinlispFile fileName :direction :input) (with-open-file (tlisp destPath :direction :output) (cl:cond (clispPath (write-line clispPath tlisp))) (cl:let (line match) (cl:setf (cl:values line match) (cl:do ((line (read-line twinlispFile cl:nil cl:nil) (read-line twinlispFile cl:nil cl:nil)) match) (cl:nil) (cl:setf match (regexp:regexp-exec expr_re line)) (cl:cond (match (cl:return-from cl:nil (cl:values line match)))) (write-line line tlisp))) (write-string line tlisp :start 0 :end (cl:slot-value match 'regexp::start)) (write-string (concatenate 'string "(tlPath \"" tlHomePath "\")") tlisp) (write-line line tlisp :start (cl:slot-value match 'regexp::end)) (cl:do ((line (read-line twinlispFile cl:nil cl:nil) (read-line twinlispFile cl:nil cl:nil))) ((not line)) (write-line line tlisp)))))))
(cl:setf (cl:values tlHomePath execPath clispPath) (cl:cond ((>= (length *args*) 3) (cl:values (car *args*) (cadr *args*) (caddr *args*))) ((= (length *args*) 2) (cl:values (car *args*) (cadr *args*) "")) ((= (length *args*) 1) (cl:values (car *args*) (car *args*) "")) (cl:t (cl:values cl:nil cl:nil cl:nil))))
(cl:cond ((not tlHomePath) (write-line "Installing tlisp (TwinLisp on top of clisp)") (write-string "Give a directory, where tlisp's libraries should be placed
  (you should have write permission)
Default is /usr/lib/: ") (cl:setf tlHomePath (read-line))))
(cl:cond ((equal (length tlHomePath) 0) (cl:setf tlHomePath "/usr/lib/twlisp/")) (cl:t (cl:setf tlHomePath (concatenate 'string tlHomePath "/twlisp/"))))
(cl:cond ((not execPath) (write-string "Give a directory, where tlisp and tclisp executables should be placed
  (you should have write permission)
Default is /usr/bin/: ") (cl:setf execPath (read-line))))
(cl:cond ((equal (length execPath) 0) (cl:setf execPath "/usr/bin/")))
(cl:setf tlispPath (concatenate 'string execPath "/tlisp"))
(cl:setf tclispPath (concatenate 'string execPath "/tclisp"))
(cl:cond ((not clispPath) (write-string "Give a path to a clisp executable.
Default is /usr/bin/clisp: ") (cl:setf clispPath (read-line))))
(cl:cond ((equal (length clispPath) 0) (cl:setf clispPath "#!/usr/bin/clisp")) (cl:t (cl:setf clispPath (concatenate 'string "#!" clispPath))))
;  -------- COPY APPROPRIATE STUFF TO LIB LOCATION AND COMPILE IT ----------
(shell (concatenate 'string "mkdir " tlHomePath "; cp -r * " tlHomePath "; cd " tlHomePath "; echo \"Compiling core files ...\"" "; clisp compile-core.lisp" "; echo \"Setting up executable file ...\""))
(write-tlisp-file clispPath tlHomePath "twinlisp.lisp" tlispPath)
(write-tlisp-file cl:nil tlHomePath "tclisp.lisp" (concatenate 'string tlHomePath "tclisp-pluggin.lisp"))
(shell (concatenate 'string "echo \"" (subseq clispPath 2) " -q --silent -i " (concatenate 'string tlHomePath "tclisp-pluggin.lisp") "\" > " tclispPath))
(write-line "Compiling dist-packages ...")
(shell (concatenate 'string "clisp " tlispPath " compile-dist-packs.twl" "; echo \"Done.\""))
