;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defclass TestTranslFormBuilding (unittest:testcase) ((unittest:tName :initform "TestTranslFormBuilding.twl") (unittest:tFuns :initform '(test-getForms-BracketForm-1 test-getForms-BracketForm-2 test-getForms-BracketForm-3 test-getForms-BracketForm-4 test-getForms-OperForm-1 test-getForms-OperForm-2 test-getForms-OperForm-3 test-getForms-OperForm-4 test-getForms-OperForm-5 test-getForms-OperForm-6 test-getForms-OperForm-7 test-getForms-OperForm-8 test-getForms-OperForm-9 test-getForms-OperForm-10 test-getForms-OperForm-11 test-getForms-OperForm-12 test-getForms-OperForm-13 test-getForms-OperForm-14 test-getForms-OperForm-15 test-getForms-OperForm-16 test-getForms-OperForm-17 test-getForms-OperForm-18 test-getForms-OperForm-19 test-getForms-OperForm-20 test-getForms-OperForm-21 test-getForms-OperForm-22 test-getForms-OperForm-23 test-getForms-OperForm-24 test-getForms-OperForm-25 test-getForms-OperForm-26 test-getForms-OperForm-27 test-getForms-OperForm-28 test-getForms-OperForm-29 test-getForms-ComplexNum-1 test-getForms-ComplexNum-2 test-getForms-ComplexNum-3 test-getForms-Array-1 test-getForms-Array-2 test-getForms-List-1 test-getForms-List-2 test-getForms-BodyBlock-1 test-getForms-BodyBlock-2 test-getForms-BodyBlock-3 test-getForms-BodyBlock-4 test-getForms-BodyBlock-5 test-getForms-String-1 test-getForms-String-2 test-getForms-String-3 test-getForms-CLisp-1 test-getForms-CLisp-2 test-getForms-Column-1 test-getForms-Column-2 test-getForms-Column-3 test-getForms-Column-4 test-getForms-Column-5 test-getForms-Column-6 test-getForms-Column-7 test-getForms-ObjSlots-1 test-getForms-ObjSlots-2 test-getForms-ObjSlots-3 test-getForms-ObjSlots-4 test-getForms-ObjMeth-1 test-getForms-ObjMeth-2 test-getForms-ObjMeth-3 test-getForms-ObjMeth-4 test-getForms-ObjMeth-5 test-getForms-Func-1 test-getForms-Func-2 test-getForms-Func-3 test-getForms-Func-4 test-getForms-Func-5 test-getForms-InnerFuncCallList-1 test-getForms-Dict-1 test-getForms-Dict-2 test-getForms-Dict-3 test-getForms-Dict-4 test-getForms-Dict-5 test-getForms-Dict-6 test-getForms-Dict-7 test-getForms-Dict-8 test-getForms-Dict-9 test-getForms-Dict-10 test-getForms-Getitem-1 test-getForms-Getitem-2 test-getForms-Getitem-3 test-getForms-Getitem-4 test-getForms-Getitem-5 test-getForms-Getitem-6 test-getForms-Getitem-7 test-getForms-Getitem-8 test-getForms-Getitem-9 test-getForms-Getitem-10 test-getForms-Getitem-11))))
(cl:defmethod test-getForms-BracketForm-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "~()") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) cl:t)) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list COMMENT_TYPE "; source line # 1") (cl:list FORM_TYPE (tl:_make-vector_))))))))
(cl:defmethod test-getForms-BracketForm-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "~(),~()
          ~(),~(~(),~())") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) cl:t)) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list COMMENT_TYPE "; source line # 1") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; source line # 1") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; source line # 2") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; source line # 2") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list COMMENT_TYPE "; source line # 2") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; source line # 2") (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BracketForm-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "  ~(),~(), \\ anything to new line will be skipped
            ~(),
            ~(~(),~())") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) cl:t)) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list COMMENT_TYPE "; source line # 1") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; source line # 1") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; source line # 2") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; source line # 3") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list COMMENT_TYPE "; source line # 3") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; source line # 3") (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BracketForm-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ "~() ; comment here" #\Newline) "~()") #\Newline) "~()")) (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list COMMENT_TYPE "; comment here") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_))))))))
(cl:defmethod test-getForms-BracketForm-5 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "~(a,b,c-d,~(foo))") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list ATOM_TYPE "c") (cl:list ATOM_TYPE "d")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))))))))))))
(cl:defmethod test-getForms-OperForm-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x")))))))
(cl:defmethod test-getForms-OperForm-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x,y") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y")))))))
(cl:defmethod test-getForms-OperForm-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x
          y") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y")))))))
(cl:defmethod test-getForms-OperForm-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x y") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-OperForm-5 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+y") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y"))))))))))
(cl:defmethod test-getForms-OperForm-6 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+y-z") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y")))) (cl:list ATOM_TYPE "z"))))))))))
(cl:defmethod test-getForms-OperForm-7 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+y*d") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_*_") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "d")))))))))))))
(cl:defmethod test-getForms-OperForm-8 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+'y") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list SHORTCUT_TYPE "'" (cl:list ATOM_TYPE "y")))))))))))
(cl:defmethod test-getForms-OperForm-9 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+'$y") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list SHORTCUT_TYPE "'" (cl:list SHORTCUT_TYPE "," (cl:list ATOM_TYPE "y"))))))))))))
(cl:defmethod test-getForms-OperForm-10 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "#'*") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list SHORTCUT_TYPE "#'" (cl:list ATOM_TYPE "tl:_*_"))))))))
(cl:defmethod test-getForms-OperForm-11 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a=x+y*d") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_*_") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "d"))))))))))))))))
(cl:defmethod test-getForms-OperForm-12 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a=x*(y+d)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_*_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "d"))))))))))))))))
(cl:defmethod test-getForms-OperForm-13 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+y*d/c-z") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_/_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_*_") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "d")))) (cl:list ATOM_TYPE "c"))))))) (cl:list ATOM_TYPE "z"))))))))))
(cl:defmethod test-getForms-OperForm-14 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a=x+=y=z") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+=_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "z"))))))))))))))))
(cl:defmethod test-getForms-OperForm-15 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a=x*(y+d,s)") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-OperForm-16 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a=x*(y+d,)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_*_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "d"))))))))))))))))
(cl:defmethod test-getForms-OperForm-17 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a=x*(y+d
                  s)") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-OperForm-18 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a=x+y \\
              *d") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_*_") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "d"))))))))))))))))
(cl:defmethod test-getForms-OperForm-19 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+y**d**c-z") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_**_") (cl:list ATOM_TYPE "y") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_**_") (cl:list ATOM_TYPE "d") (cl:list ATOM_TYPE "c")))))))))) (cl:list ATOM_TYPE "z"))))))))))
(cl:defmethod test-getForms-OperForm-20 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+~(foo,a+b)-z") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))) (cl:list ATOM_TYPE "z"))))))))))
(cl:defmethod test-getForms-OperForm-21 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x++y") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_unary+_") (cl:list ATOM_TYPE "y")))))))))))))
(cl:defmethod test-getForms-OperForm-22 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+-y") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_unary-_") (cl:list ATOM_TYPE "y")))))))))))))
(cl:defmethod test-getForms-OperForm-23 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a@b@c=x@y@z") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:values") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "c")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:values") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "z")))))))))))))
(cl:defmethod test-getForms-OperForm-24 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-OperForm-25 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x+'") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-OperForm-26 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "+") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-OperForm-27 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "*") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-OperForm-28 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "not x and y or z") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_or_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_and_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_not_") (cl:list ATOM_TYPE "x")))) (cl:list ATOM_TYPE "y")))) (cl:list ATOM_TYPE "z"))))))))))
(cl:defmethod test-getForms-OperForm-29 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "!x & y | z") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_or_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_and_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_not_") (cl:list ATOM_TYPE "x")))) (cl:list ATOM_TYPE "y")))) (cl:list ATOM_TYPE "z"))))))))))
(cl:defmethod test-getForms-ComplexNum-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=#c(s-d,23/45)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:complex") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list ATOM_TYPE "s") (cl:list ATOM_TYPE "d")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_/_") (cl:list ATOM_TYPE "23") (cl:list ATOM_TYPE "45"))))))))))))))))
(cl:defmethod test-getForms-ComplexNum-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=#c(3.4e-10,23/45)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:complex") (cl:list ATOM_TYPE "3.4e-10") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_/_") (cl:list ATOM_TYPE "23") (cl:list ATOM_TYPE "45"))))))))))))))))
(cl:defmethod test-getForms-ComplexNum-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=#c(3.4e-10)") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-Array-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=[s-d,23/45,foo]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-vector_") (cl:list ATOM_TYPE ":initContent") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:list") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list ATOM_TYPE "s") (cl:list ATOM_TYPE "d")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_/_") (cl:list ATOM_TYPE "23") (cl:list ATOM_TYPE "45")))) (cl:list ATOM_TYPE "foo"))))))))))))))))
(cl:defmethod test-getForms-Array-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=[]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-vector_")))))))))))))
(cl:defmethod test-getForms-List-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=~[s-d,23/45,foo]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:list") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list ATOM_TYPE "s") (cl:list ATOM_TYPE "d")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_/_") (cl:list ATOM_TYPE "23") (cl:list ATOM_TYPE "45")))) (cl:list ATOM_TYPE "foo")))))))))))))
(cl:defmethod test-getForms-List-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=~[]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:list")))))))))))))
(cl:defmethod test-getForms-BodyBlock-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo{a,b}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-BodyBlock-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo{a
                b=45}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "45"))))))))))))))))
(cl:defmethod test-getForms-BodyBlock-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo{}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))))))))))))
(cl:defmethod test-getForms-BodyBlock-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo{a
                b=45}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) cl:t)) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list COMMENT_TYPE "; source line # 1") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list COMMENT_TYPE "; source line # 1") (cl:list ATOM_TYPE "a") (cl:list COMMENT_TYPE "; source line # 2") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "45"))))))))))))))))
(cl:defmethod test-getForms-BodyBlock-5 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo{}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo) cl:t)) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list COMMENT_TYPE "; source line # 1") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))))))))))))
(cl:defmethod test-getForms-String-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st " \"Hello, World!\" ") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "\"Hello, World!\"")))))))
(cl:defmethod test-getForms-String-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=\"Hello, \"+\"World!\" ") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "\"Hello, \"") (cl:list ATOM_TYPE "\"World!\"")))))))))))))
(cl:defmethod test-getForms-String-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=\"Hello,
the\"+\" brave,
  new
   World!\" ") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "\"Hello,
the\"") (cl:list ATOM_TYPE "\" brave,
  new
   World!\"")))))))))))))
(cl:defmethod test-getForms-CLisp-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=#t{(- 1 2)#t}-3") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list ATOM_TYPE (tl:_+_ "(- 1 2)" #\Newline)) (cl:list ATOM_TYPE "3")))))))))))))
(cl:defmethod test-getForms-CLisp-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st (tl:_+_ (tl:_+_ "#t{(foo) ; comment" #\Newline) "             (boo)#t}")) (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE (tl:_+_ (tl:_+_ (tl:_+_ "(foo) ; comment" #\Newline) "             (boo)") #\Newline))))))))
(cl:defmethod test-getForms-Column-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=:a") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE ":a"))))))))))
(cl:defmethod test-getForms-Column-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=::a") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "::a"))))))))))
(cl:defmethod test-getForms-Column-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x= foo : a") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "foo:a"))))))))))
(cl:defmethod test-getForms-Column-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st ":x=a") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE ":x") (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-Column-5 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo{}:a") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-Column-6 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=('foo):a") ; have expr 'foo and expr :a - two expr together is illegal
 (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-Column-7 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x='foo:a") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list SHORTCUT_TYPE "'" (cl:list ATOM_TYPE "foo:a")))))))))))
(cl:defmethod test-getForms-ObjSlots-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x.a=y.a") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:slot-value") (cl:list ATOM_TYPE "x") (cl:list SHORTCUT_TYPE "'" (cl:list ATOM_TYPE "a"))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:slot-value") (cl:list ATOM_TYPE "y") (cl:list SHORTCUT_TYPE "'" (cl:list ATOM_TYPE "a"))))))))))))))
(cl:defmethod test-getForms-ObjSlots-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x.a=\"Hi\".\\
                     a") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:slot-value") (cl:list ATOM_TYPE "x") (cl:list SHORTCUT_TYPE "'" (cl:list ATOM_TYPE "a"))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:slot-value") (cl:list ATOM_TYPE "\"Hi\"") (cl:list SHORTCUT_TYPE "'" (cl:list ATOM_TYPE "a"))))))))))))))
(cl:defmethod test-getForms-ObjSlots-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x.a=y.
                a") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-ObjSlots-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x.a=y
               .a") (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-ObjMeth-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=y.foo{a,b}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-ObjMeth-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=y.foo{}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "y")))))))))))))
(cl:defmethod test-getForms-ObjMeth-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=y.foo()") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "y")))))))))))))
(cl:defmethod test-getForms-ObjMeth-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=y.foo(a,b)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-ObjMeth-5 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=y.foo(a,:b=67)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE ":b") (cl:list ATOM_TYPE "67")))))))))))))
(cl:defmethod test-getForms-Func-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo{a,b}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-Func-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo{}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))))))))))))
(cl:defmethod test-getForms-Func-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo()") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo")))))))))))))
(cl:defmethod test-getForms-Func-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo(a,b)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-Func-5 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x=foo(a,:b=67)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE ":b") (cl:list ATOM_TYPE "67")))))))))))))
(cl:defmethod test-getForms-InnerFuncCallList-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "foo(a,b=2, .(c=3,d) e,f)") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "2") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "c") (cl:list ATOM_TYPE "3") (cl:list ATOM_TYPE "d")))) (cl:list ATOM_TYPE "e") (cl:list ATOM_TYPE "f"))))))))))
(cl:defmethod test-getForms-Dict-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-hash-table_")))))))))))))
(cl:defmethod test-getForms-Dict-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={a,b
               c}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-hash-table_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "c") (cl:list ATOM_TYPE "cl:nil")))))))))))))
(cl:defmethod test-getForms-Dict-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={a,b->45
             c->\"Hi\"}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-hash-table_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "45") (cl:list ATOM_TYPE "c") (cl:list ATOM_TYPE "\"Hi\"")))))))))))))
(cl:defmethod test-getForms-Dict-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={a
             b->45-y}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-hash-table_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "b") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list ATOM_TYPE "45") (cl:list ATOM_TYPE "y"))))))))))))))))
(cl:defmethod test-getForms-Dict-5 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={a,->45
             c->\"Hi\"}") ; key is missing before '->'
 (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-Dict-6 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={a,b->
             c->\"Hi\"}") ; value is missing after '->'
 (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-Dict-7 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={ }") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-hash-table_")))))))))))))
(cl:defmethod test-getForms-Dict-8 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st (tl:_+_ (tl:_+_ "x={" #\Newline) " }")) (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-hash-table_")))))))))))))
(cl:defmethod test-getForms-Dict-9 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={a,b->45 ; comment
             c->\"Hi\"}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-hash-table_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "45") (cl:list ATOM_TYPE "c") (cl:list ATOM_TYPE "\"Hi\"")))))))))))))
(cl:defmethod test-getForms-Dict-10 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "x={a ;comment
             b->45
             c->\"Hi\"}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-hash-table_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "45") (cl:list ATOM_TYPE "c") (cl:list ATOM_TYPE "\"Hi\"")))))))))))))
(cl:defmethod test-getForms-Getitem-1 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[]") ; missing any index
 (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-Getitem-2 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[->]") ; missing any index
 (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-Getitem-3 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[->,2]") ; missing any index
 (cl:let (allElems) (cl:setf allElems (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getForms allElems (makeLevelInfo))))))
(cl:defmethod test-getForms-Getitem-4 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[2]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_getitem_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "2"))))))))))
(cl:defmethod test-getForms-Getitem-5 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[2->]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_getitem_") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-slice_") (cl:list ATOM_TYPE "2") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "cl:nil")))))))))))))
(cl:defmethod test-getForms-Getitem-6 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[->2]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_getitem_") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-slice_") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "2") (cl:list ATOM_TYPE "cl:nil")))))))))))))
(cl:defmethod test-getForms-Getitem-7 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[2->9]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_getitem_") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-slice_") (cl:list ATOM_TYPE "2") (cl:list ATOM_TYPE "9") (cl:list ATOM_TYPE "cl:nil")))))))))))))
(cl:defmethod test-getForms-Getitem-8 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[2->9,2]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_getitem_") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-slice_") (cl:list ATOM_TYPE "2") (cl:list ATOM_TYPE "9") (cl:list ATOM_TYPE "2")))))))))))))
(cl:defmethod test-getForms-Getitem-9 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[2->,2]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_getitem_") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-slice_") (cl:list ATOM_TYPE "2") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "2")))))))))))))
(cl:defmethod test-getForms-Getitem-10 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[->9,2]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_getitem_") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_make-slice_") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "9") (cl:list ATOM_TYPE "2")))))))))))))
(cl:defmethod test-getForms-Getitem-11 ((ts TestTranslFormBuilding)) (cl:let (st) (cl:setf st "a[1,2,3,4]") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_getitem_") (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:list") (cl:list ATOM_TYPE "1") (cl:list ATOM_TYPE "2") (cl:list ATOM_TYPE "3") (cl:list ATOM_TYPE "4")))))))))))))
