;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defclass TestTranslStringReading (unittest:testcase) ((unittest:tName :initform "TestTranslStringReading.twl") (unittest:tFuns :initform '(test-markElemsInStr-1 test-markElemsInStr-2 test-markElemsInStr-3 test-markElemsInStr-4 test-markElemsInStr-5 test-markElemsInStr-6 test-markElemsInStr-7 test-markElemsInStr-10 test-markElemsInStr-11 test-markElemsInStr-12 test-markElemsInStr-13 test-markElemsInStr-14 test-markElemsInStr-15 test-markElemsInStr-16 test-markElemsInStr-17 test-markElemsInStr-18 test-markElemsInStr-19 test-markElemsInStr-20 test-markElemsInStr-21 test-markElemsInStr-22 test-markElemsInStr-23 test-markElemsInStr-24 test-markElemsInStr-25 test-markElemsInStr-26 test-markElemsInStr-27 test-markElemsInStr-28 test-markElemsInStr-29 test-markElemsInStr-30 testGrowingVect))))
(cl:defmethod test-markElemsInStr-1 ((ts TestTranslStringReading)) ; note unix end line character
 (cl:let (st) (cl:setf st "  &lisp-symbol = foo(x,y)*.45  ; this is comment") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil) (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'lineNum) 0) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "lisp-symbol") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (cl:setf strElem (tl:_getitem_ res 5)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "foo") (cl:setf strElem (tl:_getitem_ res 6)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "(") (unittest:assertEqual ts (cl:slot-value strElem 'value) "(") (cl:setf strElem (tl:_getitem_ res 7)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 8)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ",") (unittest:assertEqual ts (cl:slot-value strElem 'value) ",") (cl:setf strElem (tl:_getitem_ res 9)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "y") (cl:setf strElem (tl:_getitem_ res 10)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ")") (unittest:assertEqual ts (cl:slot-value strElem 'value) ")") (cl:setf strElem (tl:_getitem_ res 11)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "*") (unittest:assertEqual ts (cl:slot-value strElem 'value) "*") (cl:setf strElem (tl:_getitem_ res 12)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) ".45") (cl:setf strElem (tl:_getitem_ res 13)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil) (cl:setf strElem (tl:_getitem_ res 14)) (unittest:assertEqual ts (cl:slot-value strElem 'type) COMM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "; this is comment") (cl:setf strElem (tl:_getitem_ res 15)) (unittest:assertEqual ts (cl:slot-value strElem 'type) LINE_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil)))))
(cl:defmethod test-markElemsInStr-2 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "  &+symbol = foo+\"Some string\"  ; this is comment") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil) (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "+symbol") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (cl:setf strElem (tl:_getitem_ res 5)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "foo") (cl:setf strElem (tl:_getitem_ res 6)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "+") (unittest:assertEqual ts (cl:slot-value strElem 'value) "+") (cl:setf strElem (tl:_getitem_ res 7)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_START_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "\"") (cl:setf strElem (tl:_getitem_ res 8)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "Some string\"") (cl:setf strElem (tl:_getitem_ res 9)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (cl:setf strElem (tl:_getitem_ res 10)) (unittest:assertEqual ts (cl:slot-value strElem 'type) COMM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "; this is comment") (cl:setf strElem (tl:_getitem_ res 11)) (unittest:assertEqual ts (cl:slot-value strElem 'type) LINE_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil)))))
(cl:defmethod test-markElemsInStr-3 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "foo==\"String spreads to several lines, has \\\"-quotes") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase STRING_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "foo") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "==") (unittest:assertEqual ts (cl:slot-value strElem 'value) "==") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_START_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "\"") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "String spreads to several lines, has \\\"-quotes" #\Newline))))))
(cl:defmethod test-markElemsInStr-4 ((ts TestTranslStringReading)) ; line of a multiline string
 (cl:let (st) (cl:setf st "string started before, and does not end here") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0 STRING_PHASE)) (unittest:assertEqual ts phase STRING_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "string started before, and does not end here" #\Newline)) (cl:setf st "") (cl:setf (cl:values res phase) (markElemsInStr st 0 STRING_PHASE)) (unittest:assertEqual ts phase STRING_PHASE) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "" #\Newline))))))
(cl:defmethod test-markElemsInStr-5 ((ts TestTranslStringReading)) ; line of a multiline string
 (cl:let (st) (cl:setf st "string started before, and ends here\"  ; some comment") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0 STRING_PHASE)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "string started before, and ends here\"") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) COMM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "; some comment")))))
(cl:defmethod test-markElemsInStr-6 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x[0]=&+$%^\\(-symbol(23.4)") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "[") (unittest:assertEqual ts (cl:slot-value strElem 'value) "[") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "0") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "]") (unittest:assertEqual ts (cl:slot-value strElem 'value) "]") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 5)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "+$%^\\(-symbol") (cl:setf strElem (tl:_getitem_ res 6)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "(") (unittest:assertEqual ts (cl:slot-value strElem 'value) "(") (cl:setf strElem (tl:_getitem_ res 7)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "23.4") (cl:setf strElem (tl:_getitem_ res 8)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ")") (unittest:assertEqual ts (cl:slot-value strElem 'value) ")")))))
(cl:defmethod test-markElemsInStr-7 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x=&&symbol[23.4]\\(()") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "&symbol[23.4]\\(") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "(") (unittest:assertEqual ts (cl:slot-value strElem 'value) "(") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ")") (unittest:assertEqual ts (cl:slot-value strElem 'value) ")")))))
(cl:defmethod test-markElemsInStr-10 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x=\"\"") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_START_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "\"") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) STR_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "\"")))))
(cl:defmethod test-markElemsInStr-11 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x=#b01010") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYNT_STRUCT_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "#b01010")))))
(cl:defmethod test-markElemsInStr-12 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x=(#\L,4)") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "(") (unittest:assertEqual ts (cl:slot-value strElem 'value) "(") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYNT_STRUCT_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "#\L") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ",") (unittest:assertEqual ts (cl:slot-value strElem 'value) ",") (cl:setf strElem (tl:_getitem_ res 5)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "4") (cl:setf strElem (tl:_getitem_ res 6)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ")") (unittest:assertEqual ts (cl:slot-value strElem 'value) ")")))))
(cl:defmethod test-markElemsInStr-13 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x=#'foo") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "#'") (unittest:assertEqual ts (cl:slot-value strElem 'value) "#'") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "foo")))))
(cl:defmethod test-markElemsInStr-14 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x!=#c(1.,2e-3)") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "!=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "!=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "#c") (unittest:assertEqual ts (cl:slot-value strElem 'value) "#c") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "(") (unittest:assertEqual ts (cl:slot-value strElem 'value) "(") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "1.") (cl:setf strElem (tl:_getitem_ res 5)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ",") (unittest:assertEqual ts (cl:slot-value strElem 'value) ",") (cl:setf strElem (tl:_getitem_ res 6)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "2e-3") (cl:setf strElem (tl:_getitem_ res 7)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ")") (unittest:assertEqual ts (cl:slot-value strElem 'value) ")")))))
(cl:defmethod test-markElemsInStr-15 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st " x = # C(1,2)") (unittest:assertCondition ts tl-syntax-error (markElemsInStr st 0)) (cl:setf st "x=#") (unittest:assertCondition ts tl-syntax-error (markElemsInStr st 0)) (cl:setf st "x=#(fg)") (unittest:assertCondition ts tl-syntax-error (markElemsInStr st 0)) (cl:setf st "x=#,fg") (unittest:assertCondition ts tl-syntax-error (markElemsInStr st 0))))
(cl:defmethod test-markElemsInStr-16 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x=#\\L()") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYNT_STRUCT_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "#\\L") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "(") (unittest:assertEqual ts (cl:slot-value strElem 'value) "(") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ")") (unittest:assertEqual ts (cl:slot-value strElem 'value) ")")))))
(cl:defmethod test-markElemsInStr-17 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x=3/4+3./4-.5f+7") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "3") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "/") (unittest:assertEqual ts (cl:slot-value strElem 'value) "/") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "4") (cl:setf strElem (tl:_getitem_ res 5)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "+") (unittest:assertEqual ts (cl:slot-value strElem 'value) "+") (cl:setf strElem (tl:_getitem_ res 6)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "3.") (cl:setf strElem (tl:_getitem_ res 7)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "/") (unittest:assertEqual ts (cl:slot-value strElem 'value) "/") (cl:setf strElem (tl:_getitem_ res 8)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "4") (cl:setf strElem (tl:_getitem_ res 9)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "-") (unittest:assertEqual ts (cl:slot-value strElem 'value) "-") (cl:setf strElem (tl:_getitem_ res 10)) (unittest:assertEqual ts (cl:slot-value strElem 'type) NUM_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) ".5f+7")))))
(cl:defmethod test-markElemsInStr-18 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "x=&lisp-pack:&lisp-symb") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "x") (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "=") (unittest:assertEqual ts (cl:slot-value strElem 'value) "=") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "lisp-pack") (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) ":") (unittest:assertEqual ts (cl:slot-value strElem 'value) ":") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "lisp-symb")))))
(cl:defmethod test-markElemsInStr-19 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "if a & b-c {") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "a") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "&") (unittest:assertEqual ts (cl:slot-value strElem 'value) "&") (cl:setf strElem (tl:_getitem_ res 5)) (unittest:assertEqual ts (cl:slot-value strElem 'type) WHITE_ELEM) (cl:setf strElem (tl:_getitem_ res 6)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "b") (cl:setf strElem (tl:_getitem_ res 7)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "-") (unittest:assertEqual ts (cl:slot-value strElem 'value) "-") (cl:setf strElem (tl:_getitem_ res 8)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "c")))))
(cl:defmethod test-markElemsInStr-20 ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st "if a &b-c {") (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr st 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "a") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "b-c")))))
(cl:defmethod test-markElemsInStr-21 ((ts TestTranslStringReading)) (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr "" 0)) (unittest:assertEqual ts phase REG_PHASE) (unittest:assertEqual ts (len res) 1) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) LINE_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil))))
(cl:defmethod test-markElemsInStr-22 ((ts TestTranslStringReading)) (cl:let (res phase) (cl:setf (cl:values res phase) (markElemsInStr "def foo(&def ){}" 0)) (unittest:assertEqual ts phase REG_PHASE) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SPEC_SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "def") (cl:setf strElem (tl:_getitem_ res 4)) (unittest:assertEqual ts (cl:slot-value strElem 'type) SYMB_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "def"))))
(cl:defmethod test-markElemsInStr-23 ((ts TestTranslStringReading)) (cl:let (res phase numOfClispLevel) (cl:setf (cl:values res phase numOfClispLevel) (markElemsInStr "#t{(+ 1 2)#t} - 3" 0)) (unittest:assertEqual ts phase REG_PHASE) (unittest:assertEqual ts numOfClispLevel 0) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_START_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil) (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "(+ 1 2)" #\Newline)) (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "-") (unittest:assertEqual ts (cl:slot-value strElem 'value) "-"))))
(cl:defmethod test-markElemsInStr-24 ((ts TestTranslStringReading)) (cl:let (res phase numOfClispLevel) (cl:setf (cl:values res phase numOfClispLevel) (markElemsInStr "#t{(+ 1 2) ;comment in lisp code#t}-3" 0)) (unittest:assertEqual ts phase REG_PHASE) (unittest:assertEqual ts numOfClispLevel 0) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_START_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil) (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "(+ 1 2) ;comment in lisp code" #\Newline)))))
(cl:defmethod test-markElemsInStr-25 ((ts TestTranslStringReading)) (cl:let (res phase numOfClispLevel) (cl:setf (cl:values res phase numOfClispLevel) (markElemsInStr "#t{(+ 1 2)" 0)) (unittest:assertEqual ts phase CLISP_PHASE) (unittest:assertEqual ts numOfClispLevel 1) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_START_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) cl:nil) (unittest:assertEqual ts (cl:slot-value strElem 'start) 0) (unittest:assertEqual ts (cl:slot-value strElem 'end) cl:nil) (unittest:assertEqual ts (cl:slot-value strElem 'lineNum) 0) (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "(+ 1 2)" #\Newline)))))
(cl:defmethod test-markElemsInStr-26 ((ts TestTranslStringReading)) (cl:let (res phase numOfClispLevel) (cl:setf (cl:values res phase numOfClispLevel) (markElemsInStr "(+ 1 2)  ;;comment" 0 CLISP_PHASE 3)) (unittest:assertEqual ts phase CLISP_PHASE) (unittest:assertEqual ts numOfClispLevel 3) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "(+ 1 2)  ;;comment" #\Newline)))))
(cl:defmethod test-markElemsInStr-27 ((ts TestTranslStringReading)) (cl:let (res phase numOfClispLevel) (cl:setf (cl:values res phase numOfClispLevel) (markElemsInStr "(+ 1 2)  ;;comment#t}" 0 CLISP_PHASE 1)) (unittest:assertEqual ts phase REG_PHASE) (unittest:assertEqual ts numOfClispLevel 0) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "(+ 1 2)  ;;comment" #\Newline)))))
(cl:defmethod test-markElemsInStr-28 ((ts TestTranslStringReading)) (cl:let (res phase numOfClispLevel) (cl:setf (cl:values res phase numOfClispLevel) (markElemsInStr "(+ 1 2)  ;;comment#t}" 0 CLISP_PHASE 3)) (unittest:assertEqual ts phase CLISP_PHASE) (unittest:assertEqual ts numOfClispLevel 2) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "(+ 1 2)  ;;comment#t}"))))
(cl:defmethod test-markElemsInStr-29 ((ts TestTranslStringReading)) (cl:let (res phase numOfClispLevel) (cl:setf (cl:values res phase numOfClispLevel) (markElemsInStr "#t{(+ 1 2)" 0 CLISP_PHASE 1)) (unittest:assertEqual ts phase CLISP_PHASE) (unittest:assertEqual ts numOfClispLevel 2) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) "#t{") (unittest:assertEqual ts (cl:slot-value strElem 'start) 0) (unittest:assertEqual ts (cl:slot-value strElem 'end) 3) (unittest:assertEqual ts (cl:slot-value strElem 'lineNum) 0) (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "(+ 1 2)" #\Newline)))))
(cl:defmethod test-markElemsInStr-30 ((ts TestTranslStringReading)) (cl:let (res phase numOfClispLevel) (cl:setf (cl:values res phase numOfClispLevel) (markElemsInStr "))#t}+#t{(+ 1 2)" 0 CLISP_PHASE 1)) (unittest:assertEqual ts phase CLISP_PHASE) (unittest:assertEqual ts numOfClispLevel 1) (cl:let (strElem) (cl:setf strElem (tl:_getitem_ res 0)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_END_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "))" #\Newline)) (cl:setf strElem (tl:_getitem_ res 1)) (unittest:assertEqual ts (cl:slot-value strElem 'type) "+") (cl:setf strElem (tl:_getitem_ res 2)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_START_ELEM) (cl:setf strElem (tl:_getitem_ res 3)) (unittest:assertEqual ts (cl:slot-value strElem 'type) CLISP_MID_ELEM) (unittest:assertEqual ts (cl:slot-value strElem 'value) (tl:_+_ "(+ 1 2)" #\Newline)))))
(cl:defmethod testGrowingVect ((ts TestTranslStringReading)) (cl:let (st) (cl:setf st (tl:_+_ (tl:_+_ (tl:_+_ (tl:_+_ "def foo(x,y) { ; definition of function" #\Newline) "    \"foo adds x and y\"") #\Newline) "    x+y}")) (cl:let (gv) (cl:setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertEqual ts (len gv) 13) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 0) 'value) "def") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 1) 'type) WHITE_ELEM) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 2) 'value) "foo") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 3) 'value) "(") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 4) 'value) "x") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 5) 'value) ",") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 6) 'value) "y") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 7) 'value) ")") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 8) 'type) WHITE_ELEM) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 9) 'value) "{") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 10) 'type) WHITE_ELEM) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 11) 'value) "; definition of function") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 12) 'type) LINE_END_ELEM) (growOnIndex gv 13) (unittest:assertEqual ts (len gv) 17) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 13) 'type) WHITE_ELEM) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 14) 'value) "\"") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 15) 'value) "foo adds x and y\"") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 16) 'type) LINE_END_ELEM) (growOnIndex gv 17) (unittest:assertEqual ts (len gv) 23) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 17) 'type) WHITE_ELEM) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 18) 'value) "x") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 19) 'value) "+") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 20) 'value) "y") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 21) 'value) "}") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv 22) 'type) LINE_END_ELEM) (growOnIndex gv 23) (unittest:assertEqual ts (len gv) 23) (unittest:assertCondition ts error (tl:_getitem_ gv 23)) (unittest:assertEqual ts (len (tl:_getitem_ gv (tl:_make-slice_ 10 20 cl:nil))) 10) (unittest:assertTrue ts (typep (tl:_getitem_ gv (tl:_make-slice_ 10 20 cl:nil)) 'vector)) (unittest:assertEqual ts (tl:_getitem_ (tl:_getitem_ gv (tl:_make-slice_ 10 20 cl:nil)) 0) (tl:_getitem_ gv 10)) (unittest:assertEqual ts (tl:_getitem_ (tl:_getitem_ gv (tl:_make-slice_ 10 20 cl:nil)) 5) (tl:_getitem_ gv 15)) (unittest:assertEqual ts (tl:_getitem_ (tl:_getitem_ gv (tl:_make-slice_ 10 20 cl:nil)) 9) (tl:_getitem_ gv 19)))))
