;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
;; Macro new
(defmacro new (c &rest rest) `(cond ((subtypep ',c 'condition) (make-condition ',c ,@rest)) (t (make-instance ',c ,@rest))))
;; TwinLisp's case
(defmacro tl-case (x elseForm &rest isForms) (let ((xval (gensym))) `(let ((,xval ,x)) (cond ,@(mapcar #'(lambda (isForm) `((_==_ ,xval ,(car isForm)) ,@(cdr isForm))) isForms) ,@(cond (elseForm `((t ,@elseForm))))))))
;; TwinLisp's for loop
(defmacro tl-for ((var cont &rest restVars) resFormsList &body body) (let ((it (gensym)) (nextPair (gensym))) `(do* ((,it (iter ,cont)) (,nextPair (multiple-value-list (next ,it)) (multiple-value-list (next ,it))) (,var (first ,nextPair) (first ,nextPair)) ,@restVars) ((_not_ (second ,nextPair)) ,@resFormsList) ,@body)))
;; Shorter names macros
(defmacro var (&rest rest) `(defvar ,@rest))
(defmacro param (&rest rest) `(defparameter ,@rest))
(defmacro const (&rest rest) `(defconstant ,@rest))
