;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
(defun formToText (form) (tl-case (_getitem_ form 0) ((error (_%_ "Programming error: unknown form type: ~A" (_getitem_ form 0)))) (ATOM_TYPE (_getitem_ form 1)) (FORM_TYPE (let (text) (setf text "") (tl-for (subForm (_getitem_ form 1)) (nil) (_+=_ text (_+_ (formToText subForm) " "))) (cond ((_>_ (len text) 0) (setf text (_getitem_ text (_make-slice_ 0 (_-_ (len text) 1) nil))))) ; strip one space at the end
 (_+_ (_+_ "(" text) ")"))) (COMMENT_TYPE (_+_ (_getitem_ form 1) #\Newline)) (SHORTCUT_TYPE (_+_ (_getitem_ form 1) (formToText (_getitem_ form 2))))))
(defun writeTo (form &optional (dest nil)) (let (text) (setf text (formToText form)) (cond ((_!=_ (_getitem_ text (_unary-_ 1)) #\Newline) (_+=_ text #\Newline))) (cond (dest (_<<_ dest text)) (t text))))
(defun translate-streams (source dest &optional (lineNumbering nil)) (tl-for (form (getForms (new GrowingVect :streamObj source) (makeLevelInfo :implScope t :explScopeWarn t) lineNumbering)) (nil) (writeTo form dest)))
(defun translate-file (fName destFName) (with-open-file (sourceFile fName :direction :input) (with-open-file (destFile destFName :direction :output) (translate-streams sourceFile destFile))))
(defclass ReaderWriter () ((firstLine :initform t) (inStream :initarg :inStream :initform *standard-input*) (outStream :initarg :outStream :initform *standard-output*)))
(defmethod __readLine ((rw ReaderWriter)) (cond ((slot-value rw 'firstLine) (_<<_ (slot-value rw 'outStream) ">>> ") (setf (slot-value rw 'firstLine) nil)) (t (_<<_ (slot-value rw 'outStream) "... "))) (__readLine (slot-value rw 'inStream)))
(defun translate (&optional (levelInfo (makeLevelInfo)) (source (new ReaderWriter))) (setf (slot-value source 'firstLine) t) (let (gL) (setf gL (new GrowingVect :streamObj source)) (cond ((_==_ (len gL) 0) ; this will be caused by Ctrl-D
 (_<<_ (_<<_ (_<<_ (slot-value source 'outStream) #\Newline) "Bye.") #\Newline) (throw :exit ()))) (cond ((_==_ (slot-value (_getitem_ gL 0) 'type) SYMB_ELEM) ; typing exit
 (cond ((_==_ (slot-value (_getitem_ gL 0) 'value) "exit") (_<<_ (_<<_ (slot-value source 'outStream) "Bye.") #\Newline) (throw :exit ()))))) (handler-case (progn (let (form) (setf form (getOneForm 0 gL levelInfo nil)) (cond (form (writeTo form)) (t (translate levelInfo source))))) (tl-syntax-error (er) (_<<_ (slot-value source 'outStream) (_%_ "SYNTAX ERROR:~%~A~%" er)) (translate levelInfo source)))))
(defun translate-files (fNames &optional (verbosity nil)) (tl-for (fName fNames) (nil) (let (destFName) (setf destFName (cond ((_==_ (_getitem_ fName (_make-slice_ (_-_ (len fName) 4) nil nil)) ".twl") (_+_ (_getitem_ fName (_make-slice_ 0 (_-_ (len fName) 4) nil)) ".lisp")) (t (_+_ fName ".lisp")))) (cond (verbosity (_<<_ (cout) (_%_ "~%Translating file ~A ..." fName)))) (handler-case (progn (translate-file fName destFName)) (tl-syntax-error (er) (_<<_ (cout) (_%_ "~%Syntax Error in file ~A:" fName)) (_<<_ (cout) (_%_ "~%~A~%" (slot-value er 'message))) (_<<_ (cout) (_%_ "File ~A is empty" destFName)) (return-from nil ()))) (cond (verbosity (_<<_ (cout) (_%_ "~%Wrote file ~A~%" destFName)))))))
