/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   exitmenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu prompts the player with a "Exit" menu
 *              used to quit the game definitely and return to linux/windows
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "exitmenu.h"
#include "mainmenu.h"
#include "button.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the exit menu
 */ 
U61_ExitMenu::U61_ExitMenu() : U61_Menu(NULL)
{
    add_item(new U61_Button("Exit"));
    add_item(new U61_Button("Back to U61"));
    select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * validate is called when the user presses enter
 */
U61_Menu *U61_ExitMenu::validate()
{
    U61_Menu *next_menu;

    next_menu=this;
    switch (selection)
    {
    case 0:
        next_menu=NULL;
        break;
    case 1:
        next_menu=new U61_MainMenu(this);
        break;
    }

    return next_menu;
}

/*--------------------------------------------------------------------------*/
/*
 * called when the user presses escape
 */
U61_Menu *U61_ExitMenu::back()
{
    return new U61_MainMenu(this);
}
