/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   localsource.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a local source is the event source used for local players
 *              it polls informations
 *              - from the keyboard
 *              - from the map (for new block management for instance)
 *              it also generates dummy events regularly so that there's
 *              not too wide a gap between the "last" and "sure" members
 *              of the map class
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "localsource.h"
#include "time.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a local event source
 */ 
U61_LocalSource::U61_LocalSource(U61_Input *i,U61_Map *m)
{
    input=i;
    input->reset();
    map=m;
    dummy_counter=0;
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a local event source
 */ 
U61_LocalSource::~U61_LocalSource()
{

}

/*--------------------------------------------------------------------------*/
/*
 * polls all the events, and sorts them by time
 */
void U61_LocalSource::poll()
{
    poll_input();
    poll_map();
    poll_dummy();
}

/*--------------------------------------------------------------------------*/
/*
 * send a start event, even if the key has not been pressed
 */
void U61_LocalSource::send_start_stop(int time)
{
    U61_Event evt;

    evt.time=time;
    evt.code=U61_Event::START_STOP;
    put(evt); 
}

/*--------------------------------------------------------------------------*/
/*
 * polls the action events, linked to a user action (key press etc...)
 */
void U61_LocalSource::poll_input()
{
    while (!input->empty())
    {
        put(input->get());
    }    
}

/*--------------------------------------------------------------------------*/
/*
 * polls the events that are automatically generated as time goes on
 */
void U61_LocalSource::poll_map()
{
    U61_Event evt;
 
    map->poll_auto_events();    
    while (map->exists_auto_event())
    {
        evt=map->get_auto_event();
        evt.time=U61_Time::for_event();
        put(evt);
    }
}

/*--------------------------------------------------------------------------*/
/*
 * fires dummy event which do nothing so that during local play, auto
 * events are correctly handled (ie one has to fire events now and then
 * so that the "sure" tab is sometimes updated :)
 */
void U61_LocalSource::poll_dummy()
{
    U61_Event evt;

    dummy_counter++;
    if (dummy_counter>=DUMMY_DELAY)
    {
        dummy_counter=0; 
        evt.code=U61_Event::NOTHING;
        evt.time=U61_Time::for_event();
        put(evt);
    } 
}
