/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   menu.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: abstract class, parent of all menus. it maintains the menu
 *              state (the selected item) and provides functions to center
 *              it and handle menuitems in a rational way
 */

#ifndef INC_U61_MENU
#define INC_U61_MENU

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "menuitem.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Menu
{
public:
    U61_Menu(U61_Menu *parent);
    virtual ~U61_Menu();
    
    U61_Menu *action(int key);
    virtual U61_Menu *validate();
    virtual U61_Menu *back();
    void draw();
    void select(int num_item);
    void select_up();
    void select_down();
    int get_height();
    int get_width();
    void add_item(U61_MenuItem *item);
    U61_Menu *get_parent();

protected:
    vector<U61_MenuItem *> items;
    U61_Menu *parent_menu;    
    int selection;
};

#endif
