/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   filemenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class allows the user to choose a file.
 *              it's designed to be subclassed by changing the
 *              constructor and validate function
 *              one has to tell:
 *              - which directory is to be scanned
 *              - what extensions the files to be scanned should have
 *              the extensions are removed from the files in the list
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "filemenu.h"
#include "button.h"
#include "platform.h"
#include "const.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the file menu
 */ 
U61_FileMenu::U61_FileMenu(U61_Menu *parent, char *top, char *dir, char *ext)
        : U61_Menu(parent, top)
{
    char *name;
    char buffer[U61_STRING_SIZE];
    bool exists=false;
    int len_buffer,len_ext;

    extension=ext;
    empty=false;

    len_ext=strlen(ext);
    if (U61_Platform::open_dir(dir,ext))
    {
        while ((name=U61_Platform::next_file())!=NULL)
        {
            strcpy(buffer,name);
            len_buffer=strlen(buffer);
            if (len_buffer>=len_ext)
            {
                buffer[len_buffer-len_ext]=0;
                add_item(new U61_Button(buffer));
                exists=true;
            }
        }
        U61_Platform::close_dir();
    }

    if (!exists)
    {
        add_item(new U61_Button("not found"));
        empty=true;
    }
    select(0);
}

/*--------------------------------------------------------------------------*/
/* 
 * retrieves the file name at a given index
 */ 
void U61_FileMenu::put_file_name(int i, char *buf)
{
    items[i]->put_text(buf);
    strcat(buf,extension);
}
