/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * This project is protected by the GPL, see copying.txt                    *
 *                                                                          *
 ****************************************************************************/

/* name:        menuinput.h
 * author       U-Foot (ufoot@bigfoot.com)
 * last update: February 2000
 * description: input class which handles menu events
 */

#ifndef INC_U61_MENUINPUT
#define INC_U61_MENUINPUT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "input.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_MenuInput : public U61_Input
{ 
public:
    U61_MenuInput();
    ~U61_MenuInput();
 
    void init();
    int reverse_scan_code(int ascii);
    char *get_label(int code);

    const static int KEY_LEFT=8;
    const static int KEY_RIGHT=9;
    const static int KEY_UP=11;
    const static int KEY_DOWN=10;
    const static int KEY_ENTER=13;
    const static int KEY_ESCAPE=0;
    const static int KEY_DELETE=20;
    const static int KEY_BACKSPACE=21;
protected:
    void set_menu_key(int i,int cl_code,int ascii,char *label);

    const static int NB_KEYS=80;
    const static int REPEAT_FIRST=50;
    const static int REPEAT_STANDARD=15;

    char *keys_label[NB_KEYS];
};

#endif
