/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   advancedkeymenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu is associated to a specific player
 *              it allows very accurate key settings
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "advancedkeymenu.h"
#include "keyspeed.h"
#include "global.h"
#include "menuinput.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the option menu
 */ 
U61_AdvancedKeyMenu::U61_AdvancedKeyMenu(U61_Menu *parent,
            U61_PlayerConfig *conf) 
    : U61_Menu(parent,"Advanced key settings")
{
    config=conf;
    add_item(new U61_KeySpeed("Delay 1 for left/right keys",
            &(config->first_repeat_move)));
    add_item(new U61_KeySpeed("Delay 2 for left/right keys",
            &(config->standard_repeat_move)));
    add_item(new U61_KeySpeed("Delay 1 for rotate keys",
            &(config->first_repeat_rotate)));
    add_item(new U61_KeySpeed("Delay 2 for rotate keys",
            &(config->standard_repeat_rotate)));
    add_item(new U61_KeySpeed("Delay 1 for other keys",
            &(config->first_repeat_other)));
    add_item(new U61_KeySpeed("Delay 2 for other keys",
            &(config->standard_repeat_other)));
    select(0);
}

