/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   script.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: wraps the LUA api to C++ and vice-versa
 *              all the interaction with lua is contained in this file
 *              it might be splited some day since it's getting *big*
 *              lua scripting is fundamental in u61. in fact all the
 *              rules of the game are coded in lua. this allows a 
 *              player/hacker  to write his own rules and test them
 *              right away without recompiling, and be quite
 *              "protection fault" safe
 */


#ifndef INC_U61_SCRIPT
#define INC_U61_SCRIPT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "block.h"
#include "map.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Script
{
public:
    static bool do_string(char *str);
    static bool do_file(char *file);
    static int get_global_int(char *name,int def=0);
    static char *get_global_str(char *name,char *def="");

    static bool init();

    static void block_shape(U61_Block *b,int type);
    static void block_rotate_left(U61_Block *b);
    static void block_rotate_right(U61_Block *b);
    static void block_move_left(U61_Block *b);
    static void block_move_right(U61_Block *b);
    static void block_move_down(U61_Block *b);
    static void block_land(U61_Map *m,U61_Block *b);
    static bool map_match_pattern(U61_Map *m);
    static void map_time_callback(U61_Map *m,U61_Block *b);

    static char *const LUA_BLOCK_SHAPE="user_block_shape";
    static char *const LUA_BLOCK_ROTATE_LEFT="user_block_rotate_left";
    static char *const LUA_BLOCK_ROTATE_RIGHT="user_block_rotate_right";
    static char *const LUA_BLOCK_MOVE_LEFT="user_block_move_left";
    static char *const LUA_BLOCK_MOVE_RIGHT="user_block_move_right";
    static char *const LUA_BLOCK_MOVE_DOWN="user_block_move_down";
    static char *const LUA_BLOCK_LAND="user_block_land";
    static char *const LUA_MAP_MATCH_PATTERN="user_map_match_pattern";
    static char *const LUA_MAP_TIME_CALLBACK="user_map_time_callback";

    static char *const C_BLOCK_RESET="u61_block_reset";
    static char *const C_BLOCK_CENTER="u61_block_center";
    static char *const C_BLOCK_GET_X="u61_block_get_x";
    static char *const C_BLOCK_GET_Y="u61_block_get_y";
    static char *const C_BLOCK_SET_X="u61_block_set_x";
    static char *const C_BLOCK_SET_Y="u61_block_set_y";
    static char *const C_BLOCK_ADD_ITEM="u61_block_add_square";
    static char *const C_BLOCK_GET_NB_ITEMS="u61_block_get_nb_squares";
    static char *const C_BLOCK_GET_ITEM_X="u61_block_get_square_x";
    static char *const C_BLOCK_GET_ITEM_Y="u61_block_get_square_y";
    static char *const C_BLOCK_GET_ITEM_COLOR="u61_block_get_square_color";
    static char *const C_BLOCK_SET_ITEM_X="u61_block_set_square_x";
    static char *const C_BLOCK_SET_ITEM_Y="u61_block_set_square_y";
    static char *const C_BLOCK_SET_ITEM_COLOR="u61_block_set_square_color";
    static char *const C_MAP_GET_WIDTH="u61_map_get_width";
    static char *const C_MAP_GET_HEIGHT="u61_map_get_height";
    static char *const C_MAP_GET_SQUARE_COLOR="u61_map_get_square_color";
    static char *const C_MAP_SET_SQUARE_COLOR="u61_map_set_square_color";
    static char *const C_MAP_GET_TIME="u61_map_get_time";
    static char *const C_MAP_GET_NB_GAMES="u61_map_get_nb_games";
    static char *const C_MAP_GET_SCORE="u61_map_get_score";
    static char *const C_MAP_SET_SCORE="u61_map_set_score";
    static char *const C_MAP_ADD_SCORE="u61_map_add_score";
    static char *const C_MAP_GET_GLOBAL="u61_map_get_global";
    static char *const C_MAP_SET_GLOBAL="u61_map_set_global";
    static char *const C_MAP_GET_PREVISION_STATE="u61_map_get_prevision_state";
    static char *const C_MAP_SET_PREVISION_STATE="u61_map_set_prevision_state";
    static char *const C_MAP_GET_PREVIEW_STATE="u61_map_get_preview_state";
    static char *const C_MAP_SET_PREVIEW_STATE="u61_map_set_preview_state";

protected:
    static void secure_pointers();
    static void record_all();
};

#endif
