/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   toggle.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a menu item with 2 values, when pressing enter the 
 *              value changes. usefull to create a "on/off" button
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>

#include "menuinput.h"
#include "toggle.h"
#include "const.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'toggable' item
 */ 
U61_Toggle::U61_Toggle(char *label, bool *val,
                       char *txt_true, char *txt_false) : U61_MenuItem()
{
    name=label;
    value=val;
    text_true=txt_true;
    text_false=txt_false;
    update();
}

/*--------------------------------------------------------------------------*/
/*
 * updates the text displayed so that it reflects the value of the item
 */
void U61_Toggle::update()
{
    char buffer[U61_STRING_SIZE];
    char *end;

    /*
     * chooses the text associated to the value
     */
    end="out of range";
    if ((*value)) 
    {
        end=text_true;
    }
    else 
    {
        end=text_false;
    }

    /*
     * we want the text in the item to look like "blablabla is on"
     */
    strcpy(buffer,name);
    strcat(buffer," ");
    strcat(buffer,end);

    /*
     * puts the prepared string in the label
     */
    set_text(buffer);
}

/*--------------------------------------------------------------------------*/
/*
 * toggles the value
 */
void U61_Toggle::toggle()
{
    (*value)=!(*value);
    update();
}

/*--------------------------------------------------------------------------*/
/*
 * callback for key presses
 */
bool U61_Toggle::action(int key)
{
    bool changed=false;

    switch (key)
    {
    case U61_MenuInput::KEY_LEFT:
    case U61_MenuInput::KEY_RIGHT:
    case U61_MenuInput::KEY_ENTER:
        changed=true;
        toggle();
        break;
    }

    return changed;
}

/*--------------------------------------------------------------------------*/
/*
 * selection of the item (only selects the value)
 */
void U61_Toggle::select()
{
    int start;

    start=strlen(name);

    select_right(start);
}

