/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   block.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class is used to handle and draw blocks 
 *              a block is basically a set of squares put together
 *              it usually has a recognizable shape 
 */

#ifndef INC_U61_BLOCK
#define INC_U61_BLOCK

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "blockitem.h"
#include "data.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Block
{
public:
    U61_Block();
    ~U61_Block();
    
    void shape(int s);
    void rotate_left();
    void rotate_right();
    void move_left();
    void move_right();
    void move_down();

    void reset();

    int get_x();
    int get_y();
    void set_x(int x);
    void set_y(int y);

    void add_item(int x,int y,int type);
    int get_nb_items();

    int get_item_x(int i);
    int get_item_y(int i);
    int get_item_color(int i);

    void set_item_x(int i,int x);
    void set_item_y(int i,int y);
    void set_item_color(int i,int color);

    U61_BlockItem *get_item(int i);

    void center();
    void corner();

    void draw(int x,int y,int size=U61_Data::SIZE_BIG);
    void draw_preview(int x,int y,int size=U61_Data::SIZE_BIG);
    void draw_prevision(int x,int y,int size=U61_Data::SIZE_BIG);
    
    static const int MAX_ITEMS=100;
    static const int MAX_SHAPE=10000;
protected:
    static const int PREVIEW_WIDTH=16;
    static const int PREVIEW_HEIGHT=16;
    U61_BlockItem items[MAX_ITEMS];
    int nb_items;
    int pos_x;
    int pos_y;
};

#endif
