/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   connection.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the connection object is a low-level wrapper over
 *              ClanLib's network API, it's the equivalent of a socket
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "connection.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * creates a connection
 */
U61_Connection::U61_Connection(CL_NetGame *g,CL_NetComputer *c,int ch)
{
  game=g;
  channel=ch;

  group.computers.push_back(c);
  /*
   * for now I decided to authorize anyone to communicate on the channel
   * since I'm not so concerned about u61's security 8-)
   */
  try 
    {
      game->set_access(ch,&group,
            ACCESS_CHANNEL_READ|ACCESS_CHANNEL_WRITE);
      // cout<<"Connection access granted\n";
    }
  catch (CL_Error e)
    {
      cout<<"Access error : "<<e.message<<"\n";
    }
}

/*--------------------------------------------------------------------------*/
/*
 * deletes a connection
 */
U61_Connection::~U61_Connection()
{
  close();
}

/*--------------------------------------------------------------------------*/
/*
 * sends a packet on the connection.
 * returns false if the sending operation failed
 */
bool U61_Connection::send(U61_Packet *p)
{
  int size;
  bool result=true;

  size=p->size;
  if (size>U61_Packet::MAX_DATA)
    {
      size=U61_Packet::MAX_DATA;
    }

  CL_NetMessage message(p->data,size);

  try
    {
      game->send(channel,&group,message,true);
    }
  catch (CL_Error e)
    {
      result=false;
      cout<<"Send error : "<<e.message<<"\n";
    }

  return result;
}
   
/*--------------------------------------------------------------------------*/
/*
 * returns true if there's a packet available on this connection
 */
bool U61_Connection::peek()
{
  bool result=false;
  
  result=game->peek(channel);

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * returns true if there's a packet available on this connection
 */
bool U61_Connection::recv(U61_Packet *p)
{
  CL_NetMessage message;
  int size;
  bool result=true;

  try 
    {
      message=game->receive(channel,-1);

      size=message.data.size();
      if (size>U61_Packet::MAX_DATA)
	{
	  size=U61_Packet::MAX_DATA;
	}

      p->size=size;
      memcpy(p->data,message.data.data(),size);
    }
  catch (CL_Error e)
    {
      result=false;
      cout<<"Receive error : "<<e.message<<"\n";    
    }
  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * closes the connection
 */
void U61_Connection::close()
{

}




