/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   map.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: I called this class map for I can't imagine a game without
 *              a "map" class 8) . seriously, a map is where the information
 *              about where the blocks are is stored. it's basically an array
 *              of squares.
 *              it also provides an API to move the player's falling block
 *              and handle any event.
 *              it's important to note that most of the behaviors of a map
 *              are determined by embedded LUA scripts
 */

#ifndef INC_U61_MAP
#define INC_U61_MAP

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "square.h"
#include "block.h"
#include "event.h"
#include "data.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Map
{ 
public:
    U61_Map();
    ~U61_Map();  

    void reset(int s,int a);
    void clear();
    void begin();
    void handle_event(U61_Event event);
    void anticipate(int time);

    void poll_auto_events();
    U61_Event get_auto_event();
    bool exists_auto_event();

    void set_background(int bg);
    int get_background();
    void set_square_color(int x,int y,int color);
    int get_square_color(int x,int y);

    void set_score(int s);
    int get_score();
    int get_best_score();
    void add_score(int s);
    int get_time();
    int get_nb_games();
    int get_match_count();
    void set_global(int i,int glob);
    int get_global(int i);

    void draw(int x,int y, 
              int size=U61_Data::SIZE_BIG,
              bool prev=false);

    void mute();

    bool is_active();
    void set_active(int time);
    void set_inactive();

    void set_prevision_state(bool state);
    bool get_prevision_state();

    void set_preview_state(bool state);
    bool get_preview_state();

    void set_speed(int s);
    int get_speed();

    void set_accel(int a);
    int get_accel();

    void blow_up_square(int x, int y);
    bool is_square_exploding(int x,int y);
    bool exists_explosion();

    U61_Block get_next_block();

    static const int WIDTH=10;
    static const int HEIGHT=25;
    static const int NB_GLOBAL=1000;
    static const int SPEED_SCALE=1000;
    static const int ACCEL_SCALE=100000;
    static const int TIME_CALLBACK_DELAY=10;
    static const int MAX_USER_SPEED=20;
    static const int MAX_USER_ACCEL=10;
    static const int MAX_SYSTEM_SPEED=50;
    static const int MAX_SYSTEM_ACCEL=15;
protected:
    static const int speeds[MAX_SYSTEM_SPEED+1];
    static const int accels[MAX_SYSTEM_ACCEL+1];

    U61_Square squares[WIDTH][HEIGHT];
    U61_Block block;
    U61_Block next_block;
    U61_Block block_prevision;
    list<U61_Event> auto_events;
    int global_val[NB_GLOBAL];

    int background;
    bool active;
    bool silent;
    int map_time;
    bool block_requested;
    bool matching;
    int speed_counter;
    int accel_counter;
    int speed;
    int accel;
    int base_speed;
    int base_accel;
    int score;
    int best_score;
    int games;
    int match_count;
    bool prevision_state;
    bool preview_state;

    void compute_next();
    void update_speed();
    void compute_up_to(int time);
    void put_auto_event(U61_Event event);

    void draw_prevision(int x,int y, int size=U61_Data::SIZE_BIG);

    void block_rotate_left();
    void block_rotate_right();
    void block_move_left();
    void block_move_right();
    void block_move_down();
    void block_drop();

    bool is_block_active();
    bool is_block_ok(U61_Block *test);
  
    void new_block(int shape);
    void stabilize_block();
    void loose();

    void match_pattern();
    void time_callback();

    void check_speed();
    void check_accel();

    void update_explosions();
};

#endif
