/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   menuitem.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: abstract class, parent of all menu items
 *              fondamentaly, a menu item is a line in a menu
 *              this line is made of letters, stored in a array
 *              the menu item will basically handle key presses
 *              and modify
 *              - its display
 *              - some parameter in the config object
 *              special events may open another menu or go back
 *              of course the class provides a "draw" function
 *              and automatically centers itself
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "menuitem.h"
#include "global.h"
#include "letter.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * generation of a default menu item
 */ 
U61_MenuItem::U61_MenuItem()
{
    U61_MenuItem("Default menu item");
}

/*--------------------------------------------------------------------------*/
/* 
 * generation of a default menu item
 */ 
U61_MenuItem::U61_MenuItem(char *str)
{
    set_text(str);
    unselect();
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of the menu-item
 */ 
U61_MenuItem::~U61_MenuItem()
{

}

/*--------------------------------------------------------------------------*/
/*
 * treats a key press on a menu item
 */
bool U61_MenuItem::action(int key)
{
    //cout<<"menu item action"<<key<<"\n"; 
    return false;
}

/*--------------------------------------------------------------------------*/
/*
 * updates the text so that it is up to date
 */
void U61_MenuItem::update()
{

}

/*--------------------------------------------------------------------------*/
/*
 * draws a menu item
 */
void U61_MenuItem::draw(int y)
{
    int x;
    int i;
    int nb_letter;
    int last_letter_width2;
    int letter_width;

    x=U61_Global::data.screen_w/2;

    x-=get_width()/2;
    last_letter_width2=0;

    nb_letter=text.size();    
    for (i=0;i<nb_letter;++i)
    {
        letter_width=text[i].get_width();
        
        x+=last_letter_width2+letter_width/2;
        text[i].draw(x,y);
        last_letter_width2=letter_width-letter_width/2;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * returns the height of the menu item
 */
int U61_MenuItem::get_height()
{
    int i;
    int nb_letter;
    int height=0;

    nb_letter=text.size();
    for (i=0;i<nb_letter;++i)
    {
        height=max(text[i].get_height(),height);
    }

    return height;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the width of the menu item
 */
int U61_MenuItem::get_width()
{
    int i;
    int nb_letter;
    int width=0;

    nb_letter=text.size();
    for (i=0;i<nb_letter;++i)
    {
        width+=text[i].get_width();
    }

    return width;
}

/*--------------------------------------------------------------------------*/
/*
 * selects a letter in the current menu item 
 */
void U61_MenuItem::select_char(int i)
{
    text[i].enable_dance();
}

/*--------------------------------------------------------------------------*/
/*
 * selects the current menu item, starting at a given letter
 */
void U61_MenuItem::select_right(int start)
{
    int i;
    int nb_letter;
    
    nb_letter=text.size();
    for (i=start;i<nb_letter;++i)
    {
        select_char(i);
    }
}

/*--------------------------------------------------------------------------*/
/*
 * selects the current menu item
 */
void U61_MenuItem::select()
{
    select_right(0);
}

/*--------------------------------------------------------------------------*/
/*
 * unselects the current menu item
 */
void U61_MenuItem::unselect()
{
    int i;
    int nb_letter;
    
    nb_letter=text.size();
    for (i=0;i<nb_letter;++i)
    {
        text[i].disable_dance();
    }
}

/*--------------------------------------------------------------------------*/
/*
 * sets the text of the menu item
 */
void U61_MenuItem::set_text(char *str)
{
    text.clear();
    /*
     * we fill the vector of letters with the chars of the string
     * passed in arg, this will simply create a menu item that
     * display the string
     */
    while(*str)
    {
        text.push_back(U61_Letter(U61_Global::data.font_menu,*str));
        str++;
    } 
}

/*--------------------------------------------------------------------------*/
/*
 * puts the text in a string buffer
 */
void U61_MenuItem::put_text(char *buf)
{
    int i;
    int nb_letter;
    char c;
    
    nb_letter=text.size();
    for (i=0;i<nb_letter;++i)
    {
        c=text[i].get_ascii();
        buf[i]=c;
    }
    buf[i]=0;
}

/*--------------------------------------------------------------------------*/
/*
 * true if the menuitem must handle all keys, including vertical arrows
 */
bool U61_MenuItem::is_modal()
{ 
    return false;
}
