/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   packet.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a packet is an item sent over the network.
 *              it has:
 *              - a type
 *              - a size
 *              - a content
 *              this class is very usefull to implement a simple to
 *              understand 8-)
 */

#ifndef INC_U61_PACKET
#define INC_U61_PACKET

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "event.h"
#include "packet.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Packet
{
 public:
  U61_Packet();
  ~U61_Packet();

  static const int MAX_DATA=256;


  static const int SYSTEM=0;
  static const int DUMMY=1;
  static const int INIT=2;
  static const int EVENT=3;
  static const int CURSE_REQUEST=4;

  short type;
  short size;
  char data[MAX_DATA];   

  bool is_event();
  void set_event(U61_Event e);
  U61_Event get_event(); 

 protected:
};

#endif
