/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   platformunix.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: contains unix-specific code.
 *              for instance, the directory used for data storing are
 *              different under linux or windows
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <sys/types.h>
#include <dirent.h>
#include <stdlib.h>

#include "platform.h"
#include "const.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * global variables for directory scan functions
 */
static DIR *scan_dir=NULL;
static char *scan_ext=NULL;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * returns the home path of the user /home/ufoot for instance
 */
char *U61_Platform::get_config_file()
{
    static char buffer[U61_STRING_SIZE]; 
    int len;

    strcpy (buffer,getenv("HOME"));
    len=strlen(buffer);
    if (len>0)
    {
        if (buffer[len-1]!='/')
        {
            strcat(buffer,"/");
        } 
    }
    strcat (buffer,".u61rc");
//    cout<<"config file: "<<buffer<<"\n";

    return buffer;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the /usr/local/share/u61 path or something like that
 */
char *U61_Platform::get_data_path()
{
    static char buffer[U61_STRING_SIZE]; 
    int len;


    strcpy (buffer,INSTALL_DATA_PATH);
    len=strlen(buffer);
    if (len>0)
    {
        if (buffer[len-1]!='/')
        {
            strcat(buffer,"/");
        } 
    }
//   cout<<"data path: "<<buffer<<"\n";

    return buffer;
}

/*--------------------------------------------------------------------------*/
/*
 * opens a directory for file scanning
 */
bool U61_Platform::open_dir(char *dir, char *ext)
{
    bool ok=false;

    scan_ext=ext;
    scan_dir=opendir(dir);
    if (scan_dir!=NULL)
    {
        ok=true;
    }

    return ok;
}

/*--------------------------------------------------------------------------*/
/*
 * retrieves the next file in the directory
 */
char *U61_Platform::next_file()
{
    char *name=NULL;
    struct dirent *d;
    bool end=false;
    int len1,len2;

    do 
    {
        d=readdir(scan_dir);
        if (d==NULL)
        {
            name=NULL;
            end=true;
        }
        else
        {
            name=d->d_name;
            len1=strlen(name); 
            len2=strlen(scan_ext); 
            if (len2<=len1)
            {
                if (strcasecmp(name+len1-len2,scan_ext)==0)
                {
                    end=true;
                }
            }
        }
    }
    while (!end);

    return name;
}

/*--------------------------------------------------------------------------*/
/*
 * closes the directory
 */
bool U61_Platform::close_dir()
{
    bool ok=false;

    if (closedir(scan_dir)==0)
    {
        ok=true;
    }
 
    return ok;
}
