/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   serverprotocol.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: welcomes a client, gets basic information about him
 *              and sends him all the informations about
 *              the players which are already playing
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "serverprotocol.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * creates a server protocol
 */
U61_ServerProtocol::U61_ServerProtocol(U61_ServerDispatcher *d, int p,int ch)
  : U61_Protocol(p,ch)
{
  int i;

  dispatcher=d;

  for (i=0;i<U61_Game::NB_NET_GROUPS-1;++i)
    {
      connection[i]=NULL;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * deletes the protocol object
 */
U61_ServerProtocol::~U61_ServerProtocol()
{
  int i;

  for (i=0;i<U61_Game::NB_NET_GROUPS-1;++i)
    {
      if (connection[i]!=NULL)
	{
	  delete connection[i];
	}
    }
}

/*--------------------------------------------------------------------------*/
/*
 * sends the next packet. sometimes there's not really a packet send but
 * the point is to identify the sequence of messages to send to the client
 */
int U61_ServerProtocol::send_next_packet()
{
  int result=LATER;

  switch(stage)
    {
    case BEGIN:
      if ((result=start_listening())==DONE)
	{
	  stage=LISTENING;
          cout<<"stage=LISTENING\n";
	}
      break;
    case CLIENT_ACCEPTED:
      if ((result=send_id(connection[new_connection]))==DONE)
	{
	  stage=ID_SENT;
          cout<<"stage=ID_SENT\n";
	}
      break;
    case ID_RECEIVED:
      if ((result=send_version(connection[new_connection]))==DONE)
	{
	  stage=VERSION_SENT;
          cout<<"stage=VERSION_SENT\n";
	}
      break;
    case VERSION_RECEIVED:
      // cout<<"ok\n";
      break;
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * receives the next packet. sometimes there's not really a packet send but
 * the point is to identify the sequence of messages to receive from the
 * client
 */
int U61_ServerProtocol::recv_next_packet()
{
  int result=LATER;

  switch(stage)
    {
    case LISTENING:
      if ((result=accept_client())==DONE)
	{
	  stage=CLIENT_ACCEPTED;
          cout<<"stage=CLIENT_ACCEPTED\n";
	}
      break;
    case ID_SENT:
      if ((result=recv_id(connection[new_connection]))==DONE)
	{
	  stage=ID_RECEIVED;
          cout<<"stage=ID_RECEIVED\n";
	}
      break;
    case VERSION_SENT:
      if ((result=recv_version(connection[new_connection]))==DONE)
	{
          stage=VERSION_RECEIVED;
          cout<<"stage=VERSION_RECEIVED\n";
	}
    }
  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * starts listening what's happening on the network, in case a computer wishes
 * to connect itself
 */
int U61_ServerProtocol::start_listening()
{
  int result=FAILED;

  //  cout<<"start listening\n";

  game=CL_Network::create_game(GAME_ID,port);

  if (game!=NULL)
    {
      result=DONE;
    };

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * detects a computer, ie accepts to dialog with it, it does not mean that
 * the players on this remote machine will actually be accepted in the
 * game but at least we'll dialog with them 
 */
int U61_ServerProtocol::accept_client()
{
  int result=LATER;
  const CL_NetComputer *computer;

  if ((computer=game->receive_computer_join())!=NULL)
    {
      if ((new_connection=get_free_connection())<0)
	{
          result=FAILED;
	}
      else
	{  
          /*
           * There's a connection available to talk with the client
           * so we can discuss with him.
           * It should be important to check when the computer
           * object is deleted by the way...
           */
          connection[new_connection]=new 
              U61_Connection(game,(CL_NetComputer *) computer,channel);        
	  result=DONE;
	}
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the index of a free connection in the connection array, if
 * no connection is available it just returns a <0 value
 */
int U61_ServerProtocol::get_free_connection()
{
  int i;
  int result=-1;

  for (i=0;i<U61_Game::NB_NET_GROUPS-1;++i)
    {
      if (connection[i]==NULL)
	{
          result=i;
          break;
	}
    }

  return result;
}

